/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.stardog.stark.Axiom;
import com.stardog.stark.IRI;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AxiomImpl
implements Axiom {
    private final Resource mRoot;
    private final ImmutableSet<Statement> mGraph;

    protected AxiomImpl(Resource theRoot, @Nonnull Set<Statement> theStatements) {
        this.mRoot = theRoot;
        this.mGraph = ImmutableSet.copyOf(theStatements);
    }

    protected AxiomImpl(@Nonnull Axiom theAxiom) {
        this.mRoot = theAxiom.mainNode();
        this.mGraph = ImmutableSet.copyOf((Iterable)theAxiom);
    }

    @Override
    @Nullable
    public Resource mainNode() {
        return this.mRoot;
    }

    @Nonnull
    public Set<Statement> graph() {
        return this.mGraph;
    }

    @Override
    public Iterator<Statement> iterator() {
        return this.graph().iterator();
    }

    @Nonnull
    public static AxiomBuilder builder() {
        return new AxiomBuilder(null);
    }

    @Nonnull
    public static AxiomBuilder builder(@Nullable Resource theIndividual) {
        return new AxiomBuilder(theIndividual);
    }

    @Nonnull
    public static AxiomBuilder builder(@Nonnull Axiom theAxiom) {
        return AxiomImpl.builder(theAxiom.mainNode()).add(theAxiom);
    }

    public static Axiom of(@Nonnull Resource theSubj, @Nonnull IRI thePred, @Nonnull Axiom theObj) {
        return AxiomImpl.builder(theSubj).add(thePred, theObj).build();
    }

    public static Axiom of(@Nonnull Resource theSubj, @Nonnull IRI thePred, @Nonnull Value theObj) {
        return AxiomImpl.builder(theSubj).add(thePred, theObj).build();
    }

    public static final class AxiomBuilder {
        private Set<Statement> mGraph = new HashSet<Statement>();
        private Resource mRoot;

        public AxiomBuilder(@Nullable Resource theRoot) {
            this.mRoot = theRoot;
        }

        @Nonnull
        public AxiomBuilder add(@Nonnull Axiom theAxiom) {
            theAxiom.forEach(this.mGraph::add);
            return this;
        }

        @Nonnull
        public AxiomBuilder add(@Nonnull Statement theStmt) {
            this.mGraph.add(theStmt);
            return this;
        }

        @Nonnull
        public AxiomBuilder add(@Nonnull Resource theSubject, @Nonnull IRI thePredicate, @Nonnull Value theObject) {
            this.mGraph.add(Values.statement(theSubject, thePredicate, theObject));
            return this;
        }

        @Nonnull
        public AxiomBuilder addAll(@Nonnull Iterable<Statement> theStmts) {
            theStmts.forEach(this.mGraph::add);
            return this;
        }

        @Nonnull
        public AxiomBuilder add(@Nonnull IRI thePredicate, @Nonnull Value theObject) {
            Preconditions.checkState((this.mRoot != null ? 1 : 0) != 0, (Object)"Cannot add relative statements to an expression without a root");
            this.mGraph.add(Values.statement(this.mRoot, thePredicate, theObject));
            return this;
        }

        @Nullable
        public Resource mainNode() {
            return this.mRoot;
        }

        @Nonnull
        public AxiomBuilder add(@Nonnull IRI thePred, @Nonnull Axiom theExpression) {
            Preconditions.checkState((this.mRoot != null ? 1 : 0) != 0, (Object)"Cannot add statements to an axiom without a root");
            Preconditions.checkArgument((theExpression.mainNode() != null ? 1 : 0) != 0, (Object)"Cannot add a child axiom without a main node");
            this.add(thePred, theExpression.mainNode());
            this.add(theExpression);
            return this;
        }

        @Nonnull
        public Axiom build() {
            if (this.mRoot == null && this.mGraph.size() == 1) {
                this.mRoot = ((Statement)Iterables.getOnlyElement(this.mGraph)).subject();
            }
            return new AxiomImpl(this.mRoot, this.mGraph);
        }
    }
}

