/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark;

import com.stardog.stark.Datatype;
import com.stardog.stark.IRI;
import com.stardog.stark.Literal;
import com.stardog.stark.Values;
import com.stardog.stark.XMLDateTime;
import com.stardog.stark.util.ASCIIUtil;
import java.util.EnumSet;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;
import javax.xml.datatype.XMLGregorianCalendar;

public final class XMLDatatypes {
    public static final EnumSet<Datatype> PRIMITIVES = EnumSet.of(Datatype.DURATION, new Datatype[]{Datatype.DATETIME, Datatype.TIME, Datatype.DATE, Datatype.GYEAR, Datatype.GYEARMONTH, Datatype.GMONTH, Datatype.GMONTHDAY, Datatype.GDAY, Datatype.STRING, Datatype.BOOLEAN, Datatype.BASE64BINARY, Datatype.HEXBINARY, Datatype.FLOAT, Datatype.DECIMAL, Datatype.DOUBLE, Datatype.ANYURI, Datatype.QNAME, Datatype.NOTATION, Datatype.DATETIMESTAMP});
    public static final EnumSet<Datatype> DERIVED = EnumSet.of(Datatype.NORMALIZEDSTRING, new Datatype[]{Datatype.TOKEN, Datatype.LANGUAGE, Datatype.NMTOKEN, Datatype.NMTOKENS, Datatype.NAME, Datatype.NCNAME, Datatype.ID, Datatype.IDREF, Datatype.IDREFS, Datatype.ENTITIES, Datatype.ENTITY, Datatype.INT, Datatype.INTEGER, Datatype.LONG, Datatype.SHORT, Datatype.BYTE, Datatype.NON_NEGATIVE_INTEGER, Datatype.NON_POSITIVE_INTEGER, Datatype.NEGATIVE_INTEGER, Datatype.POSITIVE_INTEGER, Datatype.UNSIGNED_BYTE, Datatype.UNSIGNED_INT, Datatype.UNSIGNED_LONG, Datatype.UNSIGNED_SHORT});
    public static final EnumSet<Datatype> INTEGERS = EnumSet.of(Datatype.INTEGER, new Datatype[]{Datatype.LONG, Datatype.INT, Datatype.SHORT, Datatype.BYTE, Datatype.NON_POSITIVE_INTEGER, Datatype.NON_NEGATIVE_INTEGER, Datatype.NEGATIVE_INTEGER, Datatype.POSITIVE_INTEGER, Datatype.UNSIGNED_LONG, Datatype.UNSIGNED_INT, Datatype.UNSIGNED_BYTE, Datatype.UNSIGNED_SHORT});
    public static final EnumSet<Datatype> FP = EnumSet.of(Datatype.FLOAT, Datatype.DOUBLE);
    public static final EnumSet<Datatype> CALENDAR = EnumSet.of(Datatype.DATETIME, new Datatype[]{Datatype.TIME, Datatype.DATE, Datatype.GYEAR, Datatype.GYEARMONTH, Datatype.GMONTH, Datatype.GMONTHDAY, Datatype.GDAY, Datatype.DATETIMESTAMP});
    public static final EnumSet<Datatype> DURATIONS = EnumSet.of(Datatype.DURATION, Datatype.DURATION_DAYTIME, Datatype.DURATION_YEARMONTH);
    public static final String GYEARMONTH_REGEX = "-?\\d\\d\\d\\d-\\d\\d(Z|(\\+|-)\\d\\d:\\d\\d)?";
    public static final String GYEAR = "-?\\d\\d\\d\\d(Z|(\\+|-)\\d\\d:\\d\\d)?";
    public static final String GMONTHDAY = "--\\d\\d-\\d\\d(Z|(\\+|-)\\d\\d:\\d\\d)?";
    public static final String GMONTH = "--\\d\\d(Z|(\\+|-)\\d\\d:\\d\\d)?";
    public static final String GDAY = "---\\d\\d(Z|(\\+|-)\\d\\d:\\d\\d)?";
    public static final String TIME = "\\d\\d:\\d\\d:\\d\\d(\\.\\d+)?(Z|(\\+|-)\\d\\d:\\d\\d)?";
    public static final String DATE = "-?\\d\\d\\d\\d-\\d\\d-\\d\\d(Z|(\\+|-)\\d\\d:\\d\\d)?";
    public static final String DAY_TIME_DURATION = "-?P((\\d)+D)?((T(\\d)+H((\\d)+M)?((\\d)+(\\.(\\d)+)?S)?)|(T(\\d)+M((\\d)+(\\.(\\d)+)?S)?)|(T(\\d)+(\\.(\\d)+)?S))?";
    public static final String DURATION = "-?P((\\d)+Y)?((\\d)+M)?((\\d)+D)?((T(\\d)+H((\\d)+M)?((\\d)+(\\.(\\d)+)?S)?)|(T(\\d)+M((\\d)+(\\.(\\d)+)?S)?)|(T(\\d)+(\\.(\\d)+)?S))?";

    public static boolean isPrimitiveDatatype(@Nonnull Datatype theDatatype) {
        return theDatatype != Datatype.UDF && PRIMITIVES.contains((Object)theDatatype);
    }

    public static boolean isCalendarDatatype(@Nonnull Datatype theDatatype) {
        return CALENDAR.contains((Object)theDatatype);
    }

    public static boolean isBuiltInDatatype(@Nonnull IRI theIRI) {
        return XMLDatatypes.isBuiltInDatatype(Datatype.of(theIRI));
    }

    public static boolean isBuiltInDatatype(@Nonnull Datatype theDatatype) {
        return PRIMITIVES.contains((Object)theDatatype) || DERIVED.contains((Object)theDatatype);
    }

    public static boolean isNumericDatatype(@Nonnull Datatype theDatatype) {
        return XMLDatatypes.isDecimalDatatype(theDatatype) || FP.contains((Object)theDatatype);
    }

    public static boolean isDecimalDatatype(@Nonnull Datatype theDatatype) {
        return theDatatype == Datatype.DECIMAL || XMLDatatypes.isIntegerDatatype(theDatatype);
    }

    public static boolean isDurationDatatype(@Nonnull Datatype theDatatype) {
        return DURATIONS.contains((Object)theDatatype);
    }

    public static boolean isIntegerDatatype(@Nonnull Datatype theDatatype) {
        return INTEGERS.contains((Object)theDatatype);
    }

    public static boolean isFloatingPointDatatype(@Nonnull Datatype theDatatype) {
        return FP.contains((Object)theDatatype);
    }

    public static boolean isValidValue(@Nonnull Literal theLiteral) {
        return XMLDatatypes.isValidValue(theLiteral.label(), theLiteral.datatype());
    }

    public static boolean isValidValue(@Nonnull String theValue, @Nonnull Datatype theDatatype) {
        boolean result = true;
        if (theDatatype == Datatype.DECIMAL) {
            result = XMLDatatypes.isValidDecimal(theValue);
        } else if (theDatatype == Datatype.INTEGER) {
            result = XMLDatatypes.isValidInteger(theValue);
        } else if (theDatatype == Datatype.NEGATIVE_INTEGER) {
            result = XMLDatatypes.isValidNegativeInteger(theValue);
        } else if (theDatatype == Datatype.NON_POSITIVE_INTEGER) {
            result = XMLDatatypes.isValidNonPositiveInteger(theValue);
        } else if (theDatatype == Datatype.NON_NEGATIVE_INTEGER) {
            result = XMLDatatypes.isValidNonNegativeInteger(theValue);
        } else if (theDatatype == Datatype.POSITIVE_INTEGER) {
            result = XMLDatatypes.isValidPositiveInteger(theValue);
        } else if (theDatatype == Datatype.LONG) {
            result = XMLDatatypes.isValidLong(theValue);
        } else if (theDatatype == Datatype.INT) {
            result = XMLDatatypes.isValidInt(theValue);
        } else if (theDatatype == Datatype.SHORT) {
            result = XMLDatatypes.isValidShort(theValue);
        } else if (theDatatype == Datatype.BYTE) {
            result = XMLDatatypes.isValidByte(theValue);
        } else if (theDatatype == Datatype.UNSIGNED_LONG) {
            result = XMLDatatypes.isValidUnsignedLong(theValue);
        } else if (theDatatype == Datatype.UNSIGNED_INT) {
            result = XMLDatatypes.isValidUnsignedInt(theValue);
        } else if (theDatatype == Datatype.UNSIGNED_SHORT) {
            result = XMLDatatypes.isValidUnsignedShort(theValue);
        } else if (theDatatype == Datatype.UNSIGNED_BYTE) {
            result = XMLDatatypes.isValidUnsignedByte(theValue);
        } else if (theDatatype == Datatype.FLOAT) {
            result = XMLDatatypes.isValidFloat(theValue);
        } else if (theDatatype == Datatype.DOUBLE) {
            result = XMLDatatypes.isValidDouble(theValue);
        } else if (theDatatype == Datatype.BOOLEAN) {
            result = XMLDatatypes.isValidBoolean(theValue);
        } else if (theDatatype == Datatype.DATETIME) {
            result = XMLDatatypes.isValidDateTime(theValue);
        } else if (theDatatype == Datatype.DATE) {
            result = XMLDatatypes.isValidDate(theValue);
        } else if (theDatatype == Datatype.TIME) {
            result = XMLDatatypes.isValidTime(theValue);
        } else if (theDatatype == Datatype.GDAY) {
            result = XMLDatatypes.isValidGDay(theValue);
        } else if (theDatatype == Datatype.GMONTH) {
            result = XMLDatatypes.isValidGMonth(theValue);
        } else if (theDatatype == Datatype.GMONTHDAY) {
            result = XMLDatatypes.isValidGMonthDay(theValue);
        } else if (theDatatype == Datatype.GYEAR) {
            result = XMLDatatypes.isValidGYear(theValue);
        } else if (theDatatype == Datatype.GYEARMONTH) {
            result = XMLDatatypes.isValidGYearMonth(theValue);
        } else if (theDatatype == Datatype.DURATION) {
            result = XMLDatatypes.isValidDuration(theValue);
        } else if (theDatatype == Datatype.DURATION_DAYTIME) {
            result = XMLDatatypes.isValidDayTimeDuration(theValue);
        } else if (theDatatype == Datatype.QNAME) {
            result = XMLDatatypes.isValidQName(theValue);
        }
        return result;
    }

    public static boolean isValidDecimal(String value) {
        try {
            XMLDatatypes.normalizeDecimal(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidInteger(String value) {
        try {
            XMLDatatypes.normalizeInteger(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidNegativeInteger(String value) {
        try {
            XMLDatatypes.normalizeNegativeInteger(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidNonPositiveInteger(String value) {
        try {
            XMLDatatypes.normalizeNonPositiveInteger(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidNonNegativeInteger(String value) {
        try {
            XMLDatatypes.normalizeNonNegativeInteger(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidPositiveInteger(String value) {
        try {
            XMLDatatypes.normalizePositiveInteger(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidLong(String value) {
        try {
            XMLDatatypes.normalizeLong(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidInt(String value) {
        try {
            XMLDatatypes.normalizeInt(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidShort(String value) {
        try {
            XMLDatatypes.normalizeShort(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidByte(String value) {
        try {
            XMLDatatypes.normalizeByte(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidUnsignedLong(String value) {
        try {
            XMLDatatypes.normalizeUnsignedLong(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidUnsignedInt(String value) {
        try {
            XMLDatatypes.normalizeUnsignedInt(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidUnsignedShort(String value) {
        try {
            XMLDatatypes.normalizeUnsignedShort(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidUnsignedByte(String value) {
        try {
            XMLDatatypes.normalizeUnsignedByte(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidFloat(String value) {
        try {
            XMLDatatypes.normalizeFloat(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidDouble(String value) {
        try {
            XMLDatatypes.normalizeDouble(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidBoolean(String value) {
        try {
            XMLDatatypes.normalizeBoolean(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidDuration(String value) {
        return value.length() > 1 && value.matches(DURATION);
    }

    public static boolean isValidDayTimeDuration(String value) {
        return value.length() > 1 && value.matches(DAY_TIME_DURATION);
    }

    public static boolean isValidDateTime(String value) {
        try {
            XMLDateTime dt = new XMLDateTime(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidDate(String value) {
        return value.matches(DATE) && XMLDatatypes.isValidCalendarValue(value);
    }

    public static boolean isValidTime(String value) {
        return value.matches(TIME) && XMLDatatypes.isValidCalendarValue(value);
    }

    public static boolean isValidGDay(String value) {
        return value.matches(GDAY) && XMLDatatypes.isValidCalendarValue(value);
    }

    public static boolean isValidGMonth(String value) {
        return value.matches(GMONTH) && XMLDatatypes.isValidCalendarValue(value);
    }

    public static boolean isValidGMonthDay(String value) {
        return value.matches(GMONTHDAY) && XMLDatatypes.isValidCalendarValue(value);
    }

    public static boolean isValidGYear(String value) {
        return value.matches(GYEAR) && XMLDatatypes.isValidCalendarValue(value);
    }

    public static boolean isValidGYearMonth(String value) {
        return value.matches(GYEARMONTH_REGEX) && XMLDatatypes.isValidCalendarValue(value);
    }

    public static boolean isValidQName(String value) {
        String name;
        String[] split = value.split(":", -2);
        if (split.length != 2) {
            return false;
        }
        String prefix = split[0];
        if (!"".equals(prefix)) {
            if (!XMLDatatypes.isPrefixStartChar(prefix.charAt(0))) {
                return false;
            }
            for (int i = 1; i < prefix.length(); ++i) {
                if (XMLDatatypes.isNameChar(prefix.charAt(i))) continue;
                return false;
            }
        }
        if (!"".equals(name = split[1])) {
            if (!XMLDatatypes.isNameStartChar(name.charAt(0))) {
                return false;
            }
            for (int i = 1; i < name.length(); ++i) {
                if (XMLDatatypes.isNameChar(name.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isPrefixStartChar(int c) {
        return ASCIIUtil.isLetter(c) || c >= 192 && c <= 214 || c >= 216 && c <= 246 || c >= 248 && c <= 767 || c >= 880 && c <= 893 || c >= 895 && c <= 8191 || c >= 8204 && c <= 983039;
    }

    private static boolean isNameStartChar(int c) {
        return c == 95 || XMLDatatypes.isPrefixStartChar(c);
    }

    private static boolean isNameChar(int c) {
        return XMLDatatypes.isNameStartChar(c) || ASCIIUtil.isNumber(c) || c == 45 || c == 183 || c >= 768 && c <= 879 || c >= 8255 && c <= 8256;
    }

    private static boolean isValidCalendarValue(String value) {
        try {
            XMLDatatypes.parseCalendar(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static String normalize(String value, Datatype datatype) {
        switch (datatype) {
            case DECIMAL: {
                return XMLDatatypes.normalizeDecimal(value);
            }
            case INTEGER: {
                return XMLDatatypes.normalizeInteger(value);
            }
            case NEGATIVE_INTEGER: {
                return XMLDatatypes.normalizeNegativeInteger(value);
            }
            case NON_POSITIVE_INTEGER: {
                return XMLDatatypes.normalizeNonPositiveInteger(value);
            }
            case NON_NEGATIVE_INTEGER: {
                return XMLDatatypes.normalizeNonNegativeInteger(value);
            }
            case POSITIVE_INTEGER: {
                return XMLDatatypes.normalizePositiveInteger(value);
            }
            case LONG: {
                return XMLDatatypes.normalizeLong(value);
            }
            case INT: {
                return XMLDatatypes.normalizeInt(value);
            }
            case SHORT: {
                return XMLDatatypes.normalizeShort(value);
            }
            case BYTE: {
                return XMLDatatypes.normalizeByte(value);
            }
            case UNSIGNED_LONG: {
                return XMLDatatypes.normalizeUnsignedLong(value);
            }
            case UNSIGNED_INT: {
                return XMLDatatypes.normalizeUnsignedInt(value);
            }
            case UNSIGNED_SHORT: {
                return XMLDatatypes.normalizeUnsignedShort(value);
            }
            case UNSIGNED_BYTE: {
                return XMLDatatypes.normalizeUnsignedByte(value);
            }
            case FLOAT: {
                return XMLDatatypes.normalizeFloat(value);
            }
            case DOUBLE: {
                return XMLDatatypes.normalizeDouble(value);
            }
            case BOOLEAN: {
                return XMLDatatypes.normalizeBoolean(value);
            }
            case DATETIME: {
                return XMLDatatypes.normalizeDateTime(value);
            }
        }
        return value;
    }

    public static String normalizeBoolean(String theValue) {
        String value;
        switch (value = XMLDatatypes.collapseWhiteSpace(theValue)) {
            case "1": {
                return "true";
            }
            case "0": {
                return "false";
            }
            case "true": 
            case "false": {
                return value;
            }
        }
        throw new IllegalArgumentException("Not a legal boolean value: " + value);
    }

    public static String normalizeDecimal(String decimal) {
        decimal = XMLDatatypes.collapseWhiteSpace(decimal);
        int decLength = decimal.length();
        StringBuilder result = new StringBuilder(decLength + 2);
        if (decLength == 0) {
            throw new IllegalArgumentException("Not a legal decimal: " + decimal);
        }
        boolean isZeroPointZero = true;
        int idx = 0;
        if (decimal.charAt(idx) == '-') {
            result.append('-');
            ++idx;
        } else if (decimal.charAt(idx) == '+') {
            ++idx;
        }
        if (idx == decLength) {
            throw new IllegalArgumentException("Not a legal decimal: " + decimal);
        }
        while (idx < decLength && decimal.charAt(idx) == '0') {
            ++idx;
        }
        if (idx == decLength) {
            result.append('0');
        } else if (idx < decLength && decimal.charAt(idx) == '.') {
            result.append('0');
        } else {
            char c;
            isZeroPointZero = false;
            while (idx < decLength && (c = decimal.charAt(idx)) != '.') {
                if (!XMLDatatypes.isDigit(c)) {
                    throw new IllegalArgumentException("Not a legal decimal: " + decimal);
                }
                result.append(c);
                ++idx;
            }
        }
        result.append('.');
        if (idx == decLength) {
            result.append('0');
        } else {
            int lastIdx;
            ++idx;
            for (lastIdx = decLength - 1; lastIdx >= 0 && decimal.charAt(lastIdx) == '0'; --lastIdx) {
            }
            if (idx > lastIdx) {
                result.append('0');
            } else {
                isZeroPointZero = false;
                while (idx <= lastIdx) {
                    char c = decimal.charAt(idx);
                    if (!XMLDatatypes.isDigit(c)) {
                        throw new IllegalArgumentException("Not a legal decimal: " + decimal);
                    }
                    result.append(c);
                    ++idx;
                }
            }
        }
        if (isZeroPointZero) {
            return "0.0";
        }
        return result.toString();
    }

    public static String normalizeInteger(String value) {
        return XMLDatatypes.normalizeIntegerValue(value, null, null);
    }

    public static String normalizeNegativeInteger(String value) {
        return XMLDatatypes.normalizeIntegerValue(value, null, "-1");
    }

    public static String normalizeNonPositiveInteger(String value) {
        return XMLDatatypes.normalizeIntegerValue(value, null, "0");
    }

    public static String normalizeNonNegativeInteger(String value) {
        return XMLDatatypes.normalizeIntegerValue(value, "0", null);
    }

    public static String normalizePositiveInteger(String value) {
        return XMLDatatypes.normalizeIntegerValue(value, "1", null);
    }

    public static String normalizeLong(String value) {
        return XMLDatatypes.normalizeIntegerValue(value, "-9223372036854775808", "9223372036854775807");
    }

    public static String normalizeInt(String value) {
        return XMLDatatypes.normalizeIntegerValue(value, "-2147483648", "2147483647");
    }

    public static String normalizeShort(String value) {
        return XMLDatatypes.normalizeIntegerValue(value, "-32768", "32767");
    }

    public static String normalizeByte(String value) {
        return XMLDatatypes.normalizeIntegerValue(value, "-128", "127");
    }

    public static String normalizeUnsignedLong(String value) {
        return XMLDatatypes.normalizeIntegerValue(value, "0", "18446744073709551615");
    }

    public static String normalizeUnsignedInt(String value) {
        return XMLDatatypes.normalizeIntegerValue(value, "0", "4294967295");
    }

    public static String normalizeUnsignedShort(String value) {
        return XMLDatatypes.normalizeIntegerValue(value, "0", "65535");
    }

    public static String normalizeUnsignedByte(String value) {
        return XMLDatatypes.normalizeIntegerValue(value, "0", "255");
    }

    private static String normalizeIntegerValue(String integer, String minValue, String maxValue) {
        int intLength = (integer = XMLDatatypes.collapseWhiteSpace(integer)).length();
        if (intLength == 0) {
            throw new IllegalArgumentException("Not a legal integer: " + integer);
        }
        int idx = 0;
        boolean isNegative = false;
        if (integer.charAt(idx) == '-') {
            isNegative = true;
            ++idx;
        } else if (integer.charAt(idx) == '+') {
            ++idx;
        }
        if (idx == intLength) {
            throw new IllegalArgumentException("Not a legal integer: " + integer);
        }
        if (integer.charAt(idx) == '0' && idx < intLength - 1) {
            ++idx;
            while (idx < intLength - 1 && integer.charAt(idx) == '0') {
                ++idx;
            }
        }
        Object norm = integer.substring(idx);
        for (int i = 0; i < ((String)norm).length(); ++i) {
            if (XMLDatatypes.isDigit(((String)norm).charAt(i))) continue;
            throw new IllegalArgumentException("Not a legal integer: " + integer);
        }
        if (isNegative && ((String)norm).charAt(0) != '0') {
            norm = "-" + (String)norm;
        }
        if (minValue != null && XMLDatatypes.compareCanonicalIntegers((String)norm, minValue) < 0) {
            throw new IllegalArgumentException("Value smaller than minimum value");
        }
        if (maxValue != null && XMLDatatypes.compareCanonicalIntegers((String)norm, maxValue) > 0) {
            throw new IllegalArgumentException("Value larger than maximum value");
        }
        return norm;
    }

    public static String normalizeFloat(String value) {
        return XMLDatatypes.normalizeFPNumber(value, "-16777215.0", "16777215.0", "-149", "104");
    }

    public static String normalizeDouble(String value) {
        return XMLDatatypes.normalizeFPNumber(value, "-9007199254740991.0", "9007199254740991.0", "-1075", "970");
    }

    private static String normalizeFPNumber(String value, String minMantissa, String maxMantissa, String minExponent, String maxExponent) {
        int dotIdx;
        String exponent;
        String mantissa;
        if ((value = XMLDatatypes.collapseWhiteSpace(value)).contains(" ")) {
            throw new IllegalArgumentException("No space allowed in floating point lexical value (" + value + ")");
        }
        if (value.equals("INF") || value.equals("-INF") || value.equals("NaN")) {
            return value;
        }
        int eIdx = value.indexOf(69);
        if (eIdx == -1) {
            eIdx = value.indexOf(101);
        }
        if (eIdx == -1) {
            mantissa = XMLDatatypes.normalizeDecimal(value);
            exponent = "0";
        } else {
            mantissa = XMLDatatypes.normalizeDecimal(value.substring(0, eIdx));
            exponent = XMLDatatypes.normalizeInteger(value.substring(eIdx + 1));
        }
        int shift = 0;
        int digitCount = dotIdx = mantissa.indexOf(46);
        if (mantissa.charAt(0) == '-') {
            --digitCount;
        }
        if (digitCount > 1) {
            int nonZeroIdx;
            StringBuilder sb = new StringBuilder(mantissa.length());
            int firstDigitIdx = 0;
            if (mantissa.charAt(0) == '-') {
                sb.append('-');
                firstDigitIdx = 1;
            }
            sb.append(mantissa.charAt(firstDigitIdx));
            sb.append('.');
            sb.append(mantissa.substring(firstDigitIdx + 1, dotIdx));
            sb.append(mantissa.substring(dotIdx + 1));
            mantissa = sb.toString();
            for (nonZeroIdx = mantissa.length() - 1; nonZeroIdx >= 3 && mantissa.charAt(nonZeroIdx) == '0'; --nonZeroIdx) {
            }
            if (nonZeroIdx < 3 && mantissa.charAt(0) == '-') {
                ++nonZeroIdx;
            }
            if (nonZeroIdx < mantissa.length() - 1) {
                mantissa = mantissa.substring(0, nonZeroIdx + 1);
            }
            shift = 1 - digitCount;
        } else if (mantissa.startsWith("0.") || mantissa.startsWith("-0.")) {
            int nonZeroIdx = 2;
            boolean negative = false;
            if (mantissa.charAt(0) == '-') {
                ++nonZeroIdx;
                negative = true;
            }
            while (nonZeroIdx < mantissa.length() && mantissa.charAt(nonZeroIdx) == '0') {
                ++nonZeroIdx;
            }
            if (nonZeroIdx < mantissa.length()) {
                StringBuilder sb = new StringBuilder(mantissa.length());
                if (negative) {
                    sb.append('-');
                }
                sb.append(mantissa.charAt(nonZeroIdx));
                sb.append('.');
                if (nonZeroIdx == mantissa.length() - 1) {
                    sb.append('0');
                } else {
                    sb.append(mantissa.substring(nonZeroIdx + 1));
                }
                mantissa = sb.toString();
                int n = shift = negative ? nonZeroIdx - 2 : nonZeroIdx - 1;
            }
        }
        if (shift != 0) {
            try {
                int exp = Integer.parseInt(exponent);
                exponent = String.valueOf(exp - shift);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("NumberFormatException: " + e.getMessage());
            }
        }
        if (minMantissa != null && XMLDatatypes.compareCanonicalDecimals(mantissa, minMantissa) < 0) {
            throw new IllegalArgumentException("Mantissa smaller than minimum value (" + minMantissa + ")");
        }
        if (maxMantissa != null && XMLDatatypes.compareCanonicalDecimals(mantissa, maxMantissa) > 0) {
            throw new IllegalArgumentException("Mantissa larger than maximum value (" + maxMantissa + ")");
        }
        if (minExponent != null && XMLDatatypes.compareCanonicalIntegers(exponent, minExponent) < 0) {
            throw new IllegalArgumentException("Exponent smaller than minimum value (" + minExponent + ")");
        }
        if (maxExponent != null && XMLDatatypes.compareCanonicalIntegers(exponent, maxExponent) > 0) {
            throw new IllegalArgumentException("Exponent larger than maximum value (" + maxExponent + ")");
        }
        return mantissa + "E" + exponent;
    }

    public static String normalizeDateTime(String value) {
        XMLDateTime dt = new XMLDateTime(value);
        dt.normalize();
        return dt.toString();
    }

    public static String collapseWhiteSpace(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        StringTokenizer st = new StringTokenizer(s, "\t\r\n ");
        if (st.hasMoreTokens()) {
            sb.append(st.nextToken());
        }
        while (st.hasMoreTokens()) {
            sb.append(' ').append(st.nextToken());
        }
        return sb.toString();
    }

    public static int compareCanonicalDecimals(String dec1, String dec2) {
        int dotIdx2;
        if (dec1.equals(dec2)) {
            return 0;
        }
        if (dec1.charAt(0) == '-' && dec2.charAt(0) != '-') {
            return -1;
        }
        if (dec2.charAt(0) == '-' && dec1.charAt(0) != '-') {
            return 1;
        }
        int dotIdx1 = dec1.indexOf(46);
        int result = dotIdx1 - (dotIdx2 = dec2.indexOf(46));
        if (result == 0) {
            int dec2Length;
            for (int i = 0; result == 0 && i < dotIdx1; ++i) {
                result = dec1.charAt(i) - dec2.charAt(i);
            }
            int dec1Length = dec1.length();
            int lastIdx = dec1Length <= (dec2Length = dec2.length()) ? dec1Length : dec2Length;
            for (int i = dotIdx1 + 1; result == 0 && i < lastIdx; ++i) {
                result = dec1.charAt(i) - dec2.charAt(i);
            }
            if (result == 0) {
                result = dec1Length - dec2Length;
            }
        }
        if (dec1.charAt(0) == '-') {
            result = -result;
        }
        return result;
    }

    public static int compareCanonicalIntegers(String int1, String int2) {
        if (int1.equals(int2)) {
            return 0;
        }
        if (int1.charAt(0) == '-' && int2.charAt(0) != '-') {
            return -1;
        }
        if (int2.charAt(0) == '-' && int1.charAt(0) != '-') {
            return 1;
        }
        int result = int1.length() - int2.length();
        if (result == 0) {
            for (int i = 0; result == 0 && i < int1.length(); ++i) {
                result = int1.charAt(i) - int2.charAt(i);
            }
        }
        if (int1.charAt(0) == '-') {
            result = -result;
        }
        return result;
    }

    public static XMLGregorianCalendar parseCalendar(String s) {
        return Values.DATATYPE_FACTORY.newXMLGregorianCalendar(s);
    }

    private static final boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private XMLDatatypes() {
        throw new AssertionError();
    }
}

