/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark;

import com.google.errorprone.annotations.Immutable;
import com.stardog.stark.BNode;
import com.stardog.stark.Literal;
import com.stardog.stark.Statement;
import com.stardog.stark.Values;
import java.io.Serializable;
import javax.annotation.Nonnull;

@Immutable
public interface Value
extends Serializable {
    @Nonnull
    public static String lex(@Nonnull Value theValue) {
        if (theValue instanceof Literal) {
            return ((Literal)theValue).label();
        }
        if (theValue instanceof BNode) {
            return ((BNode)theValue).id();
        }
        if (theValue instanceof Statement) {
            Statement statement = (Statement)theValue;
            StringBuilder result = new StringBuilder();
            result.append("<<").append(Value.lex(statement.subject())).append(' ').append(Value.lex(statement.predicate())).append(' ').append(Value.lex(statement.object()));
            if (!statement.context().equals(Values.DEFAULT_GRAPH)) {
                result.append(' ').append(Value.lex(statement.context()));
            }
            result.append(">>");
            return result.toString();
        }
        return theValue.toString();
    }

    public static int lexLength(@Nonnull Value theValue) {
        if (theValue instanceof Literal) {
            return ((Literal)theValue).label().length();
        }
        if (theValue instanceof BNode) {
            return ((BNode)theValue).id().length();
        }
        if (theValue instanceof Statement) {
            Statement statement = (Statement)theValue;
            int len = 2 + Value.lexLength(statement.subject()) + 1 + Value.lexLength(statement.predicate()) + 1 + Value.lexLength(statement.object());
            if (!statement.context().equals(Values.DEFAULT_GRAPH)) {
                len += 1 + Value.lexLength(statement.context());
            }
            return len += 2;
        }
        return theValue.toString().length();
    }
}

