/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.stardog.stark.Namespace;
import com.stardog.stark.Values;
import com.stardog.stark.impl.ImmutableNamespaces;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;

public interface Namespaces
extends Iterable<Namespace> {
    public static final String OWL = "http://www.w3.org/2002/07/owl#";
    public static final String RDF = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    public static final String RDFS = "http://www.w3.org/2000/01/rdf-schema#";
    public static final String SHACL = "http://www.w3.org/ns/shacl#";
    public static final String SWRL = "http://www.w3.org/2003/11/swrl#";
    public static final String SWRLB = "http://www.w3.org/2003/11/swrlb#";
    public static final String XSD = "http://www.w3.org/2001/XMLSchema#";
    public static final String DC = "http://purl.org/dc/elements/1.1/";
    public static final String FOAF = "http://xmlns.com/foaf/0.1/";
    public static final String SKOS = "http://www.w3.org/2004/02/skos/core#";
    public static final String PROV = "http://www.w3.org/ns/prov#";
    public static final String SCHEMA_ORG = "https://schema.org/";
    public static final String STARDOG = "tag:stardog:api:";
    public static final String STARDOG_SHACL = "tag:stardog:api:shacl:";
    public static final String BASE_URI = "http://api.stardog.com/";
    public static final Namespaces DEFAULT = new ImmutableNamespaces(Values.namespace("", "http://api.stardog.com/"), Values.namespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#"), Values.namespace("rdfs", "http://www.w3.org/2000/01/rdf-schema#"), Values.namespace("xsd", "http://www.w3.org/2001/XMLSchema#"), Values.namespace("owl", "http://www.w3.org/2002/07/owl#"), Values.namespace("stardog", "tag:stardog:api:"), Values.namespace("so", "https://schema.org/"));
    public static final Namespaces EXTENDED = new ImmutableNamespaces((Iterable<Namespace>)ImmutableSet.builder().addAll((Iterable)DEFAULT).add((Object)Values.namespace("sh", "http://www.w3.org/ns/shacl#")).add((Object)Values.namespace("swrl", "http://www.w3.org/2003/11/swrl#")).add((Object)Values.namespace("swrlb", "http://www.w3.org/2003/11/swrlb#")).add((Object)Values.namespace("dc", "http://purl.org/dc/elements/1.1/")).add((Object)Values.namespace("foaf", "http://xmlns.com/foaf/0.1/")).add((Object)Values.namespace("skos", "http://www.w3.org/2004/02/skos/core#")).add((Object)Values.namespace("prov", "http://www.w3.org/ns/prov#")).build());
    public static final Namespaces RDFA_INIT_CONTEXT = new ImmutableNamespaces((Iterable<Namespace>)ImmutableSet.builder().add((Object)Values.namespace("grddl", "http://www.w3.org/2003/g/data-view#")).add((Object)Values.namespace("ma", "http://www.w3.org/ns/ma-ont#")).add((Object)Values.namespace("owl", "http://www.w3.org/2002/07/owl#")).add((Object)Values.namespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#")).add((Object)Values.namespace("rdfa", "http://www.w3.org/ns/rdfa#")).add((Object)Values.namespace("rdfs", "http://www.w3.org/2000/01/rdf-schema#")).add((Object)Values.namespace("rif", "http://www.w3.org/2007/rif#")).add((Object)Values.namespace("skos", "http://www.w3.org/2004/02/skos/core#")).add((Object)Values.namespace("skosxl", "http://www.w3.org/2008/05/skos-xl#")).add((Object)Values.namespace("prov", "http://www.w3.org/ns/prov#")).add((Object)Values.namespace("wdr", "http://www.w3.org/2007/05/powder#")).add((Object)Values.namespace("void", "http://rdfs.org/ns/void#")).add((Object)Values.namespace("wdrs", "http://www.w3.org/2007/05/powder-s#")).add((Object)Values.namespace("xhv", "http://www.w3.org/1999/xhtml/vocab#")).add((Object)Values.namespace("xml", "http://www.w3.org/XML/1998/namespace")).add((Object)Values.namespace("xsd", "http://www.w3.org/2001/XMLSchema#")).build());

    public static Namespaces defaults(@Nonnull String theDefaultIRI) {
        return new ImmutableNamespaces(Iterables.transform((Iterable)DEFAULT, ns -> ns.prefix().isEmpty() ? Values.namespace("", theDefaultIRI) : ns));
    }

    @Nonnull
    default public Optional<String> prefix(@Nonnull String theIRI) {
        return this.stream().filter(ns -> ns.iri().equals(theIRI)).map(Namespace::prefix).findFirst();
    }

    @Nonnull
    default public Optional<String> iri(@Nonnull String thePrefix) {
        return this.stream().filter(ns -> ns.prefix().equals(thePrefix)).map(Namespace::iri).findFirst();
    }

    @Nonnull
    default public Optional<String> map(@Nonnull String thePrefixedName) {
        String[] aSplit = thePrefixedName.split(":", 2);
        return aSplit.length != 2 ? Optional.empty() : this.iri(aSplit[0]).map((? super T theNS) -> theNS + aSplit[1]);
    }

    @Nonnull
    default public Stream<Namespace> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }
}

