/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark;

import com.stardog.stark.Datatype;
import com.stardog.stark.IRI;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.XMLCalendar;
import com.stardog.stark.XMLDatatypes;
import com.stardog.stark.impl.BigDecimalLiteral;
import com.stardog.stark.impl.BigIntegerLiteral;
import com.stardog.stark.impl.BooleanLiteral;
import com.stardog.stark.impl.ByteLiteral;
import com.stardog.stark.impl.CalendarLiteral;
import com.stardog.stark.impl.DoubleLiteral;
import com.stardog.stark.impl.DurationLiteral;
import com.stardog.stark.impl.FloatLiteral;
import com.stardog.stark.impl.GenericIntegerLiteral;
import com.stardog.stark.impl.IntLiteral;
import com.stardog.stark.impl.IntegerLiteral;
import com.stardog.stark.impl.LanguageLiteral;
import com.stardog.stark.impl.LongIntegerLiteral;
import com.stardog.stark.impl.LongLiteral;
import com.stardog.stark.impl.ShortLiteral;
import com.stardog.stark.impl.TypedLiteral;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Optional;
import java.util.function.DoubleSupplier;
import javax.annotation.Nonnull;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;

public interface Literal
extends Value {
    public static final boolean STRICT_TYPES = Boolean.parseBoolean(System.getProperty("stark.literals.strict.types", "false"));

    @Nonnull
    public String label();

    @Nonnull
    default public Optional<String> lang() {
        return Optional.empty();
    }

    @Nonnull
    default public IRI datatypeIRI() {
        return this.datatype().iri();
    }

    @Nonnull
    public Datatype datatype();

    @Nonnull
    public static String str(@Nonnull Literal theLiteral) {
        String aQuote;
        boolean aMultiline = theLiteral.label().contains("\n");
        String string = aQuote = aMultiline ? "\"\"\"" : "\"";
        if (theLiteral.lang().isPresent()) {
            return String.format("%s%s%s@%s", aQuote, theLiteral.label(), aQuote, theLiteral.lang().get());
        }
        return String.format("%s%s%s^^<%s>", aQuote, theLiteral.label(), aQuote, theLiteral.datatypeIRI());
    }

    public static boolean isLanguageLiteral(@Nonnull Literal theLiteral) {
        return theLiteral instanceof LanguageLiteral || theLiteral.lang().isPresent();
    }

    public static boolean booleanValue(@Nonnull Literal theLiteral) {
        return theLiteral instanceof BooleanLiteral ? ((BooleanLiteral)theLiteral).booleanValue() : Boolean.parseBoolean(XMLDatatypes.normalizeBoolean(theLiteral.label()));
    }

    public static XMLGregorianCalendar calendarValue(@Nonnull Literal theLiteral) {
        return Literal.xmlCalendarValue(theLiteral).unwrap();
    }

    @Nonnull
    public static XMLCalendar xmlCalendarValue(@Nonnull Literal theLiteral) {
        if (theLiteral instanceof CalendarLiteral) {
            return (CalendarLiteral)theLiteral;
        }
        if (!STRICT_TYPES) {
            return new XMLCalendar.Delegate(XMLDatatypes.parseCalendar(theLiteral.label()));
        }
        throw new IllegalArgumentException("Literal is not a calendar datatype");
    }

    public static int intValue(@Nonnull Literal theLiteral) {
        switch (theLiteral.datatype()) {
            case DOUBLE: {
                if (!(theLiteral instanceof DoubleLiteral)) break;
                return (int)((DoubleLiteral)theLiteral).doubleValue();
            }
            case BYTE: {
                if (!(theLiteral instanceof ByteLiteral)) break;
                return ((ByteLiteral)theLiteral).byteValue();
            }
            case INT: {
                if (!(theLiteral instanceof IntLiteral)) break;
                return ((IntLiteral)theLiteral).intValue();
            }
            case FLOAT: {
                if (!(theLiteral instanceof FloatLiteral)) break;
                return (int)((FloatLiteral)theLiteral).floatValue();
            }
            case DECIMAL: {
                if (!(theLiteral instanceof BigDecimalLiteral)) break;
                return ((BigDecimalLiteral)theLiteral).decimalValue().intValue();
            }
            case INTEGER: {
                if (theLiteral instanceof BigIntegerLiteral) {
                    return ((BigIntegerLiteral)theLiteral).integerValue().intValue();
                }
                if (theLiteral instanceof IntegerLiteral) {
                    return ((IntegerLiteral)theLiteral).intValue();
                }
                if (theLiteral instanceof LongIntegerLiteral) {
                    return (int)((LongIntegerLiteral)theLiteral).longValue();
                }
                if (theLiteral instanceof GenericIntegerLiteral) {
                    return ((GenericIntegerLiteral)theLiteral).intValue();
                }
                if (!(theLiteral instanceof TypedLiteral)) break;
                return (int)Double.parseDouble(theLiteral.label());
            }
            case UNSIGNED_BYTE: 
            case UNSIGNED_INT: 
            case UNSIGNED_SHORT: 
            case UNSIGNED_LONG: 
            case NEGATIVE_INTEGER: 
            case NON_NEGATIVE_INTEGER: 
            case POSITIVE_INTEGER: 
            case NON_POSITIVE_INTEGER: {
                if (!(theLiteral instanceof GenericIntegerLiteral)) break;
                return ((GenericIntegerLiteral)theLiteral).intValue();
            }
            case LONG: {
                if (!(theLiteral instanceof LongLiteral)) break;
                return (int)((LongLiteral)theLiteral).longValue();
            }
            case SHORT: {
                if (!(theLiteral instanceof ShortLiteral)) break;
                return ((ShortLiteral)theLiteral).shortValue();
            }
        }
        if (!STRICT_TYPES || XMLDatatypes.isNumericDatatype(theLiteral.datatype())) {
            return Integer.parseInt(theLiteral.label());
        }
        throw new NumberFormatException("Literal is not a int datatype");
    }

    public static byte byteValue(@Nonnull Literal theLiteral) {
        switch (theLiteral.datatype()) {
            case DOUBLE: {
                if (!(theLiteral instanceof DoubleLiteral)) break;
                return (byte)((DoubleLiteral)theLiteral).doubleValue();
            }
            case BYTE: {
                if (!(theLiteral instanceof ByteLiteral)) break;
                return ((ByteLiteral)theLiteral).byteValue();
            }
            case INT: {
                if (!(theLiteral instanceof IntLiteral)) break;
                return (byte)((IntLiteral)theLiteral).intValue();
            }
            case FLOAT: {
                if (!(theLiteral instanceof FloatLiteral)) break;
                return (byte)((FloatLiteral)theLiteral).floatValue();
            }
            case DECIMAL: {
                if (!(theLiteral instanceof BigDecimalLiteral)) break;
                return (byte)((BigDecimalLiteral)theLiteral).decimalValue().intValue();
            }
            case INTEGER: {
                if (theLiteral instanceof BigIntegerLiteral) {
                    return (byte)((BigIntegerLiteral)theLiteral).integerValue().intValue();
                }
                if (theLiteral instanceof IntegerLiteral) {
                    return (byte)((IntegerLiteral)theLiteral).intValue();
                }
                if (theLiteral instanceof LongIntegerLiteral) {
                    return (byte)((LongIntegerLiteral)theLiteral).longValue();
                }
                if (!(theLiteral instanceof GenericIntegerLiteral)) break;
                return (byte)((GenericIntegerLiteral)theLiteral).intValue();
            }
            case UNSIGNED_BYTE: 
            case UNSIGNED_INT: 
            case UNSIGNED_SHORT: 
            case UNSIGNED_LONG: 
            case NEGATIVE_INTEGER: 
            case NON_NEGATIVE_INTEGER: 
            case POSITIVE_INTEGER: 
            case NON_POSITIVE_INTEGER: {
                if (!(theLiteral instanceof GenericIntegerLiteral)) break;
                return (byte)((GenericIntegerLiteral)theLiteral).intValue();
            }
            case LONG: {
                if (!(theLiteral instanceof LongLiteral)) break;
                return (byte)((LongLiteral)theLiteral).longValue();
            }
            case SHORT: {
                if (!(theLiteral instanceof ShortLiteral)) break;
                return (byte)((ShortLiteral)theLiteral).shortValue();
            }
        }
        if (!STRICT_TYPES || XMLDatatypes.isNumericDatatype(theLiteral.datatype())) {
            return Byte.parseByte(theLiteral.label());
        }
        throw new NumberFormatException("Literal is not a int datatype");
    }

    public static int shortValue(@Nonnull Literal theLiteral) {
        switch (theLiteral.datatype()) {
            case DOUBLE: {
                if (!(theLiteral instanceof DoubleLiteral)) break;
                return (int)((DoubleLiteral)theLiteral).doubleValue();
            }
            case BYTE: {
                if (!(theLiteral instanceof ByteLiteral)) break;
                return ((ByteLiteral)theLiteral).byteValue();
            }
            case INT: {
                if (!(theLiteral instanceof IntLiteral)) break;
                return ((IntLiteral)theLiteral).intValue();
            }
            case FLOAT: {
                if (!(theLiteral instanceof FloatLiteral)) break;
                return (int)((FloatLiteral)theLiteral).floatValue();
            }
            case DECIMAL: {
                if (!(theLiteral instanceof BigDecimalLiteral)) break;
                return ((BigDecimalLiteral)theLiteral).decimalValue().intValue();
            }
            case INTEGER: {
                if (theLiteral instanceof BigIntegerLiteral) {
                    return ((BigIntegerLiteral)theLiteral).integerValue().intValue();
                }
                if (theLiteral instanceof IntegerLiteral) {
                    return ((IntegerLiteral)theLiteral).intValue();
                }
                if (theLiteral instanceof LongIntegerLiteral) {
                    return (int)((LongIntegerLiteral)theLiteral).longValue();
                }
                if (!(theLiteral instanceof GenericIntegerLiteral)) break;
                return ((GenericIntegerLiteral)theLiteral).intValue();
            }
            case UNSIGNED_BYTE: 
            case UNSIGNED_INT: 
            case UNSIGNED_SHORT: 
            case UNSIGNED_LONG: 
            case NEGATIVE_INTEGER: 
            case NON_NEGATIVE_INTEGER: 
            case POSITIVE_INTEGER: 
            case NON_POSITIVE_INTEGER: {
                if (!(theLiteral instanceof GenericIntegerLiteral)) break;
                return ((GenericIntegerLiteral)theLiteral).intValue();
            }
            case LONG: {
                if (!(theLiteral instanceof LongLiteral)) break;
                return (int)((LongLiteral)theLiteral).longValue();
            }
            case SHORT: {
                if (!(theLiteral instanceof ShortLiteral)) break;
                return ((ShortLiteral)theLiteral).shortValue();
            }
        }
        if (!STRICT_TYPES || XMLDatatypes.isNumericDatatype(theLiteral.datatype())) {
            return Short.parseShort(theLiteral.label());
        }
        throw new NumberFormatException("Literal is not a int datatype");
    }

    public static long longValue(@Nonnull Literal theLiteral) {
        switch (theLiteral.datatype()) {
            case DOUBLE: {
                if (!(theLiteral instanceof DoubleLiteral)) break;
                return (long)((DoubleLiteral)theLiteral).doubleValue();
            }
            case BYTE: {
                if (!(theLiteral instanceof ByteLiteral)) break;
                return ((ByteLiteral)theLiteral).byteValue();
            }
            case INT: {
                if (!(theLiteral instanceof IntLiteral)) break;
                return ((IntLiteral)theLiteral).intValue();
            }
            case FLOAT: {
                if (!(theLiteral instanceof FloatLiteral)) break;
                return (long)((FloatLiteral)theLiteral).floatValue();
            }
            case DECIMAL: {
                if (!(theLiteral instanceof BigDecimalLiteral)) break;
                return ((BigDecimalLiteral)theLiteral).decimalValue().longValue();
            }
            case INTEGER: {
                if (theLiteral instanceof BigIntegerLiteral) {
                    return ((BigIntegerLiteral)theLiteral).integerValue().longValue();
                }
                if (theLiteral instanceof IntegerLiteral) {
                    return ((IntegerLiteral)theLiteral).intValue();
                }
                if (theLiteral instanceof LongIntegerLiteral) {
                    return ((LongIntegerLiteral)theLiteral).longValue();
                }
                if (theLiteral instanceof GenericIntegerLiteral) {
                    return ((GenericIntegerLiteral)theLiteral).intValue();
                }
                if (theLiteral instanceof TypedLiteral) {
                    return (long)Double.parseDouble(theLiteral.label());
                }
                return (long)Double.parseDouble(theLiteral.label());
            }
            case UNSIGNED_BYTE: 
            case UNSIGNED_INT: 
            case UNSIGNED_SHORT: 
            case UNSIGNED_LONG: 
            case NEGATIVE_INTEGER: 
            case NON_NEGATIVE_INTEGER: 
            case POSITIVE_INTEGER: 
            case NON_POSITIVE_INTEGER: {
                if (!(theLiteral instanceof GenericIntegerLiteral)) break;
                return ((GenericIntegerLiteral)theLiteral).intValue();
            }
            case LONG: {
                if (!(theLiteral instanceof LongLiteral)) break;
                return ((LongLiteral)theLiteral).longValue();
            }
            case SHORT: {
                if (!(theLiteral instanceof ShortLiteral)) break;
                return ((ShortLiteral)theLiteral).shortValue();
            }
        }
        if (!STRICT_TYPES || XMLDatatypes.isNumericDatatype(theLiteral.datatype())) {
            return Double.valueOf(theLiteral.label()).longValue();
        }
        throw new NumberFormatException("Literal is not a long datatype");
    }

    @Nonnull
    public static Duration durationValue(@Nonnull Literal theLiteral) {
        if (theLiteral instanceof DurationLiteral) {
            return ((DurationLiteral)theLiteral).durationValue();
        }
        if (!STRICT_TYPES || theLiteral.label().startsWith("P")) {
            return Values.DATATYPE_FACTORY.newDuration(theLiteral.label());
        }
        throw new IllegalArgumentException("Literal is not a calendar datatype");
    }

    public static float floatValue(@Nonnull Literal theLiteral) {
        switch (theLiteral.datatype()) {
            case DOUBLE: {
                if (!(theLiteral instanceof DoubleLiteral)) break;
                return (float)((DoubleLiteral)theLiteral).doubleValue();
            }
            case BYTE: {
                if (!(theLiteral instanceof ByteLiteral)) break;
                return ((ByteLiteral)theLiteral).byteValue();
            }
            case INT: {
                if (!(theLiteral instanceof IntLiteral)) break;
                return ((IntLiteral)theLiteral).intValue();
            }
            case FLOAT: {
                if (!(theLiteral instanceof FloatLiteral)) break;
                return ((FloatLiteral)theLiteral).floatValue();
            }
            case DECIMAL: {
                if (!(theLiteral instanceof BigDecimalLiteral)) break;
                return ((BigDecimalLiteral)theLiteral).decimalValue().floatValue();
            }
            case INTEGER: {
                if (theLiteral instanceof BigIntegerLiteral) {
                    return ((BigIntegerLiteral)theLiteral).integerValue().floatValue();
                }
                if (theLiteral instanceof IntegerLiteral) {
                    return ((IntegerLiteral)theLiteral).intValue();
                }
                if (theLiteral instanceof LongIntegerLiteral) {
                    return ((LongIntegerLiteral)theLiteral).longValue();
                }
                if (theLiteral instanceof GenericIntegerLiteral) {
                    return ((GenericIntegerLiteral)theLiteral).intValue();
                }
                if (!(theLiteral instanceof TypedLiteral)) break;
                return Float.parseFloat(theLiteral.label());
            }
            case UNSIGNED_BYTE: 
            case UNSIGNED_INT: 
            case UNSIGNED_SHORT: 
            case UNSIGNED_LONG: 
            case NEGATIVE_INTEGER: 
            case NON_NEGATIVE_INTEGER: 
            case POSITIVE_INTEGER: 
            case NON_POSITIVE_INTEGER: {
                if (!(theLiteral instanceof GenericIntegerLiteral)) break;
                return ((GenericIntegerLiteral)theLiteral).intValue();
            }
            case LONG: {
                if (!(theLiteral instanceof LongLiteral)) break;
                return ((LongLiteral)theLiteral).longValue();
            }
            case SHORT: {
                if (!(theLiteral instanceof ShortLiteral)) break;
                return ((ShortLiteral)theLiteral).shortValue();
            }
        }
        if (!STRICT_TYPES || XMLDatatypes.isNumericDatatype(theLiteral.datatype())) {
            return Float.parseFloat(theLiteral.label());
        }
        throw new NumberFormatException("Literal is not a numeric datatype");
    }

    public static double doubleValue(@Nonnull Literal theLiteral) {
        switch (theLiteral.datatype()) {
            case DOUBLE: {
                if (theLiteral instanceof DoubleLiteral) {
                    return ((DoubleLiteral)theLiteral).doubleValue();
                }
                if (!(theLiteral instanceof DoubleSupplier)) break;
                return ((DoubleSupplier)((Object)theLiteral)).getAsDouble();
            }
            case BYTE: {
                if (!(theLiteral instanceof ByteLiteral)) break;
                return ((ByteLiteral)theLiteral).byteValue();
            }
            case INT: {
                if (!(theLiteral instanceof IntLiteral)) break;
                return ((IntLiteral)theLiteral).intValue();
            }
            case FLOAT: {
                if (theLiteral instanceof FloatLiteral) {
                    return ((FloatLiteral)theLiteral).floatValue();
                }
                return Double.parseDouble(theLiteral.label());
            }
            case DECIMAL: {
                if (!(theLiteral instanceof BigDecimalLiteral)) break;
                return ((BigDecimalLiteral)theLiteral).decimalValue().doubleValue();
            }
            case INTEGER: {
                if (theLiteral instanceof BigIntegerLiteral) {
                    return ((BigIntegerLiteral)theLiteral).integerValue().doubleValue();
                }
                if (theLiteral instanceof IntegerLiteral) {
                    return ((IntegerLiteral)theLiteral).intValue();
                }
                if (theLiteral instanceof LongIntegerLiteral) {
                    return ((LongIntegerLiteral)theLiteral).longValue();
                }
                if (theLiteral instanceof GenericIntegerLiteral) {
                    return ((GenericIntegerLiteral)theLiteral).intValue();
                }
                if (!(theLiteral instanceof TypedLiteral)) break;
                return Double.parseDouble(theLiteral.label());
            }
            case UNSIGNED_BYTE: 
            case UNSIGNED_INT: 
            case UNSIGNED_SHORT: 
            case UNSIGNED_LONG: 
            case NEGATIVE_INTEGER: 
            case NON_NEGATIVE_INTEGER: 
            case POSITIVE_INTEGER: 
            case NON_POSITIVE_INTEGER: {
                if (!(theLiteral instanceof GenericIntegerLiteral)) break;
                return ((GenericIntegerLiteral)theLiteral).intValue();
            }
            case LONG: {
                if (!(theLiteral instanceof LongLiteral)) break;
                return ((LongLiteral)theLiteral).longValue();
            }
            case SHORT: {
                if (!(theLiteral instanceof ShortLiteral)) break;
                return ((ShortLiteral)theLiteral).shortValue();
            }
        }
        if (!STRICT_TYPES) {
            return Double.parseDouble(theLiteral.label());
        }
        throw new NumberFormatException("Literal is not a numeric datatype");
    }

    public static BigInteger integerValue(@Nonnull Literal theLiteral) {
        switch (theLiteral.datatype()) {
            case DOUBLE: {
                if (!(theLiteral instanceof DoubleLiteral)) break;
                return BigInteger.valueOf((long)((DoubleLiteral)theLiteral).doubleValue());
            }
            case BYTE: {
                if (!(theLiteral instanceof ByteLiteral)) break;
                return BigInteger.valueOf(((ByteLiteral)theLiteral).byteValue());
            }
            case INT: {
                if (!(theLiteral instanceof IntLiteral)) break;
                return BigInteger.valueOf(((IntLiteral)theLiteral).intValue());
            }
            case FLOAT: {
                if (!(theLiteral instanceof FloatLiteral)) break;
                return BigInteger.valueOf((long)((FloatLiteral)theLiteral).floatValue());
            }
            case DECIMAL: {
                if (!(theLiteral instanceof BigDecimalLiteral)) break;
                return ((BigDecimalLiteral)theLiteral).decimalValue().toBigInteger();
            }
            case INTEGER: {
                if (theLiteral instanceof BigIntegerLiteral) {
                    return ((BigIntegerLiteral)theLiteral).integerValue();
                }
                if (theLiteral instanceof IntegerLiteral) {
                    return BigInteger.valueOf(((IntegerLiteral)theLiteral).intValue());
                }
                if (theLiteral instanceof LongIntegerLiteral) {
                    return BigInteger.valueOf(((LongIntegerLiteral)theLiteral).longValue());
                }
                if (theLiteral instanceof GenericIntegerLiteral) {
                    return BigInteger.valueOf(((GenericIntegerLiteral)theLiteral).intValue());
                }
                if (!(theLiteral instanceof TypedLiteral)) break;
                return new BigInteger(theLiteral.label());
            }
            case UNSIGNED_BYTE: 
            case UNSIGNED_INT: 
            case UNSIGNED_SHORT: 
            case UNSIGNED_LONG: 
            case NEGATIVE_INTEGER: 
            case NON_NEGATIVE_INTEGER: 
            case POSITIVE_INTEGER: 
            case NON_POSITIVE_INTEGER: {
                if (!(theLiteral instanceof GenericIntegerLiteral)) break;
                return BigInteger.valueOf(((GenericIntegerLiteral)theLiteral).intValue());
            }
            case LONG: {
                if (!(theLiteral instanceof LongLiteral)) break;
                return BigInteger.valueOf(((LongLiteral)theLiteral).longValue());
            }
            case SHORT: {
                if (!(theLiteral instanceof ShortLiteral)) break;
                return BigInteger.valueOf(((ShortLiteral)theLiteral).shortValue());
            }
        }
        if (!STRICT_TYPES) {
            return new BigInteger(theLiteral.label());
        }
        throw new NumberFormatException("Literal is not a numeric datatype");
    }

    public static BigDecimal decimalValue(@Nonnull Literal theLiteral) {
        switch (theLiteral.datatype()) {
            case DOUBLE: {
                if (!(theLiteral instanceof DoubleLiteral)) break;
                return BigDecimal.valueOf(((DoubleLiteral)theLiteral).doubleValue());
            }
            case BYTE: {
                if (!(theLiteral instanceof ByteLiteral)) break;
                return BigDecimal.valueOf(((ByteLiteral)theLiteral).byteValue());
            }
            case INT: {
                if (!(theLiteral instanceof IntLiteral)) break;
                return BigDecimal.valueOf(((IntLiteral)theLiteral).intValue());
            }
            case FLOAT: {
                if (!(theLiteral instanceof FloatLiteral)) break;
                return BigDecimal.valueOf(((FloatLiteral)theLiteral).floatValue());
            }
            case DECIMAL: {
                if (theLiteral instanceof BigDecimalLiteral) {
                    return ((BigDecimalLiteral)theLiteral).decimalValue();
                }
                if (!(theLiteral instanceof GenericIntegerLiteral)) break;
                return new BigDecimal(((GenericIntegerLiteral)theLiteral).intValue());
            }
            case INTEGER: {
                if (theLiteral instanceof BigIntegerLiteral) {
                    return BigDecimal.valueOf(((BigIntegerLiteral)theLiteral).integerValue().doubleValue());
                }
                if (theLiteral instanceof IntegerLiteral) {
                    return BigDecimal.valueOf(((IntegerLiteral)theLiteral).intValue());
                }
                if (theLiteral instanceof LongIntegerLiteral) {
                    return BigDecimal.valueOf(((LongIntegerLiteral)theLiteral).longValue());
                }
                if (theLiteral instanceof GenericIntegerLiteral) {
                    return BigDecimal.valueOf(((GenericIntegerLiteral)theLiteral).intValue());
                }
                if (!(theLiteral instanceof TypedLiteral)) break;
                return new BigDecimal(theLiteral.label());
            }
            case UNSIGNED_BYTE: 
            case UNSIGNED_INT: 
            case UNSIGNED_SHORT: 
            case UNSIGNED_LONG: 
            case NEGATIVE_INTEGER: 
            case NON_NEGATIVE_INTEGER: 
            case POSITIVE_INTEGER: 
            case NON_POSITIVE_INTEGER: {
                if (!(theLiteral instanceof GenericIntegerLiteral)) break;
                return BigDecimal.valueOf(((GenericIntegerLiteral)theLiteral).intValue());
            }
            case LONG: {
                if (!(theLiteral instanceof LongLiteral)) break;
                return BigDecimal.valueOf(((LongLiteral)theLiteral).longValue());
            }
            case SHORT: {
                if (!(theLiteral instanceof ShortLiteral)) break;
                return BigDecimal.valueOf(((ShortLiteral)theLiteral).shortValue());
            }
        }
        if (!STRICT_TYPES) {
            return new BigDecimal(theLiteral.label());
        }
        throw new NumberFormatException("Literal is not a numeric datatype");
    }
}

