/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark;

import com.google.common.collect.ImmutableSortedMap;
import com.stardog.stark.IRI;
import com.stardog.stark.Literal;
import com.stardog.stark.Values;
import com.stardog.stark.vocabs.RDF;
import com.stardog.stark.vocabs.XSD;
import java.util.Comparator;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public enum Datatype {
    BOOLEAN(XSD.BOOLEAN),
    INT(XSD.INT),
    INTEGER(XSD.INTEGER),
    LONG(XSD.LONG),
    FLOAT(XSD.FLOAT),
    DOUBLE(XSD.DOUBLE),
    BYTE(XSD.BYTE),
    SHORT(XSD.SHORT),
    STRING(XSD.STRING),
    TIME(XSD.TIME),
    DATE(XSD.DATE),
    GYEARMONTH(XSD.GYEARMONTH),
    GYEAR(XSD.GYEAR),
    GMONTHDAY(XSD.GMONTHDAY),
    GDAY(XSD.GDAY),
    GMONTH(XSD.GMONTH),
    BASE64BINARY(XSD.BASE64BINARY),
    HEXBINARY(XSD.HEXBINARY),
    DECIMAL(XSD.DECIMAL),
    ANYURI(XSD.ANYURI),
    QNAME(XSD.QNAME),
    NOTATION(XSD.NOTATION),
    NORMALIZEDSTRING(XSD.NORMALIZEDSTRING),
    TOKEN(XSD.TOKEN),
    LANGUAGE(XSD.LANGUAGE),
    NMTOKEN(XSD.NMTOKEN),
    NMTOKENS(XSD.NMTOKENS),
    NAME(XSD.NAME),
    NCNAME(XSD.NCNAME),
    ID(XSD.ID),
    IDREF(XSD.IDREF),
    IDREFS(XSD.IDREFS),
    ENTITY(XSD.ENTITY),
    ENTITIES(XSD.ENTITIES),
    NON_POSITIVE_INTEGER(XSD.NON_POSITIVE_INTEGER),
    NEGATIVE_INTEGER(XSD.NEGATIVE_INTEGER),
    NON_NEGATIVE_INTEGER(XSD.NON_NEGATIVE_INTEGER),
    POSITIVE_INTEGER(XSD.POSITIVE_INTEGER),
    UNSIGNED_LONG(XSD.UNSIGNED_LONG),
    UNSIGNED_INT(XSD.UNSIGNED_INT),
    UNSIGNED_SHORT(XSD.UNSIGNED_SHORT),
    UNSIGNED_BYTE(XSD.UNSIGNED_BYTE),
    DATETIME(XSD.DATETIME),
    DATETIMESTAMP(XSD.DATETIMESTAMP),
    DURATION(XSD.DURATION),
    DURATION_DAYTIME(XSD.DAYTIMEDURATION),
    DURATION_YEARMONTH(XSD.YEARMONTHDURATION),
    LANG_STRING(RDF.LANG_STRING),
    UDF(Values.iri("http://api.stardog.com/udf"));

    private static final ImmutableSortedMap<IRI, Datatype> ALL;
    private static final Datatype[] ALL_BY_ID;
    private final IRI mIRI;
    private final int mId;

    @Nonnull
    public static Datatype of(@Nonnull IRI theIRI) {
        return (Datatype)((Object)ALL.getOrDefault((Object)theIRI, (Object)UDF));
    }

    @Nonnull
    public static Datatype of(@Nonnull int theId) {
        if (theId >= 0 && theId < ALL_BY_ID.length) {
            return ALL_BY_ID[theId];
        }
        return UDF;
    }

    public static boolean datatypesEqual(@Nonnull Literal theLeft, @Nonnull Literal theRight) {
        Datatype aRightDt;
        Datatype aLeftDt = theLeft.datatype();
        return aLeftDt == (aRightDt = theRight.datatype()) || aLeftDt.iri().equals(theRight.datatypeIRI());
    }

    private Datatype(IRI theIRI) {
        this.mIRI = theIRI;
        this.mId = this.ordinal();
    }

    @Nonnull
    public IRI iri() {
        return this.mIRI;
    }

    public int getId() {
        return this.mId;
    }

    public String toString() {
        return this.mIRI.toString();
    }

    static {
        ImmutableSortedMap.Builder aBuilder = ImmutableSortedMap.orderedBy(Comparator.comparing(Object::toString));
        Stream.of(Datatype.values()).forEach(v -> aBuilder.put((Object)v.iri(), (Object)v));
        ALL = aBuilder.build();
        ALL_BY_ID = new Datatype[Datatype.values().length];
        Datatype[] datatypeArray = Datatype.values();
        int n = datatypeArray.length;
        for (int i = 0; i < n; ++i) {
            Datatype aDatatype;
            Datatype.ALL_BY_ID[aDatatype.getId()] = aDatatype = datatypeArray[i];
        }
    }
}

