/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.io.binary;

import com.complexible.common.base.Option;
import com.complexible.common.base.Options;
import com.complexible.common.cache.Caches;
import com.stardog.stark.BNode;
import com.stardog.stark.IRI;
import com.stardog.stark.Literal;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import com.stardog.stark.io.RDFWriter;
import com.stardog.stark.io.RDFWriterFactory;
import com.stardog.stark.io.WritingFailed;
import com.stardog.stark.io.binary.BinaryRDFConstants;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.annotation.Nonnull;

public final class BinaryRDFWriter
implements RDFWriter,
BinaryRDFConstants {
    public static final Option<Integer> MAX_HIST_SIZE = Option.create((String)"binary.rdf.max.history.size", (Object)4096);
    public static final Option<Integer> MAX_BUF_SIZE = Option.create((String)"binary.rdf.max.buffer.size", (Object)8192);
    private final int maxHistSize;
    private final Map<Value, Integer> valueIdentifiers;
    private int maxValueId = 0;
    private final DataOutputStream out;
    private boolean writingStarted = false;

    private BinaryRDFWriter(@Nonnull OutputStream theStream, @Nonnull Options theOptions) {
        int bufSize = (Integer)theOptions.get(MAX_BUF_SIZE);
        OutputStream buffered = bufSize > 0 ? new BufferedOutputStream(theStream, bufSize) : theStream;
        this.out = new DataOutputStream(buffered);
        this.maxHistSize = (Integer)theOptions.get(MAX_HIST_SIZE);
        this.valueIdentifiers = Caches.newLRUCache((int)16, (int)this.maxHistSize);
    }

    @Nonnull
    public RDFFormat format() {
        return RDFFormats.BINARY;
    }

    public void start() {
        if (!this.writingStarted) {
            this.writingStarted = true;
            try {
                this.out.write(MAGIC_NUMBER);
                this.out.writeInt(4);
                this.out.writeInt(this.maxHistSize);
            }
            catch (IOException e) {
                throw new WritingFailed((Throwable)e);
            }
        }
    }

    public void end() {
        this.start();
        try {
            this.out.writeByte(127);
            this.out.flush();
            this.writingStarted = false;
        }
        catch (IOException e) {
            throw new WritingFailed((Throwable)e);
        }
    }

    public void namespace(@Nonnull String thePrefix, @Nonnull String theIRI) {
        this.start();
        try {
            this.out.writeByte(0);
            this.writeString(thePrefix);
            this.writeString(theIRI);
        }
        catch (IOException e) {
            throw new WritingFailed((Throwable)e);
        }
    }

    public void comment(@Nonnull String theComment) {
        this.start();
        try {
            this.out.writeByte(2);
            this.writeString(theComment);
        }
        catch (IOException e) {
            throw new WritingFailed((Throwable)e);
        }
    }

    public void handle(@Nonnull Statement st) {
        this.start();
        try {
            this.writeStatement(st, false);
        }
        catch (IOException e) {
            throw new WritingFailed((Throwable)e);
        }
    }

    private void writeStatement(@Nonnull Statement st, boolean isEmbedded) throws IOException {
        int contextId;
        boolean canAssignId = !isEmbedded;
        int subjId = this.getValueId((Value)st.subject(), canAssignId);
        int predId = this.getValueId((Value)st.predicate(), canAssignId);
        int objId = this.getValueId(st.object(), canAssignId);
        Resource context = st.context();
        boolean isDefault = Values.isDefaultGraph((Resource)context);
        int n = contextId = isDefault ? -1 : this.getValueId((Value)context, canAssignId);
        int type = isEmbedded ? (isDefault ? 7 : 8) : (isDefault ? 4 : 1);
        this.out.writeByte(type);
        this.writeValueOrId((Value)st.subject(), subjId);
        this.writeValueOrId((Value)st.predicate(), predId);
        this.writeValueOrId(st.object(), objId);
        if (!isDefault) {
            this.writeValueOrId((Value)context, contextId);
        }
    }

    private int getValueId(@Nonnull Value theValue, boolean canAssignId) throws IOException {
        Integer id = this.valueIdentifiers.get(theValue);
        if (id == null) {
            id = -1;
            this.valueIdentifiers.put(theValue, id);
        } else if (id == -1 && canAssignId) {
            id = this.assignValueId(theValue);
            this.valueIdentifiers.put(theValue, id);
        }
        return id;
    }

    private Integer assignValueId(@Nonnull Value theValue) throws IOException {
        if (this.maxValueId == Integer.MAX_VALUE) {
            throw new WritingFailed("Too many unique values: value ID overflow");
        }
        Integer id = this.maxValueId++;
        this.out.writeByte(3);
        this.out.writeInt(id);
        this.writeValue(theValue);
        this.valueIdentifiers.put(theValue, id);
        return id;
    }

    private void writeValueOrId(@Nonnull Value theValue, int theId) throws IOException {
        if (theValue == null) {
            this.out.writeByte(0);
        } else if (theId >= 0) {
            this.out.writeByte(6);
            this.out.writeInt(theId);
        } else {
            this.writeValue(theValue);
        }
    }

    private void writeValue(@Nonnull Value theValue) throws IOException {
        if (theValue instanceof IRI) {
            this.writeURI((IRI)theValue);
        } else if (theValue instanceof BNode) {
            this.writeBNode((BNode)theValue);
        } else if (theValue instanceof Literal) {
            this.writeLiteral((Literal)theValue);
        } else if (theValue instanceof Statement) {
            this.writeStatement((Statement)theValue, true);
        } else {
            throw new WritingFailed("Unknown Value object type: " + String.valueOf(theValue.getClass()));
        }
    }

    private void writeURI(@Nonnull IRI theIRI) throws IOException {
        this.out.writeByte(1);
        this.writeString(theIRI.toString());
    }

    private void writeBNode(@Nonnull BNode theBNode) throws IOException {
        this.out.writeByte(2);
        this.writeString(theBNode.id());
    }

    private void writeLiteral(@Nonnull Literal theLiteral) throws IOException {
        String label = theLiteral.label();
        IRI datatype = theLiteral.datatypeIRI();
        if (Literal.isLanguageLiteral((Literal)theLiteral)) {
            this.out.writeByte(4);
            this.writeString(label);
            this.writeString((String)theLiteral.lang().get());
        } else {
            this.out.writeByte(5);
            this.writeString(label);
            this.writeString(datatype.toString());
        }
    }

    private void writeString(@Nonnull String theStr) throws IOException {
        byte[] utf8Bytes = theStr.getBytes(StandardCharsets.UTF_8);
        int length = utf8Bytes.length;
        if (length < 65535) {
            this.out.writeShort(length);
        } else {
            this.out.writeShort(65535);
            this.out.writeInt(length);
        }
        this.out.write(utf8Bytes);
    }

    public static final class BinaryRDFWriterFactory
    implements RDFWriterFactory {
        @Nonnull
        public RDFFormat format() {
            return RDFFormats.BINARY;
        }

        @Nonnull
        public RDFWriter create(@Nonnull OutputStream theStream, @Nonnull Options theOptions) {
            return new BinaryRDFWriter(theStream, theOptions);
        }
    }
}

