/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.io.binary;

import com.complexible.common.base.Options;
import com.complexible.common.cache.Caches;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import com.stardog.stark.IRI;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.io.ParserContext;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import com.stardog.stark.io.RDFHandler;
import com.stardog.stark.io.RDFParser;
import com.stardog.stark.io.binary.BinaryRDFConstants;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.annotation.Nonnull;

public final class BinaryRDFParser
implements RDFParser,
BinaryRDFConstants {
    @Nonnull
    public RDFFormat format() {
        return RDFFormats.BINARY;
    }

    public void parse(@Nonnull InputStream theStream, @Nonnull RDFHandler theHandler, @Nonnull Options theOptions) throws IOException {
        block10: {
            BinaryParserContext aContext = new BinaryParserContext(new DataInputStream(new BufferedInputStream(theStream)), theHandler, theOptions);
            try {
                while (true) {
                    byte recordType = aContext.mInput.readByte();
                    switch (recordType) {
                        case 127: {
                            break block10;
                        }
                        case 1: 
                        case 4: {
                            theHandler.handle(aContext.readStatement(recordType));
                            break;
                        }
                        case 3: {
                            aContext.readValueDecl();
                            break;
                        }
                        case 0: {
                            theHandler.namespace(aContext.readString(), aContext.readString());
                            break;
                        }
                        case 2: {
                            String aComment = aContext.readString();
                            break;
                        }
                        default: {
                            throw aContext.error("Invalid record type: " + recordType);
                        }
                    }
                }
            }
            catch (EOFException e) {
                throw aContext.error("Unexpected EOF; file appears to be incomplete.");
            }
        }
        theHandler.end();
    }

    private static final class BinaryParserContext
    extends ParserContext {
        private final Map<Integer, Value> valueIdentifiers;
        private final DataInputStream mInput;
        private final int mFormatVersion;
        private byte[] buf = new byte[16];

        public BinaryParserContext(@Nonnull DataInputStream theInput, @Nonnull RDFHandler theHandler, @Nonnull Options theOptions) throws IOException {
            super(theHandler, theOptions);
            this.mInput = theInput;
            byte[] magicNumber = this.readFully(BinaryRDFConstants.MAGIC_NUMBER.length);
            for (int i = 0; i < BinaryRDFConstants.MAGIC_NUMBER.length; ++i) {
                if (magicNumber[i] == BinaryRDFConstants.MAGIC_NUMBER[i]) continue;
                throw this.error("File does not contain a binary RDF document");
            }
            this.mFormatVersion = this.readInt();
            if (this.mFormatVersion == 2) {
                this.valueIdentifiers = Maps.newHashMap();
            } else if (this.mFormatVersion <= 4) {
                int maxHistSize = this.readInt();
                this.valueIdentifiers = Caches.newLRUCache((int)16, (int)maxHistSize);
            } else {
                throw this.error("Incompatible format version: " + this.mFormatVersion);
            }
            theHandler.start();
        }

        private Statement readStatement(int recordType) throws IOException {
            Value v = this.readValue();
            if (!(v instanceof Resource)) {
                throw this.error("Invalid subject type: " + String.valueOf(v));
            }
            Resource subj = (Resource)v;
            v = this.readValue();
            IRI pred = null;
            if (!(v instanceof IRI)) {
                throw this.error("Invalid predicate type: " + String.valueOf(v));
            }
            pred = (IRI)v;
            Value obj = this.readValue();
            if (obj == null) {
                throw this.error("Invalid object type: null");
            }
            IRI context = Values.DEFAULT_GRAPH;
            if (recordType == 1) {
                v = this.readValue();
                if (v instanceof Resource) {
                    context = (Resource)v;
                } else {
                    throw this.error("Invalid context type: " + String.valueOf(v));
                }
            }
            return Values.statement((Resource)subj, (IRI)pred, (Value)obj, (Resource)context);
        }

        int readInt() throws IOException {
            return this.mInput.readInt();
        }

        String readString() throws IOException {
            if (this.mFormatVersion >= 4) {
                int utfLength = this.mInput.readUnsignedShort();
                if (utfLength == 65535) {
                    utfLength = this.readInt();
                }
                this.readFully(utfLength);
                return new String(this.buf, 0, utfLength, StandardCharsets.UTF_8);
            }
            int stringLength = this.readInt();
            int stringBytes = stringLength << 1;
            this.readFully(stringBytes);
            return new String(this.buf, 0, stringBytes, "UTF-16BE");
        }

        private void ensure(int theLen) {
            if (this.buf.length < theLen) {
                this.buf = new byte[theLen << 1];
            }
        }

        byte[] readFully(int theLen) throws IOException {
            this.ensure(theLen);
            ByteStreams.readFully((InputStream)this.mInput, (byte[])this.buf, (int)0, (int)theLen);
            return this.buf;
        }

        private Value readValueRef() throws IOException {
            return this.valueIdentifiers.get(this.readInt());
        }

        private void readValueDecl() throws IOException {
            int id = this.readInt();
            Value v = this.readValue();
            this.valueIdentifiers.put(id, v);
        }

        private Value readValue() throws IOException {
            byte valueType = this.mInput.readByte();
            switch (valueType) {
                case 0: {
                    return null;
                }
                case 6: {
                    return this.readValueRef();
                }
                case 1: {
                    return Values.iri((String)this.readString());
                }
                case 2: {
                    return this.createBNode(this.readString());
                }
                case 3: {
                    return this.createLiteral(this.readString(), null, null);
                }
                case 4: {
                    return this.createLiteral(this.readString(), this.readString(), null);
                }
                case 5: {
                    return this.createLiteral(this.readString(), null, Values.iri((String)this.readString()));
                }
                case 7: {
                    return this.readStatement(4);
                }
                case 8: {
                    return this.readStatement(1);
                }
            }
            throw this.error("Unknown value type: " + valueType);
        }
    }
}

