/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.search;

import com.complexible.stardog.metadata.ConfigProperty;
import com.complexible.stardog.metadata.MetaProperty;
import com.complexible.stardog.metadata.MetaPropertyProvider;
import com.complexible.stardog.metadata.OptionsCategory;
import com.complexible.stardog.search.SearchIndexState;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Singleton;
import com.stardog.stark.Datatype;
import com.stardog.stark.IRI;
import com.stardog.stark.vocabs.RDF;
import java.util.Collection;

@Singleton
public final class SearchOptions
implements MetaPropertyProvider {
    @Deprecated
    private static final String PROPERTY_SEARCH_INDEX_STATE_OLD = "search.index.dirty";
    public static final String PROPERTY_SEARCH_INDEX_STATE = "search.index.state";
    private static final String PROPERTY_SEARCH_REINDEX = "search.reindex.tx";
    private static final String PROPERTY_SEARCHABLE = "search.enabled";
    public static final String PROPERTY_SEARCH_SEMANTIC_MODEL = "search.semantic.model";
    public static final String PROPERTY_SEARCH_SEMANTIC_ENABLED = "search.semantic.enabled";
    public static final String PROPERTY_SEARCH_LEXICAL = "search.lexical.enabled";
    public static final String PROPERTY_LEADING_WILDCARD_SEARCH_ENABLED = "search.wildcard.search.enabled";
    public static final String PROPERTY_SEARCH_PAGE_SIZE = "search.page.size";
    public static final String PROPERTY_DEFAULT_QUERY_OPERATOR = "search.default.query.operator";
    public static final String PROPERTY_INDEX_DATATYPE = "search.index.datatypes";
    public static final String PROPERTY_WORD_BREAK_CHARS = "search.index.wordbreak.chars";
    public static final String PROPERTY_INDEX_STOPWORDS = "search.index.stopwords";
    public static final String PROPERTY_TOKEN_FILTERS = "search.index.token.filters";
    public static final String PROPERTY_INDEX_PROPERTIES_EXCLUDED = "search.index.properties.excluded";
    public static final String PROPERTY_SEARCH_CONTEXTS_FILTER = "search.index.contexts.filter";
    public static final String PROPERTY_SEARCH_CONTEXTS_EXCLUDED = "search.index.contexts.excluded";
    public static final String PROPERTY_SEARCH_SEMANTIC_CONTEXTS_FILTER = "search.semantic.index.contexts.filter";
    public static final String PROPERTY_INDEX_PROPERTIES_INCLUDED = "search.index.properties.included";
    public static final String PROPERTY_INDEX_COMPUTE_NORM = "search.index.compute.norm";
    public static final String PROPERTY_OPTIMIZE = "optimize.search";
    public static final String PROPERTY_USE_VACUUMING = "search.index.vacuum";
    public static final String PROPERTY_REINDEX_CACHE_SIZE = "search.reindex.cache.size";
    public static final String PROPERTY_SEARCH_INDEX_BATCH_SIZE = "search.index.batch.size";
    public static final String DEFAULT_VECTOR_MODEL = "";
    @Deprecated
    public static final ConfigProperty<Boolean> SEARCH_INDEX_DIRTY = (ConfigProperty)MetaProperty.config((String)"search.index.dirty", (Object)true).database().temporary().build();
    public static final ConfigProperty<SearchIndexState> SEARCH_INDEX_STATE = (ConfigProperty)MetaProperty.config((String)"search.index.state", (Object)((Object)SearchIndexState.Dirty)).database().readable().writableWhileOnline().category(OptionsCategory.FULL_TEXT_SEARCH).label("The internal state of the full-text index: 'Dirty' means it should be recomputed before it can be used by queries. Stardog will do it automatically on startup or if optimize is called on the database. 'Clean' means the index is ready for use and contains all and only text literals which are present in the graph. 'Phantoms' means the index can be used but may contain text literals previously removed from the graph. This is not an issue as long as SPARQL queries always join full-text predicates with triple patterns which match quads in the graph.").build();
    public static final ConfigProperty<Boolean> SEARCH_REINDEX_IN_TX = (ConfigProperty)MetaProperty.config((String)"search.reindex.tx", (Object)true).database().creatable().readable().writable().writableWhileOnline().category(OptionsCategory.FULL_TEXT_SEARCH).label("Index Tx Literals").description("Whether literals added during a transaction are automatically indexed. If this flag is set to 'false', then full-text search queries will return incomplete results until the index is rebuilt.").build();
    public static final ConfigProperty<Boolean> SEARCHABLE = (ConfigProperty)MetaProperty.config((String)"search.enabled", (Object)false).database().readable().creatable().writable().category(OptionsCategory.FULL_TEXT_SEARCH).label("Enable Search").description("Enables the full-text (unstructured) search index for the database; important for Text Search applications.").nonsecure().build();
    public static final ConfigProperty<Boolean> SEARCH_LEXICAL = (ConfigProperty)MetaProperty.config((String)"search.lexical.enabled", (Object)true).database().readable().creatable().writable().category(OptionsCategory.FULL_TEXT_SEARCH).label("Enable Lexical Search").description("Enables lexical search (default implementation of full-text search).").nonsecure().build();
    public static final ConfigProperty<Boolean> SEARCH_SEMANTIC = (ConfigProperty)MetaProperty.config((String)"search.semantic.enabled", (Object)false).database().readable().creatable().writable().category(OptionsCategory.FULL_TEXT_SEARCH).label("Enable Semantic Search").description("Enables semantic search.").nonsecure().build();
    public static final ConfigProperty<String> SEARCH_SEMANTIC_MODEL = (ConfigProperty)MetaProperty.config((String)"search.semantic.model", (Object)"").database().readable().creatable().writable().category(OptionsCategory.FULL_TEXT_SEARCH).label("Semantic search language model").description("URL to a language model that will be used to generate embeddings vectors and store them in Lucene index. The default value is an empty string which means the default semantic model shipped with Stardog will be used.").nonsecure().build();
    public static final ConfigProperty<Boolean> LEADING_WILDCARD_SEARCH_ENABLED = (ConfigProperty)MetaProperty.config((String)"search.wildcard.search.enabled", (Object)false).database().creatable().readable().writableWhileOnline().category(OptionsCategory.FULL_TEXT_SEARCH).label("Leading Wildcard Search").description("Enable support to query the Lucene full-text search index with leading wildcards.").build();
    public static final ConfigProperty<Integer> SEARCH_PAGE_SIZE = (ConfigProperty)MetaProperty.config((String)"search.page.size", (Object)100000).database().creatable().readable().writableWhileOnline().category(OptionsCategory.FULL_TEXT_SEARCH).label("Default Page Size").description("Specify the page size used for iteration over results from the full-text index. A page is held in memory, so this count should NOT be large.").build();
    @Deprecated
    public static final ConfigProperty<Integer> SEARCH_DEFAULT_LIMIT = (ConfigProperty)MetaProperty.config((String)"search.default.limit", (Object)-1).database().creatable().readable().writableWhileOnline().category(OptionsCategory.FULL_TEXT_SEARCH).label("Default Limit").description("Specify the default limit on the number of results returned from a full-text search (-1 returns all results). This only limits the number of results returned from the Lucene full-text index, not from its containing query.").build();
    public static final ConfigProperty<Double> RELATIVE_THRESHOLD = (ConfigProperty)MetaProperty.config((String)"search.relative.threshold", (Object)0.0).database().creatable().readable().writable().category(OptionsCategory.FULL_TEXT_SEARCH).label("Default Relative Threshold").description("Specify the default relative threshold for full-text search. The value should be a floating number between 0.0 and 1.0  to indicate all matching literals should be returned. A relative threshold of 0.0 means only the full-text matches with highest score will be returned. In general, if the top score for a query is {@code S} then only the matches with score higher than or equal to `S * relativeThreshold` will be returned. The relative threshold value can be overridden in the full-text search query with the `fts:relativeThreshold` parameter.").build();
    public static final ConfigProperty<Double> LABEL_RELATIVE_THRESHOLD = (ConfigProperty)MetaProperty.config((String)"search.label.relative.threshold", (Object)0.8).database().creatable().readable().writable().category(OptionsCategory.FULL_TEXT_SEARCH).label("Label Relative Threshold").description("Specify the relative threshold used for the Entity Label Service. The Entity Label Service uses full-text search to find the entities with a given label. This is the relative threshold value that will be used in these cases overriding the default relative threshold. See the description for the option " + RELATIVE_THRESHOLD.getName() + " for more details.").build();
    public static final ConfigProperty<String> SEARCH_DEFAULT_QUERY_OPERATOR = (ConfigProperty)MetaProperty.config((String)"search.default.query.operator", (Object)"OR").database().creatable().readable().writable().category(OptionsCategory.FULL_TEXT_SEARCH).label("Default Lucene operator").possibleValues((Collection)ImmutableList.of((Object)"AND", (Object)"OR")).systemDefaultValue((Object)"OR").description("Specify the Lucene operator (AND/OR) to use when the search query has multiple keywords").build();
    public static final ConfigProperty<Collection<IRI>> INDEX_PROPERTIES_EXCLUDED = (ConfigProperty)MetaProperty.config((String)"search.index.properties.excluded", IRI.class, (Collection)ImmutableSet.of()).database().readable().creatable().writable().category(OptionsCategory.FULL_TEXT_SEARCH).label("Excluded Properties in Index").description("Option to specify the excluded properties for literals not to be indexed in Lucene. Literals with these properties cannot be evaluated for indexing.").build();
    public static final ConfigProperty<Collection<IRI>> INDEX_PROPERTIES_INCLUDED = (ConfigProperty)MetaProperty.config((String)"search.index.properties.included", IRI.class, (Collection)ImmutableSet.of()).database().readable().creatable().writable().category(OptionsCategory.FULL_TEXT_SEARCH).label("Included Properties in Index").description("Option to specify the only properties for literals to be indexed in Lucene. Please note that if search.index.properties.excluded option is set, this option will have no effect.").build();
    public static final ConfigProperty<Collection<IRI>> SEARCH_CONTEXTS_FILTER = (ConfigProperty)MetaProperty.config((String)"search.index.contexts.filter", IRI.class, (Collection)ImmutableSet.of()).database().readable().creatable().writable().category(OptionsCategory.FULL_TEXT_SEARCH).label("Lexical Search Named Graphs Filter").description("Option to specify the collection of named graphs to be excluded or included for lexical search indexing. If search.index.contexts.excluded is set to true, the literals in the named graphs specified by this option will be excluded from the lexical search index. Otherwise only the literals from the specified named graphs will be indexed. This option has no effect if " + String.valueOf(SEARCHABLE) + " is not enabled.").build();
    public static final ConfigProperty<Boolean> SEARCH_CONTEXTS_EXCLUDED = (ConfigProperty)MetaProperty.config((String)"search.index.contexts.excluded", (Object)true).database().readable().creatable().writable().category(OptionsCategory.FULL_TEXT_SEARCH).label("Exclude or Include Search Contexts Set").description("Option to specify if the collection of contexts in named graphs is going to be leveraged as either excluded or included for literals to be indexed.").build();
    public static final ConfigProperty<Collection<IRI>> SEARCH_SEMANTIC_CONTEXTS_FILTER = (ConfigProperty)MetaProperty.config((String)"search.semantic.index.contexts.filter", IRI.class, (Collection)ImmutableSet.of()).database().readable().creatable().writable().category(OptionsCategory.FULL_TEXT_SEARCH).label("Semantic Search Named Graphs Filter").description("Option to specify the collection of named graphs to be excluded or included for semantic search indexing. If search.index.contexts.excluded is set to true, the literals in the named graphs specified by this option will be excluded from the semantic search index. Otherwise only the literals from the specified named graphs will be indexed. This option has no effect if semantic search is not enabled via the " + String.valueOf(SEARCH_SEMANTIC) + " option.").build();
    public static final ConfigProperty<Collection<IRI>> INDEX_DATATYPES = (ConfigProperty)MetaProperty.config((String)"search.index.datatypes", IRI.class, (Collection)ImmutableSet.of((Object)Datatype.STRING.iri(), (Object)RDF.LANG_STRING)).database().readable().writable().creatable().category(OptionsCategory.FULL_TEXT_SEARCH).label("Index Datatypes").description("Option to specify the datatypes for which to index literals in Lucene. Literals with other datatypes will not be accessible via full-text search.").build();
    public static final ConfigProperty<Boolean> INDEX_COMPUTE_NORM = (ConfigProperty)MetaProperty.config((String)"search.index.compute.norm", (Object)false).database().readable().writable().creatable().category(OptionsCategory.FULL_TEXT_SEARCH).label("Index Value Lengths (norms)").description("Option to specify that value lengths (norms) should be computed and indexed. This is required for document length to influence scoring rank.").build();
    public static final ConfigProperty<Boolean> OPTIMIZE = (ConfigProperty)MetaProperty.config((String)"optimize.search", (Object)true).database().creatable().readable().writableWhileOnline().build();
    public static final ConfigProperty<Boolean> USE_VACUUMING = (ConfigProperty)MetaProperty.config((String)"search.index.vacuum", (Object)false).database().creatable().readable().writableWhileOnline().category(OptionsCategory.FULL_TEXT_SEARCH).label("Use Vacuuming for Full-Text Index Optimization").description("This option controls how the full-text index is optimized as a part of database optimization. If set to true, Stardog will use the vacuuming technique to purge text literals which were previously been removed from the data also from the full-text index. The default value is false which means that the index will be rebuilt from scratch. This property is ignored in two cases: if search.optimize=true is explicitly supplied as an argument to 'db optimize' command, or if the index is in a dirty state i.e. it may lack some literals occurring in the data (this normally should not happen unless full-text index has not completed successfully).").build();
    public static final ConfigProperty<String> WORD_BREAK_CHARS = (ConfigProperty)MetaProperty.config((String)"search.index.wordbreak.chars", String.class, (Object)null).database().readable().writable().creatable().category(OptionsCategory.FULL_TEXT_SEARCH).label("Word Break Characters").description("A set of characters which are used to break words. Whitespace is also included").build();
    public static final ConfigProperty<Collection<String>> INDEX_STOPWORDS = (ConfigProperty)MetaProperty.config((String)"search.index.stopwords", String.class, (Collection)ImmutableSet.of()).database().readable().writable().creatable().category(OptionsCategory.FULL_TEXT_SEARCH).label("Stop Words").description("Option to specify the list of the stopwords while indexing. The list of string is to be converted to a CharArraySet data structure of Lucene.").build();
    public static final ConfigProperty<Collection<String>> INDEX_TOKEN_FILTERS = (ConfigProperty)MetaProperty.config((String)"search.index.token.filters", String.class, (Collection)ImmutableList.of()).database().readable().writable().creatable().category(OptionsCategory.FULL_TEXT_SEARCH).label("Token Filters").description("A sequence of token filter classes. Classes must be implementations of org.apache.lucene.analysis.TokenFilter. Filters will be applied in the order listed. Class names must be qualified by package unless existing in the `org.apache.lucene.analysis` package. The `StopFilter`, if specified, will used the value of the `search.index.stopwords` property.").build();
    public static final ConfigProperty<Integer> REINDEX_CACHE_SIZE = (ConfigProperty)MetaProperty.config((String)"search.reindex.cache.size", (Object)16384).database().readable().creatable().writableWhileOnline().category(OptionsCategory.FULL_TEXT_SEARCH).label("Cache Size for Literals while Reindexing").description("Option to specify the cache size of literals that is used for checking if a literal is indexed before.").build();
    public static final ConfigProperty<Integer> SEARCH_INDEX_BATCH_SIZE = (ConfigProperty)MetaProperty.config((String)"search.index.batch.size", (Object)1000).database().readable().creatable().writable().category(OptionsCategory.FULL_TEXT_SEARCH).label("Batch size for search index").description("Specifies the number of Lucene documents that are written to search index in one batch").build();
}

