/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.io.turtle;

import com.complexible.common.base.Options;
import com.google.common.collect.Maps;
import com.stardog.common.io.block.BlockSpec;
import com.stardog.common.io.block.BlockWriter;
import com.stardog.common.io.block.TextBlockWriter;
import com.stardog.stark.BNode;
import com.stardog.stark.Datatype;
import com.stardog.stark.IRI;
import com.stardog.stark.Literal;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import com.stardog.stark.XMLDatatypes;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import com.stardog.stark.io.RDFWriter;
import com.stardog.stark.io.RDFWriterFactory;
import com.stardog.stark.io.WriterOptions;
import com.stardog.stark.io.WritingFailed;
import com.stardog.stark.io.turtle.TurtleUtil;
import com.stardog.stark.vocabs.RDF;
import com.stardog.stark.vocabs.XSD;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;

public class TurtleWriter
implements RDFWriter {
    private static final BlockSpec DEFAULT_BLOCK_SPEC = BlockSpec.INDENTED.copy().indentSize(3).immutable();
    protected final BlockWriter mWriter;
    protected final Options mOptions;
    protected final Map<String, String> mNamespaces = Maps.newHashMap();
    protected boolean mStarted = false;
    protected boolean mStmtClosed = true;
    protected Resource mLastWrittenSubject = null;
    protected IRI mLastWrittenPredicate = null;
    protected BlockSpec mBlockSpec = DEFAULT_BLOCK_SPEC;

    public TurtleWriter(OutputStream theWriter, Options theOptions) {
        this.mWriter = new TextBlockWriter(new OutputStreamWriter(theWriter, this.format().charset()));
        this.mOptions = theOptions;
        if (theOptions.contains(WriterOptions.NAMESPACES)) {
            ((Iterable)this.mOptions.get(WriterOptions.NAMESPACES)).forEach(ns -> this.mNamespaces.put(ns.iri(), ns.prefix()));
        }
    }

    public void comment(@Nonnull String theComment) {
        this.closePreviousStatement();
        if (theComment.indexOf(13) != -1 || theComment.indexOf(10) != -1) {
            StringTokenizer st = new StringTokenizer(theComment, "\r\n");
            while (st.hasMoreTokens()) {
                this.writeCommentLine(st.nextToken());
            }
        } else {
            this.writeCommentLine(theComment);
        }
    }

    protected void writeCommentLine(@Nonnull String theLine) {
        try {
            this.mWriter.write("# " + theLine);
            this.mWriter.println();
        }
        catch (IOException e) {
            throw new WritingFailed("Failed to write comment", (Throwable)e);
        }
    }

    public void start() {
        if (this.mStarted) {
            return;
        }
        this.mStarted = true;
        if (this.mNamespaces.size() > 0) {
            for (Map.Entry<String, String> entry : this.mNamespaces.entrySet()) {
                String name = entry.getKey();
                String prefix = entry.getValue();
                this.writeNamespace(prefix, name);
            }
            try {
                this.mWriter.println();
            }
            catch (IOException e) {
                throw new WritingFailed((Throwable)e);
            }
        }
    }

    public void handle(@Nonnull Statement theStmt) {
        Resource subj = theStmt.subject();
        IRI pred = theStmt.predicate();
        Value obj = theStmt.object();
        try {
            if (subj.equals((Object)this.mLastWrittenSubject)) {
                if (pred.equals((Object)this.mLastWrittenPredicate)) {
                    this.mWriter.write(" , ");
                } else {
                    this.mWriter.write(" ;");
                    this.mWriter.println();
                    this.writePredicate(pred);
                    this.mWriter.write(32);
                    this.mLastWrittenPredicate = pred;
                }
            } else {
                this.closePreviousStatement();
                this.mWriter.println();
                this.writeResource(subj);
                this.mWriter.write(32);
                this.mLastWrittenSubject = subj;
                this.writePredicate(pred);
                this.mWriter.write(32);
                this.mLastWrittenPredicate = pred;
                this.mStmtClosed = false;
                this.mWriter.beginBlock(this.mBlockSpec);
            }
            this.writeValue(obj);
        }
        catch (IOException e) {
            throw new WritingFailed((Throwable)e);
        }
    }

    public void end() {
        if (!this.mStarted) {
            return;
        }
        this.closePreviousStatement();
        try {
            this.mWriter.flush();
        }
        catch (IOException e) {
            throw new WritingFailed((Throwable)e);
        }
        finally {
            this.mStarted = false;
        }
    }

    public void namespace(@Nonnull String thePrefix, @Nonnull String theIRI) {
        if (!this.mNamespaces.containsKey(theIRI)) {
            boolean isLegalPrefix;
            boolean bl = isLegalPrefix = ((String)thePrefix).length() == 0 || TurtleUtil.isPN_PREFIX((String)thePrefix);
            if (!isLegalPrefix || this.mNamespaces.containsValue(thePrefix)) {
                if (((String)thePrefix).length() == 0 || !isLegalPrefix) {
                    thePrefix = "ns";
                }
                int number = 1;
                while (this.mNamespaces.containsValue((String)thePrefix + number)) {
                    ++number;
                }
                thePrefix = (String)thePrefix + number;
            }
            this.mNamespaces.put(theIRI, (String)thePrefix);
            if (this.mStarted) {
                this.closePreviousStatement();
                this.writeNamespace((String)thePrefix, theIRI);
            }
        }
    }

    protected void closePreviousStatement() {
        try {
            if (!this.mStmtClosed) {
                this.mWriter.write(" .");
                this.mWriter.endBlock();
                this.mStmtClosed = true;
                this.mLastWrittenSubject = null;
                this.mLastWrittenPredicate = null;
            }
        }
        catch (IOException e) {
            throw new WritingFailed("Unable to close statement", (Throwable)e);
        }
    }

    protected void writeNamespace(@Nonnull String thePrefix, @Nonnull String theIRI) {
        try {
            this.mWriter.write("@prefix ");
            this.mWriter.write(thePrefix);
            this.mWriter.write(": <");
            this.mWriter.write(TurtleUtil.encodeURIString(theIRI));
            this.mWriter.write("> .");
            this.mWriter.println();
        }
        catch (IOException e) {
            throw new WritingFailed("Failed to write namespace", (Throwable)e);
        }
    }

    protected void writePredicate(@Nonnull IRI predicate) throws IOException {
        if (predicate.equals((Object)RDF.TYPE)) {
            this.mWriter.write("a");
        } else {
            this.writeIRI(predicate);
        }
    }

    protected void writeResource(@Nonnull Resource res) throws IOException {
        if (res instanceof IRI) {
            this.writeIRI((IRI)res);
        } else if (res instanceof Statement) {
            this.writeEmbeddedTriple((Statement)res);
        } else {
            this.writeBNode((BNode)res);
        }
    }

    protected void writeEmbeddedTriple(@Nonnull Statement statement) throws IOException {
        Resource aSubject = statement.subject();
        IRI aPredicate = statement.predicate();
        Value aObject = statement.object();
        this.mWriter.write("<< ");
        this.writeResource(aSubject);
        this.mWriter.write(32);
        this.writePredicate(aPredicate);
        this.mWriter.write(32);
        this.writeValue(aObject);
        this.mWriter.write(" >>");
    }

    protected void writeValue(@Nonnull Value theValue) throws IOException {
        if (theValue instanceof Resource) {
            this.writeResource((Resource)theValue);
        } else {
            this.writeLiteral((Literal)theValue);
        }
    }

    protected void writeIRI(@Nonnull IRI theIRI) throws IOException {
        String uriString = theIRI.toString();
        String prefix = null;
        int splitIdx = TurtleUtil.findURISplitIndex(uriString);
        if (splitIdx > 0) {
            prefix = this.mNamespaces.get(uriString.substring(0, splitIdx));
        }
        if (prefix != null) {
            this.mWriter.write(prefix);
            this.mWriter.write(58);
            this.mWriter.write(uriString.substring(splitIdx));
        } else {
            this.mWriter.write(60);
            this.mWriter.write(TurtleUtil.encodeURIString(uriString));
            this.mWriter.write(62);
        }
    }

    protected void writeBNode(@Nonnull BNode bNode) throws IOException {
        this.mWriter.write("_:");
        String aId = bNode.id();
        if (aId.isEmpty()) {
            this.mWriter.write("genid-hash-" + Integer.toHexString(System.identityHashCode(bNode)));
        } else {
            if (!TurtleUtil.isBLANK_NODE_LABEL_StartChar(aId.charAt(0))) {
                this.mWriter.write("genid-start-" + Integer.toHexString(aId.charAt(0)));
            } else {
                this.mWriter.write(aId.charAt(0));
            }
            for (int i = 1; i < aId.length() - 1; ++i) {
                if (TurtleUtil.isBLANK_NODE_LABEL_Char(aId.charAt(i))) {
                    this.mWriter.write(aId.charAt(i));
                    continue;
                }
                this.mWriter.write(Integer.toHexString(aId.charAt(i)));
            }
            if (aId.length() > 1) {
                if (!TurtleUtil.isBLANK_NODE_LABEL_EndChar(aId.charAt(aId.length() - 1))) {
                    this.mWriter.write(Integer.toHexString(aId.charAt(aId.length() - 1)));
                } else {
                    this.mWriter.write(aId.charAt(aId.length() - 1));
                }
            }
        }
    }

    protected void writeLiteral(@Nonnull Literal theLiteral) throws IOException {
        String aLabel = theLiteral.label();
        IRI aDatatype = theLiteral.datatypeIRI();
        if (this.mOptions.is(WriterOptions.PRETTY_PRINT)) {
            switch (theLiteral.datatype()) {
                case DOUBLE: {
                    if ("INF".equals(aLabel) || "-INF".equals(aLabel) || "NaN".equals(aLabel)) {
                        this.mWriter.write(String.format("\"%s\"^^<%s>", aLabel, XSD.DOUBLE));
                        return;
                    }
                }
                case INTEGER: 
                case DECIMAL: 
                case BOOLEAN: {
                    try {
                        this.mWriter.write(XMLDatatypes.normalize((String)aLabel, (Datatype)theLiteral.datatype()));
                        return;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
        }
        if (aLabel.indexOf(10) != -1 || aLabel.indexOf(13) != -1 || aLabel.indexOf(9) != -1) {
            this.mWriter.write("\"\"\"");
            this.mWriter.write(TurtleUtil.encodeLongString(aLabel));
            this.mWriter.write("\"\"\"");
        } else {
            this.mWriter.write(34);
            this.mWriter.write(TurtleUtil.encodeString(aLabel));
            this.mWriter.write(34);
        }
        if (Literal.isLanguageLiteral((Literal)theLiteral)) {
            this.mWriter.write(64);
            this.mWriter.write((String)theLiteral.lang().get());
        } else if (theLiteral.datatype() != Datatype.STRING || !this.xsdStringToPlainLiteral()) {
            this.mWriter.write("^^");
            this.writeIRI(aDatatype);
        }
    }

    private boolean xsdStringToPlainLiteral() {
        return (Boolean)this.mOptions.get(WriterOptions.XSD_STRING_TO_PLAIN_LITERAL);
    }

    @Nonnull
    public RDFFormat format() {
        return RDFFormats.TURTLE;
    }

    public static final class TurtleWriterFactory
    implements RDFWriterFactory {
        @Nonnull
        public RDFFormat format() {
            return RDFFormats.TURTLE;
        }

        @Nonnull
        public RDFWriter create(@Nonnull OutputStream theStream, @Nonnull Options theOptions) {
            return new TurtleWriter(theStream, theOptions);
        }
    }
}

