/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.io.turtle;

import com.stardog.stark.util.ASCIIUtil;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TurtleUtil {
    private static final Logger logger = LoggerFactory.getLogger(TurtleUtil.class);
    public static final char[] LOCAL_ESCAPED_CHARS = new char[]{'_', '~', '.', '-', '!', '$', '&', '\'', '(', ')', '*', '+', ',', ';', '=', '/', '?', '#', '@', '%'};

    public static int findURISplitIndex(String uri) {
        int idx;
        int uriLength = uri.length();
        for (idx = uriLength - 1; idx >= 0 && uri.charAt(idx) != ':' && TurtleUtil.isNameChar(uri.charAt(idx)); --idx) {
        }
        ++idx;
        while (idx < uriLength && !TurtleUtil.isNameStartChar(uri.charAt(idx))) {
            ++idx;
        }
        if (!TurtleUtil.isNameEndChar(uri.charAt(uriLength - 1))) {
            return -1;
        }
        if (idx > 0 && idx < uriLength) {
            return idx;
        }
        return -1;
    }

    public static boolean isWhitespace(int codePoint) {
        return codePoint == 32 || codePoint == 9 || codePoint == 10 || codePoint == 13;
    }

    public static boolean isPN_CHARS_BASE(int codePoint) {
        return ASCIIUtil.isLetter((int)codePoint) || codePoint >= 192 && codePoint <= 214 || codePoint >= 216 && codePoint <= 246 || codePoint >= 248 && codePoint <= 767 || codePoint >= 880 && codePoint <= 893 || codePoint >= 895 && codePoint <= 8191 || codePoint >= 8204 && codePoint <= 8205 || codePoint >= 8304 && codePoint <= 8591 || codePoint >= 11264 && codePoint <= 12271 || codePoint >= 12289 && codePoint <= 55295 || codePoint >= 63744 && codePoint <= 64975 || codePoint >= 65008 && codePoint <= 65533 || codePoint >= 65536 && codePoint <= 983039;
    }

    public static boolean isPN_CHARS_U(int codePoint) {
        return TurtleUtil.isPN_CHARS_BASE(codePoint) || codePoint == 95;
    }

    public static boolean isPN_CHARS(int codePoint) {
        return TurtleUtil.isPN_CHARS_U(codePoint) || ASCIIUtil.isNumber((int)codePoint) || codePoint == 45 || codePoint == 183 || codePoint >= 768 && codePoint <= 879 || codePoint >= 8255 && codePoint <= 8256;
    }

    public static boolean isPrefixStartChar(int codePoint) {
        return TurtleUtil.isPN_CHARS_BASE(codePoint);
    }

    public static boolean isBLANK_NODE_LABEL_StartChar(int codePoint) {
        return TurtleUtil.isPN_CHARS_U(codePoint) || ASCIIUtil.isNumber((int)codePoint);
    }

    public static boolean isBLANK_NODE_LABEL_Char(int codePoint) {
        return TurtleUtil.isPN_CHARS(codePoint) || codePoint == 46;
    }

    public static boolean isBLANK_NODE_LABEL_EndChar(int codePoint) {
        return TurtleUtil.isPN_CHARS(codePoint);
    }

    public static boolean isNameStartChar(int codePoint) {
        return TurtleUtil.isPN_CHARS_U(codePoint) || codePoint == 58 || ASCIIUtil.isNumber((int)codePoint) || codePoint == 92 || codePoint == 37;
    }

    public static boolean isNameChar(int codePoint) {
        return TurtleUtil.isPN_CHARS(codePoint) || codePoint == 46 || codePoint == 58 || codePoint == 92 || codePoint == 37;
    }

    public static boolean isNameEndChar(int codePoint) {
        return TurtleUtil.isPN_CHARS(codePoint) || codePoint == 58;
    }

    public static boolean isLocalEscapedChar(int codePoint) {
        return Arrays.binarySearch(LOCAL_ESCAPED_CHARS, (char)codePoint) > -1;
    }

    public static boolean isPrefixChar(int codePoint) {
        return TurtleUtil.isPN_CHARS_BASE(codePoint) || TurtleUtil.isPN_CHARS(codePoint) || codePoint == 46;
    }

    public static boolean isLanguageStartChar(int codePoint) {
        return ASCIIUtil.isLetter((int)codePoint);
    }

    public static boolean isLanguageChar(int codePoint) {
        return ASCIIUtil.isLetter((int)codePoint) || ASCIIUtil.isNumber((int)codePoint) || codePoint == 45;
    }

    public static boolean isPN_PREFIX(String prefix) {
        if (prefix.length() == 0) {
            logger.debug("PN_PREFIX was not valid (empty)");
            return false;
        }
        if (!TurtleUtil.isPN_CHARS_BASE(prefix.charAt(0))) {
            logger.debug("PN_PREFIX was not valid (start character invalid) i=0 nextchar={} prefix=", (Object)Character.valueOf(prefix.charAt(0)), (Object)prefix);
            return false;
        }
        int numberOfCodePoints = prefix.codePointCount(0, prefix.length());
        for (int i = 1; i < numberOfCodePoints; ++i) {
            int codePoint = prefix.codePointAt(i);
            if (!TurtleUtil.isPN_CHARS(codePoint) || codePoint == 46 && i < numberOfCodePoints - 1) {
                logger.debug("PN_PREFIX was not valid (intermediate character invalid) i=" + i + " nextchar={} prefix={}", (Object)Character.toChars(codePoint), (Object)prefix);
                return false;
            }
            if (codePoint == 37 && prefix.length() - i < 2) {
                logger.debug("PN_PREFIX was not valid (percent encoding) i=" + i + " nextchar={} prefix={}", (Object)Character.toChars(codePoint), (Object)prefix);
                return false;
            }
            if (!Character.isHighSurrogate((char)codePoint)) continue;
            ++i;
        }
        return true;
    }

    public static boolean isPLX_START(String name) {
        if (name.length() >= 3 && TurtleUtil.isPERCENT(name.substring(0, 3))) {
            return true;
        }
        return name.length() >= 2 && TurtleUtil.isPN_LOCAL_ESC(name.substring(0, 2));
    }

    public static boolean isPERCENT(String name) {
        if (name.length() != 3) {
            return false;
        }
        if (name.charAt(0) != '%') {
            return false;
        }
        return ASCIIUtil.isHex((int)name.charAt(1)) && ASCIIUtil.isHex((int)name.charAt(2));
    }

    public static boolean isPLX_INTERNAL(String name) {
        return name.length() == 3 && TurtleUtil.isPERCENT(name) || name.length() == 2 && TurtleUtil.isPN_LOCAL_ESC(name);
    }

    public static boolean isPN_LOCAL_ESC(String name) {
        return name.length() == 2 && name.startsWith("\\") && Arrays.binarySearch(LOCAL_ESCAPED_CHARS, name.charAt(1)) > -1;
    }

    public static boolean isPN_LOCAL(String name) {
        if (name.length() == 0) {
            return true;
        }
        if (!(TurtleUtil.isPN_CHARS_U(name.charAt(0)) || name.charAt(0) == ':' || ASCIIUtil.isNumber((int)name.charAt(0)) || TurtleUtil.isPLX_START(name))) {
            return false;
        }
        if (!TurtleUtil.isNameStartChar(name.charAt(0))) {
            return false;
        }
        for (int i = 1; i < name.length(); ++i) {
            if (!TurtleUtil.isNameChar(name.charAt(i))) {
                return false;
            }
            if (name.charAt(i) != '%' || name.length() - i >= 3) continue;
            return false;
        }
        return true;
    }

    public static String encodeString(String s) {
        s = StringUtils.replace((String)s, (String)"\\", (String)"\\\\");
        s = StringUtils.replace((String)s, (String)"\t", (String)"\\t");
        s = StringUtils.replace((String)s, (String)"\n", (String)"\\n");
        s = StringUtils.replace((String)s, (String)"\r", (String)"\\r");
        s = StringUtils.replace((String)s, (String)"\"", (String)"\\\"");
        return s;
    }

    public static String encodeLongString(String s) {
        s = StringUtils.replace((String)s, (String)"\\", (String)"\\\\");
        s = StringUtils.replace((String)s, (String)"\"", (String)"\\\"");
        return s;
    }

    public static String encodeURIString(String s) {
        s = StringUtils.replace((String)s, (String)"\\", (String)"\\\\");
        s = StringUtils.replace((String)s, (String)">", (String)"\\>");
        return s;
    }

    public static String decodeString(String s) {
        int backSlashIdx = s.indexOf(92);
        if (backSlashIdx == -1) {
            return s;
        }
        int startIdx = 0;
        int sLength = s.length();
        StringBuilder sb = new StringBuilder(sLength);
        while (backSlashIdx != -1) {
            sb.append(s, startIdx, backSlashIdx);
            if (backSlashIdx + 1 >= sLength) {
                throw new IllegalArgumentException("Unescaped backslash in: " + s);
            }
            char c = s.charAt(backSlashIdx + 1);
            if (c == 't') {
                sb.append('\t');
                startIdx = backSlashIdx + 2;
            } else if (c == 'r') {
                sb.append('\r');
                startIdx = backSlashIdx + 2;
            } else if (c == 'n') {
                sb.append('\n');
                startIdx = backSlashIdx + 2;
            } else if (c == 'b') {
                sb.append('\b');
                startIdx = backSlashIdx + 2;
            } else if (c == 'f') {
                sb.append('\f');
                startIdx = backSlashIdx + 2;
            } else if (c == '\"') {
                sb.append('\"');
                startIdx = backSlashIdx + 2;
            } else if (c == '\'') {
                sb.append('\'');
                startIdx = backSlashIdx + 2;
            } else if (c == '>') {
                sb.append('>');
                startIdx = backSlashIdx + 2;
            } else if (c == '\\') {
                sb.append('\\');
                startIdx = backSlashIdx + 2;
            } else if (c == 'u') {
                if (backSlashIdx + 5 >= sLength) {
                    throw new IllegalArgumentException("Incomplete Unicode escape sequence in: " + s);
                }
                xx = s.substring(backSlashIdx + 2, backSlashIdx + 6);
                try {
                    codePoint = Integer.parseInt(xx, 16);
                    sb.appendCodePoint(codePoint);
                    startIdx = backSlashIdx + 6;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Illegal Unicode escape sequence '\\u" + xx + "' in: " + s);
                }
            } else if (c == 'U') {
                if (backSlashIdx + 9 >= sLength) {
                    throw new IllegalArgumentException("Incomplete Unicode escape sequence in: " + s);
                }
                xx = s.substring(backSlashIdx + 2, backSlashIdx + 10);
                try {
                    codePoint = Integer.parseInt(xx, 16);
                    sb.appendCodePoint(codePoint);
                    startIdx = backSlashIdx + 10;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Illegal Unicode escape sequence '\\U" + xx + "' in: " + s);
                }
            } else {
                throw new IllegalArgumentException("Unescaped backslash in: " + s);
            }
            backSlashIdx = s.indexOf(92, startIdx);
        }
        sb.append(s.substring(startIdx));
        return sb.toString();
    }

    static {
        Arrays.sort(LOCAL_ESCAPED_CHARS);
    }
}

