/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.io.turtle;

import com.complexible.common.base.Options;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.stardog.stark.BNode;
import com.stardog.stark.Datatype;
import com.stardog.stark.IRI;
import com.stardog.stark.Literal;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.io.IOParserContext;
import com.stardog.stark.io.InvalidRDF;
import com.stardog.stark.io.ParserContext;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import com.stardog.stark.io.RDFHandler;
import com.stardog.stark.io.RDFHandlerException;
import com.stardog.stark.io.RDFParser;
import com.stardog.stark.io.turtle.TurtleParserContext;
import com.stardog.stark.io.turtle.TurtleUtil;
import com.stardog.stark.util.ASCIIUtil;
import com.stardog.stark.util.ParsedURI;
import com.stardog.stark.vocabs.RDF;
import com.stardog.stark.vocabs.XSD;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.apache.commons.io.input.BOMInputStream;

public class TurtleParser
implements RDFParser {
    private static final String BASE = "base";
    private static final String PREFIX = "prefix";

    @Nonnull
    public RDFFormat format() {
        return RDFFormats.TURTLE;
    }

    public void parse(@Nonnull InputStream theStream, @Nonnull RDFHandler theHandler, @Nonnull Options theOptions) throws IOException {
        TurtleParserContext aContext = new TurtleParserContext(new InputStreamReader((InputStream)new BOMInputStream(theStream, false), this.format().charset()), theHandler, theOptions);
        theHandler.start();
        int c = this.skipWSC(aContext);
        while (c != -1) {
            this.parseStatement(aContext);
            c = this.skipWSC(aContext);
        }
        theHandler.end();
    }

    private static void appendCodepoint(StringBuilder dst, int codePoint) {
        if (Character.isBmpCodePoint(codePoint)) {
            dst.append((char)codePoint);
        } else if (Character.isValidCodePoint(codePoint)) {
            dst.append(Character.highSurrogate(codePoint));
            dst.append(Character.lowSurrogate(codePoint));
        } else {
            throw new IllegalArgumentException("Invalid codepoint " + codePoint);
        }
    }

    protected void parseStatement(TurtleParserContext theContext) throws IOException, InvalidRDF, RDFHandlerException {
        StringBuilder aBuffer = new StringBuilder(8);
        do {
            int codePoint;
            if ((codePoint = theContext.readCodePoint()) == -1 || TurtleUtil.isWhitespace(codePoint)) {
                theContext.unread(codePoint);
                break;
            }
            TurtleParser.appendCodepoint(aBuffer, codePoint);
        } while (aBuffer.length() < 8);
        String aDirective = aBuffer.toString();
        if (this.parseDirective(theContext, aDirective)) {
            this.skipWSC(theContext);
        } else {
            theContext.unread(aDirective);
            this.parseTriples(theContext);
            this.skipWSC(theContext);
            theContext.verifyCharacterOrFail('.');
        }
    }

    protected void parseTriples(@Nonnull TurtleParserContext theContext) throws IOException, InvalidRDF, RDFHandlerException {
        int c = theContext.readCodePoint();
        int c2 = theContext.peekCodePoint();
        if (c == 91) {
            this.skipWSC(theContext);
            c = theContext.peekCodePoint();
            if (c == 93) {
                c = theContext.readCodePoint();
                theContext.mSubject = theContext.createBNode();
                this.skipWSC(theContext);
                this.parsePredicateObjectList(theContext);
            } else {
                theContext.unread(91);
                theContext.mSubject = this.parseImplicitBlank(theContext);
            }
            this.skipWSC(theContext);
            c = theContext.peekCodePoint();
            if (c != 46) {
                this.parsePredicateObjectList(theContext);
            }
        } else if (c == 60 && c2 == 60) {
            theContext.unread(c);
            theContext.mSubject = this.parseEmbeddedTriple(theContext);
            this.skipWSC(theContext);
            this.parsePredicateObjectList(theContext);
        } else {
            theContext.unread(c);
            this.parseSubject(theContext);
            this.skipWSC(theContext);
            this.parsePredicateObjectList(theContext);
        }
        theContext.resetStatement();
    }

    protected Statement parseEmbeddedTriple(IOParserContext theContext) throws IOException, InvalidRDF, RDFHandlerException {
        theContext.verifyCharacterOrFail('<');
        theContext.verifyCharacterOrFail('<');
        this.skipWSC(theContext);
        theContext.mSubject = this.parseSubjectResource(theContext);
        this.skipWSC(theContext);
        theContext.mPredicate = this.parsePredicate(theContext);
        this.skipWSC(theContext);
        theContext.mObject = this.parseValue(theContext);
        this.skipWSC(theContext);
        theContext.verifyCharacterOrFail('>');
        theContext.verifyCharacterOrFail('>');
        return theContext.currentStatement();
    }

    protected void parsePredicateObjectList(@Nonnull TurtleParserContext theContext) throws IOException, InvalidRDF, RDFHandlerException {
        theContext.mPredicate = this.parsePredicateWithEdgeProperties(theContext);
        this.parseObjectList(theContext);
        while (this.skipWSC(theContext) == 59) {
            theContext.readCodePoint();
            int c = this.skipWSC(theContext);
            if (c == 46 || c == 93 || c == 125) break;
            if (c == 59) continue;
            theContext.mPredicate = this.parsePredicateWithEdgeProperties(theContext);
            this.parseObjectList(theContext);
        }
    }

    protected IRI parsePredicateWithEdgeProperties(@Nonnull TurtleParserContext theContext) throws IOException, InvalidRDF {
        IRI p = this.parsePredicate(theContext);
        int next = this.skipWSC(theContext);
        if (next == 123) {
            if (theContext.parsingEdgeProperties) {
                theContext.error("Nested edge properties are not allowed");
            }
            theContext.parsingEdgeProperties = true;
            theContext.verifyCharacterOrFail('{');
            this.skipWSC(theContext);
            this.parsePredicateObjectList(theContext);
            theContext.verifyCharacterOrFail('}');
            this.skipWSC(theContext);
            theContext.parsingEdgeProperties = false;
        }
        return p;
    }

    protected IRI parsePredicate(@Nonnull IOParserContext theContext) throws IOException, InvalidRDF {
        int c1 = theContext.readCodePoint();
        if (c1 == 97) {
            int c2 = theContext.readCodePoint();
            if (TurtleUtil.isWhitespace(c2)) {
                return RDF.TYPE;
            }
            theContext.unread(c2);
        }
        theContext.unread(c1);
        Value predicate = this.parseValue(theContext);
        if (predicate instanceof IRI) {
            return (IRI)predicate;
        }
        throw theContext.error("Illegal predicate value: " + String.valueOf(predicate));
    }

    protected void parseObjectList(@Nonnull TurtleParserContext theContext) throws IOException, InvalidRDF, RDFHandlerException {
        this.parseObject(theContext);
        while (this.skipWSC(theContext) == 44) {
            if (!theContext.edgeProperties.isEmpty()) {
                throw theContext.error("Object lists cannot be used with edge properties on predicate " + String.valueOf(theContext.mPredicate));
            }
            theContext.readCodePoint();
            this.skipWSC(theContext);
            this.parseObject(theContext);
        }
        if (!theContext.parsingEdgeProperties && !theContext.edgeProperties.isEmpty()) {
            Resource subject = theContext.mSubject;
            theContext.mSubject = theContext.currentStatement();
            for (Statement edgeProperty : theContext.edgeProperties) {
                theContext.mPredicate = edgeProperty.predicate();
                theContext.mObject = edgeProperty.object();
                theContext.reportStatement();
            }
            theContext.edgeProperties.clear();
            theContext.mSubject = subject;
        }
    }

    protected void parseSubject(@Nonnull TurtleParserContext theContext) throws IOException, InvalidRDF, RDFHandlerException {
        int c = theContext.peekCodePoint();
        theContext.mSubject = c == 40 ? this.parseCollection(theContext) : (c == 91 ? this.parseImplicitBlank(theContext) : this.parseSubjectResource(theContext));
    }

    protected Resource parseSubjectResource(@Nonnull IOParserContext theContext) throws IOException {
        Value value = this.parseValue(theContext);
        if (value instanceof Resource) {
            return (Resource)value;
        }
        throw theContext.error("Illegal subject value: " + String.valueOf(value));
    }

    protected void parseObject(@Nonnull TurtleParserContext theContext) throws IOException, InvalidRDF, RDFHandlerException {
        int c = theContext.peekCodePoint();
        theContext.mObject = c == 40 ? this.parseCollection(theContext) : (c == 91 ? this.parseImplicitBlank(theContext) : this.parseValue(theContext));
        if (theContext.parsingEdgeProperties) {
            theContext.edgeProperties.add(theContext.currentStatement());
        } else if (theContext.edgeProperties.isEmpty()) {
            theContext.reportStatement();
        }
    }

    protected Resource parseCollection(@Nonnull TurtleParserContext theContext) throws IOException, InvalidRDF, RDFHandlerException {
        theContext.verifyCharacterOrFail('(');
        int c = this.skipWSC(theContext);
        if (c == 41) {
            theContext.readCodePoint();
            return RDF.NIL;
        }
        BNode listRoot = theContext.createBNode();
        Resource oldSubject = theContext.mSubject;
        IRI oldPredicate = theContext.mPredicate;
        theContext.mSubject = listRoot;
        theContext.mPredicate = RDF.FIRST;
        this.parseObject(theContext);
        BNode bNode = listRoot;
        while (this.skipWSC(theContext) != 41) {
            BNode newNode = theContext.createBNode();
            theContext.handle(Values.statement((Resource)bNode, (IRI)RDF.REST, (Value)newNode, (Resource)(theContext.mContext == null ? Values.DEFAULT_GRAPH : theContext.mContext)));
            bNode = newNode;
            theContext.mSubject = bNode;
            this.parseObject(theContext);
        }
        theContext.readCodePoint();
        theContext.handle(Values.statement((Resource)bNode, (IRI)RDF.REST, (Value)RDF.NIL, (Resource)(theContext.mContext == null ? Values.DEFAULT_GRAPH : theContext.mContext)));
        theContext.mSubject = oldSubject;
        theContext.mPredicate = oldPredicate;
        return listRoot;
    }

    protected Resource parseImplicitBlank(@Nonnull TurtleParserContext theContext) throws IOException, InvalidRDF, RDFHandlerException {
        theContext.verifyCharacterOrFail('[');
        BNode bNode = theContext.createBNode();
        int c = theContext.readCodePoint();
        if (c != 93) {
            Object oldEdgeProperties;
            theContext.unread(c);
            Resource oldSubject = theContext.mSubject;
            IRI oldPredicate = theContext.mPredicate;
            if (theContext.edgeProperties.isEmpty()) {
                oldEdgeProperties = ImmutableList.of();
            } else {
                oldEdgeProperties = Lists.newArrayList(theContext.edgeProperties);
                theContext.edgeProperties.clear();
            }
            theContext.mSubject = bNode;
            this.skipWSC(theContext);
            this.parsePredicateObjectList(theContext);
            this.skipWSC(theContext);
            theContext.verifyCharacterOrFail(']');
            theContext.mSubject = oldSubject;
            theContext.mPredicate = oldPredicate;
            theContext.edgeProperties.clear();
            theContext.edgeProperties.addAll((Collection<Statement>)oldEdgeProperties);
        }
        return bNode;
    }

    protected Value parseValue(@Nonnull IOParserContext theContext) throws IOException, InvalidRDF {
        int c = theContext.peekCodePoint();
        if (c == 60) {
            return this.parseURI(theContext);
        }
        if (c == 58 || TurtleUtil.isPrefixStartChar(c)) {
            return this.parseQNameOrBoolean(theContext);
        }
        if (c == 95) {
            return this.parseNodeID(theContext);
        }
        if (c == 34 || c == 39) {
            return this.parseQuotedLiteral(theContext);
        }
        if (ASCIIUtil.isNumber((int)c) || c == 46 || c == 43 || c == 45) {
            return this.parseNumber(theContext);
        }
        if (c == -1) {
            throw theContext.error("Unexpected end of file");
        }
        throw theContext.error("Expected an RDF value here, found '" + (char)c + "'");
    }

    protected IRI parseURI(@Nonnull IOParserContext theContext) throws IOException, InvalidRDF {
        int c;
        StringBuilder uriBuf = theContext.resetSB();
        theContext.verifyCharacterOrFail('<');
        while ((c = theContext.readCodePoint()) != 62) {
            if (c == -1) {
                throw theContext.error("Unexpected end of file");
            }
            if (c == 32) {
                throw theContext.error("IRI included an unencoded space: '" + c + "'");
            }
            uriBuf.appendCodePoint(c);
            if (c != 92) continue;
            c = theContext.readCodePoint();
            if (c == -1) {
                throw theContext.error("Unexpected end of file");
            }
            if (c != 117 && c != 85) {
                throw theContext.error("IRI includes string escapes: '\\" + c + "'");
            }
            uriBuf.appendCodePoint(c);
        }
        String uri = uriBuf.toString();
        try {
            uri = TurtleUtil.decodeString(uri);
        }
        catch (IllegalArgumentException e) {
            theContext.error(e.getMessage(), ParserContext.ParseError.Invalid_IRI_Escapes);
        }
        return theContext.resolveURI(uri);
    }

    protected Value parseQNameOrBoolean(@Nonnull IOParserContext theContext) throws IOException, InvalidRDF {
        int previousChar;
        int c = theContext.readCodePoint();
        if (c == -1) {
            throw theContext.error("Unexpected end of file");
        }
        if (c != 58 && !TurtleUtil.isPrefixStartChar(c)) {
            theContext.error("Expected a ':' or a letter, found '" + (char)c + "'", ParserContext.ParseError.InvalidIRI);
        }
        String namespace = null;
        if (c == 58) {
            namespace = theContext.namespace("");
        } else {
            StringBuilder prefix = theContext.resetSB();
            prefix.appendCodePoint(c);
            previousChar = c;
            c = theContext.readCodePoint();
            while (TurtleUtil.isPrefixChar(c)) {
                prefix.appendCodePoint(c);
                previousChar = c;
                c = theContext.readCodePoint();
            }
            if (c != 58) {
                String value = prefix.toString();
                if (value.equals("true") || value.equals("false")) {
                    theContext.unread(c);
                    return theContext.createLiteral(value, null, XSD.BOOLEAN);
                }
            } else if (previousChar == 46) {
                throw theContext.error("prefix can not end with with '.'");
            }
            theContext.verifyCharacterOrFail(c, ":");
            namespace = theContext.namespace(prefix.toString());
        }
        StringBuilder localName = theContext.resetSB();
        c = theContext.readCodePoint();
        if (TurtleUtil.isNameStartChar(c)) {
            if (c == 92) {
                localName.append(this.readLocalEscapedChar(theContext));
            } else {
                localName.appendCodePoint(c);
            }
            previousChar = c;
            c = theContext.readCodePoint();
            while (TurtleUtil.isNameChar(c)) {
                if (c == 92) {
                    localName.append(this.readLocalEscapedChar(theContext));
                } else {
                    localName.appendCodePoint(c);
                }
                previousChar = c;
                c = theContext.readCodePoint();
            }
            theContext.unread(c);
            if (previousChar == 46) {
                theContext.unread(previousChar);
                localName.deleteCharAt(localName.length() - 1);
            }
        } else {
            theContext.unread(c);
        }
        String localNameString = localName.toString();
        for (int i = 0; i < localNameString.length(); ++i) {
            if (localNameString.charAt(i) != '%' || i <= localNameString.length() - 3 && ASCIIUtil.isHex((int)localNameString.charAt(i + 1)) && ASCIIUtil.isHex((int)localNameString.charAt(i + 2))) continue;
            throw theContext.error("Found incomplete percent-encoded sequence: " + localNameString);
        }
        return Values.iri((String)(namespace + localNameString));
    }

    private char readLocalEscapedChar(@Nonnull IOParserContext theContext) throws InvalidRDF, IOException {
        int c = theContext.readCodePoint();
        if (TurtleUtil.isLocalEscapedChar(c)) {
            return (char)c;
        }
        throw theContext.error("found '" + (char)c + "', expected one of: " + Arrays.toString(TurtleUtil.LOCAL_ESCAPED_CHARS));
    }

    protected BNode parseNodeID(@Nonnull IOParserContext theContext) throws IOException, InvalidRDF {
        theContext.verifyCharacterOrFail('_');
        theContext.verifyCharacterOrFail(':');
        int c = theContext.readCodePoint();
        if (c == -1) {
            throw theContext.error("Unexpected end of file");
        }
        if (!TurtleUtil.isBLANK_NODE_LABEL_StartChar(c)) {
            theContext.error("Expected a letter, found '" + (char)c + "'", ParserContext.ParseError.Invalid_BNode_Start);
        }
        StringBuilder name = theContext.resetSB();
        name.appendCodePoint(c);
        c = theContext.readCodePoint();
        if (!TurtleUtil.isBLANK_NODE_LABEL_Char(c)) {
            theContext.unread(c);
        }
        while (TurtleUtil.isBLANK_NODE_LABEL_Char(c)) {
            int previous = c;
            c = theContext.readCodePoint();
            if (previous == 46 && (c == -1 || TurtleUtil.isWhitespace(c) || c == 60 || c == 95)) {
                theContext.unread(c);
                theContext.unread(previous);
                break;
            }
            name.append((char)previous);
            if (TurtleUtil.isBLANK_NODE_LABEL_Char(c)) continue;
            theContext.unread(c);
        }
        return theContext.createBNode(name.toString());
    }

    protected Literal parseQuotedLiteral(@Nonnull IOParserContext theContext) throws IOException, InvalidRDF {
        String label = this.parseQuotedString(theContext);
        int c = theContext.peekCodePoint();
        if (c == 64) {
            theContext.readCodePoint();
            StringBuilder lang = theContext.resetSB();
            c = theContext.readCodePoint();
            if (c == -1) {
                throw theContext.error("Unexpected end of file");
            }
            lang.appendCodePoint(c);
            c = theContext.readCodePoint();
            while (!TurtleUtil.isWhitespace(c) && c != 46 && c != 59 && c != 44 && c != 41 && c != 93 && c != -1) {
                lang.appendCodePoint(c);
                c = theContext.readCodePoint();
            }
            theContext.unread(c);
            return theContext.createLiteral(label, lang.toString(), null);
        }
        if (c == 94) {
            theContext.readCodePoint();
            theContext.verifyCharacterOrFail('^');
            this.skipWSC(theContext);
            Value datatype = this.parseValue(theContext);
            if (datatype instanceof IRI) {
                return theContext.createLiteral(label, null, (IRI)datatype);
            }
            throw theContext.error("Illegal datatype value: " + String.valueOf(datatype));
        }
        return Values.literal((String)label);
    }

    protected String parseQuotedString(@Nonnull IOParserContext theContext) throws IOException, InvalidRDF {
        String aResult = null;
        int c1 = theContext.readCodePoint();
        theContext.verifyCharacterOrFail(c1, "\"'");
        int c2 = theContext.readCodePoint();
        int c3 = theContext.readCodePoint();
        if (c1 == 34 && c2 == 34 && c3 == 34 || c1 == 39 && c2 == 39 && c3 == 39) {
            aResult = this.parseLongString(theContext, c2);
        } else {
            theContext.unread(c3);
            theContext.unread(c2);
            aResult = this.parseString(theContext, c1);
        }
        try {
            aResult = TurtleUtil.decodeString(aResult);
        }
        catch (IllegalArgumentException e) {
            theContext.error(e.getMessage(), ParserContext.ParseError.INVALID_STRING_ENCODING);
        }
        return aResult;
    }

    protected String parseString(@Nonnull IOParserContext theContext, int closingCharacter) throws IOException, InvalidRDF {
        int c;
        StringBuilder sb = theContext.resetSB();
        while ((c = theContext.readCodePoint()) != closingCharacter) {
            if (c == -1) {
                throw theContext.error("Unexpected end of file");
            }
            sb.appendCodePoint(c);
            if (c != 92) continue;
            c = theContext.readCodePoint();
            if (c == -1) {
                throw theContext.error("Unexpected end of file");
            }
            sb.appendCodePoint(c);
        }
        return sb.toString();
    }

    protected String parseLongString(@Nonnull IOParserContext theContext, int closingCharacter) throws IOException, InvalidRDF {
        StringBuilder sb = theContext.resetSB();
        int doubleQuoteCount = 0;
        while (doubleQuoteCount < 3) {
            int c = theContext.readCodePoint();
            if (c == 10) {
                ++theContext.mLineNumber;
            }
            if (c == -1) {
                throw theContext.error("Unexpected end of file");
            }
            doubleQuoteCount = c == closingCharacter ? ++doubleQuoteCount : 0;
            sb.appendCodePoint(c);
            if (c != 92) continue;
            c = theContext.readCodePoint();
            if (c == -1) {
                throw theContext.error("Unexpected end of file");
            }
            sb.appendCodePoint(c);
        }
        return sb.substring(0, sb.length() - 3);
    }

    protected Literal parseNumber(@Nonnull IOParserContext theContext) throws IOException, InvalidRDF {
        StringBuilder value = theContext.resetSB();
        Datatype datatype = Datatype.INTEGER;
        int c = theContext.readCodePoint();
        if (c == 43 || c == 45) {
            value.appendCodePoint(c);
            c = theContext.readCodePoint();
        }
        while (ASCIIUtil.isNumber((int)c)) {
            value.appendCodePoint(c);
            c = theContext.readCodePoint();
        }
        if (c == 46 || c == 101 || c == 69) {
            if (c == 46) {
                if (!TurtleUtil.isWhitespace(theContext.peekCodePoint())) {
                    value.appendCodePoint(c);
                    c = theContext.readCodePoint();
                    while (ASCIIUtil.isNumber((int)c)) {
                        value.appendCodePoint(c);
                        c = theContext.readCodePoint();
                    }
                    if (value.length() == 1) {
                        throw theContext.error("Object for statement missing");
                    }
                    datatype = Datatype.DECIMAL;
                }
            } else if (value.length() == 0) {
                throw theContext.error("Object for statement missing");
            }
            if (c == 101 || c == 69) {
                datatype = Datatype.DOUBLE;
                value.appendCodePoint(c);
                c = theContext.readCodePoint();
                if (c == 43 || c == 45) {
                    value.appendCodePoint(c);
                    c = theContext.readCodePoint();
                }
                if (!ASCIIUtil.isNumber((int)c)) {
                    theContext.error("Exponent value missing", ParserContext.ParseError.Invalid_Number);
                }
                value.appendCodePoint(c);
                c = theContext.readCodePoint();
                while (ASCIIUtil.isNumber((int)c)) {
                    value.appendCodePoint(c);
                    c = theContext.readCodePoint();
                }
            }
        }
        if (value.length() == 0) {
            throw theContext.error("Number expected but not found.");
        }
        theContext.unread(c);
        return Values.literal((String)value.toString(), (Datatype)datatype);
    }

    protected boolean parseDirective(TurtleParserContext theContext, String directive) throws IOException {
        int matchOffset;
        boolean turtleDirective = directive.startsWith("@");
        boolean ignoreCase = !turtleDirective || theContext.caseInsensitiveDirectives;
        int n = matchOffset = turtleDirective ? 1 : 0;
        if (directive.regionMatches(ignoreCase, matchOffset, PREFIX, 0, PREFIX.length())) {
            if (directive.length() > PREFIX.length() + matchOffset) {
                theContext.unread(directive.substring(PREFIX.length() + matchOffset));
            }
            this.parsePrefixID(theContext);
            if (turtleDirective) {
                this.skipWSC(theContext);
                theContext.verifyCharacterOrFail('.');
            }
            return true;
        }
        if (directive.regionMatches(ignoreCase, matchOffset, BASE, 0, BASE.length())) {
            if (!turtleDirective && directive.length() >= 5 && directive.charAt(4) == ':') {
                return false;
            }
            if (directive.length() > BASE.length() + matchOffset) {
                theContext.unread(directive.substring(BASE.length() + matchOffset));
            }
            this.parseBase(theContext);
            if (turtleDirective) {
                this.skipWSC(theContext);
                theContext.verifyCharacterOrFail('.');
            }
            return true;
        }
        if (turtleDirective) {
            throw theContext.error("Unknown directive \"" + directive + "\"");
        }
        return false;
    }

    protected void parsePrefixID(@Nonnull IOParserContext theContext) throws IOException, InvalidRDF, RDFHandlerException {
        this.skipWSC(theContext);
        StringBuilder prefixID = theContext.resetSB();
        while (true) {
            int c;
            if ((c = theContext.readCodePoint()) == 58) {
                theContext.unread(c);
                break;
            }
            if (TurtleUtil.isWhitespace(c)) break;
            if (c == -1) {
                throw theContext.error("Unexpected end of file");
            }
            prefixID.appendCodePoint(c);
        }
        String prefixStr = prefixID.toString();
        this.skipWSC(theContext);
        theContext.verifyCharacterOrFail(':');
        this.skipWSC(theContext);
        IRI namespace = this.parseURI(theContext);
        String namespaceStr = namespace.toString();
        theContext.namespace(prefixStr, namespaceStr);
    }

    protected void parseBase(@Nonnull IOParserContext theContext) throws IOException, InvalidRDF, RDFHandlerException {
        this.skipWSC(theContext);
        IRI baseURI = this.parseURI(theContext);
        theContext.mBaseIRI = new ParsedURI(baseURI.toString());
    }

    protected int skipWSC(IOParserContext theContext) throws RDFHandlerException, IOException {
        int c = theContext.readCodePoint();
        while (TurtleUtil.isWhitespace(c) || c == 35) {
            if (c == 35) {
                this.processComment(theContext);
            } else if (c == 10) {
                ++theContext.mLineNumber;
            }
            c = theContext.readCodePoint();
        }
        theContext.unread(c);
        return c;
    }

    protected void processComment(IOParserContext theContext) throws RDFHandlerException, IOException {
        int c = theContext.readCodePoint();
        while (c != -1 && c != 13 && c != 10) {
            c = theContext.readCodePoint();
        }
        if (c == 13 && (c = theContext.readCodePoint()) != 10) {
            theContext.unread(c);
        }
        ++theContext.mLineNumber;
    }
}

