/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.io.turtle;

import com.complexible.common.base.Options;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.stardog.common.io.block.BlockSpec;
import com.stardog.common.io.block.Bracket;
import com.stardog.stark.BNode;
import com.stardog.stark.IRI;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Statements;
import com.stardog.stark.Value;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import com.stardog.stark.io.RDFHandlerException;
import com.stardog.stark.io.RDFWriter;
import com.stardog.stark.io.RDFWriterFactory;
import com.stardog.stark.io.WriterOptions;
import com.stardog.stark.io.WritingFailed;
import com.stardog.stark.io.turtle.TurtleWriter;
import com.stardog.stark.vocabs.RDF;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.ToIntFunction;
import javax.annotation.Nonnull;

public class PrettyTurtleWriter
extends TurtleWriter
implements RDFWriter {
    private Set<Statement> mGraph = new LinkedHashSet<Statement>();
    private final Set<Value> mWrittenBNodes = new HashSet<Value>();
    private final int mLimit;
    private boolean tooManyTriples;

    public PrettyTurtleWriter(OutputStream theWriter, Options theOptions) {
        super(theWriter, theOptions);
        this.mLimit = (Integer)theOptions.get(WriterOptions.BUFFER_SIZE);
    }

    @Override
    public void start() {
        super.start();
        this.mGraph.clear();
        this.mWrittenBNodes.clear();
    }

    @Override
    public void handle(@Nonnull Statement theStmt) {
        if (this.tooManyTriples) {
            super.handle(theStmt);
        } else {
            this.mGraph.add(theStmt);
            boolean bl = this.tooManyTriples = this.mGraph.size() > this.mLimit;
            if (this.tooManyTriples) {
                this.mGraph.forEach(x$0 -> super.handle((Statement)x$0));
                this.mGraph.clear();
            }
        }
    }

    @Override
    public void end() {
        this.writeModel(this.mGraph);
        super.end();
        this.mGraph.clear();
        this.mWrittenBNodes.clear();
    }

    @Override
    public void comment(@Nonnull String theComment) {
    }

    @Override
    public void namespace(@Nonnull String thePrefix, @Nonnull String theIRI) {
        super.namespace(thePrefix, theIRI);
    }

    @Override
    @Nonnull
    public RDFFormat format() {
        return RDFFormats.PRETTY_TURTLE;
    }

    private void writeModel(@Nonnull Set<Statement> m) throws RDFHandlerException {
        try {
            this.mGraph = m;
            this.mWrittenBNodes.clear();
            this.mWriter.println();
            this.mGraph.stream().map(Statement::subject).distinct().forEach(subj -> {
                try {
                    if (subj instanceof IRI || subj instanceof Statement) {
                        this.writeSubject((Resource)subj, false);
                    } else if (this.canInline((Value)subj, Position.SUBJECT)) {
                        this.writeSubject((Resource)subj, true);
                    }
                }
                catch (IOException e) {
                    throw new WritingFailed((Throwable)e);
                }
            });
            this.mGraph.stream().map(Statement::subject).distinct().forEach(subj -> {
                if (subj instanceof BNode && this.mWrittenBNodes.add((Value)subj)) {
                    try {
                        this.writeSubject((Resource)subj, false);
                    }
                    catch (IOException e) {
                        throw new WritingFailed((Throwable)e);
                    }
                }
            });
            this.mWriter.flush();
            this.mWrittenBNodes.clear();
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    private void writeSubject(@Nonnull Resource theSubj, boolean theInlineBNode) throws IOException {
        if (theInlineBNode) {
            this.writeInlinedBnode(theSubj);
        } else {
            this.writeValue((Value)theSubj);
            this.mWriter.write(" ");
            this.writeSubjectStatements(theSubj, true);
        }
        this.mWriter.write(" .");
        this.mWriter.println();
        this.mWriter.println();
    }

    private void writeInlinedBnode(@Nonnull Resource theSubj) throws IOException {
        if (this.writeList(theSubj)) {
            return;
        }
        this.mWrittenBNodes.add((Value)theSubj);
        if (!this.mGraph.stream().anyMatch(Statements.matches((Resource)theSubj, null, null, (Resource[])new Resource[0]))) {
            this.mWriter.write("[]");
            return;
        }
        this.mWriter.beginBlock(BlockSpec.INDENTED.copy().marker(Bracket.SQUARE).indentSize(4).newLineAfterBegin(true).newLineBeforeEnd(true).immutable());
        this.writeSubjectStatements(theSubj, false);
        this.mWriter.endBlock();
    }

    private int compareStatements(Statement s1, Statement s2) {
        return s1.predicate().equals((Object)RDF.TYPE) ? (s2.predicate().equals((Object)RDF.TYPE) ? this.compareObjects(s1, s2) : -1) : (s2.predicate().equals((Object)RDF.TYPE) ? 1 : this.comparePredicatesThenObjects(s1, s2));
    }

    private int comparePredicatesThenObjects(Statement s1, Statement s2) {
        int cmp = s1.predicate().toString().compareTo(s2.predicate().toString());
        return cmp != 0 ? cmp : this.compareObjects(s1, s2);
    }

    private int compareObjects(Statement s1, Statement s2) {
        return s1.object().toString().compareTo(s2.object().toString());
    }

    private void writeSubjectStatements(@Nonnull Resource theSubj, boolean theIndentAfterFirstLine) throws IOException {
        boolean aIndented = false;
        this.mLastWrittenPredicate = null;
        Iterator iter = this.mGraph.stream().filter(Statements.matches((Resource)theSubj, null, null, (Resource[])new Resource[0])).sorted(this::compareStatements).iterator();
        while (iter.hasNext()) {
            Statement stmt = (Statement)iter.next();
            IRI pred = stmt.predicate();
            if (this.mLastWrittenPredicate != null && this.mLastWrittenPredicate.equals((Object)pred)) {
                this.mWriter.write(" , ");
            } else {
                if (this.mLastWrittenPredicate != null) {
                    this.mWriter.write(" ;");
                    this.mWriter.println();
                    if (!aIndented && theIndentAfterFirstLine) {
                        this.mWriter.beginBlock(BlockSpec.INDENTED.copy().indentSize(4).immutable());
                        aIndented = true;
                    }
                }
                if (pred.equals((Object)RDF.TYPE)) {
                    this.mWriter.write("a");
                } else {
                    this.writeValue((Value)pred);
                }
                this.mWriter.write(" ");
            }
            this.writeObject(stmt.object());
            this.mLastWrittenPredicate = pred;
        }
        if (aIndented) {
            this.mWriter.endBlock();
        }
    }

    private void writeObject(@Nonnull Value theObj) throws IOException {
        if (this.canInline(theObj, Position.OBJECT)) {
            this.writeInlinedBnode((Resource)((BNode)theObj));
        } else {
            this.writeValue(theObj);
        }
    }

    private boolean canInline(@Nonnull Value theValue, @Nonnull Position thePosition) {
        if (!(theValue instanceof BNode)) {
            return false;
        }
        ToIntFunction<Statement> counter = stmt -> stmt.subject() instanceof Statement && this.statementContains((Statement)stmt.subject(), theValue) ? Integer.MAX_VALUE : (stmt.object().equals((Object)theValue) ? 1 : 0);
        int count = this.mGraph.stream().mapToInt(counter).sum();
        return thePosition == Position.SUBJECT ? count == 0 : count == 1 && !this.isCyclic((BNode)theValue);
    }

    private boolean statementContains(@Nonnull Statement theStmt, @Nonnull Value theValue) {
        return theStmt.subject().equals((Object)theValue) || theStmt.object().equals((Object)theValue);
    }

    private boolean isCyclic(@Nonnull BNode theBNode) {
        BNode bnode = theBNode;
        ArrayDeque queue = Queues.newArrayDeque();
        HashSet visited = Sets.newHashSet();
        queue.add(bnode);
        while (!queue.isEmpty()) {
            bnode = (BNode)queue.remove();
            if (!visited.add(bnode)) {
                return true;
            }
            this.mGraph.stream().filter(Statements.matches((Resource)bnode, null, null, (Resource[])new Resource[0])).map(Statement::object).filter(v -> v instanceof BNode).forEach(queue::add);
        }
        return false;
    }

    private boolean writeList(@Nonnull Resource theSubj) throws IOException {
        List<Value> list = this.getList(theSubj);
        if (list == null) {
            return false;
        }
        this.mWriter.write("( ");
        for (Value value : list) {
            this.writeObject(value);
            this.mWriter.write(" ");
        }
        this.mWriter.write(")");
        return true;
    }

    private List<Value> getList(@Nonnull Resource theSubj) {
        ArrayList list = Lists.newArrayList();
        HashSet visited = Sets.newHashSet((Object[])new Value[]{RDF.NIL});
        Resource subj = theSubj;
        while (visited.add(subj)) {
            if ((subj = this.addToList(subj, list)) != null) continue;
            return null;
        }
        this.mWrittenBNodes.addAll(visited);
        return list;
    }

    private Resource addToList(@Nonnull Resource theSubj, @Nonnull List<Value> theList) {
        Value first = null;
        Resource rest = null;
        Iterator iter = this.mGraph.stream().filter(Statements.matches((Resource)theSubj, null, null, (Resource[])new Resource[0])).iterator();
        while (iter.hasNext()) {
            Statement stmt = (Statement)iter.next();
            IRI pred = stmt.predicate();
            Value obj = stmt.object();
            if (pred.equals((Object)RDF.FIRST) && first == null) {
                first = obj;
                continue;
            }
            if (pred.equals((Object)RDF.REST) && rest == null && (obj.equals((Object)RDF.NIL) || this.canInline(obj, Position.OBJECT))) {
                rest = (Resource)stmt.object();
                continue;
            }
            return null;
        }
        if (first == null || rest == null) {
            return null;
        }
        theList.add(first);
        return rest;
    }

    private static enum Position {
        SUBJECT,
        OBJECT;

    }

    public static final class PrettyTurtleWriterFactory
    implements RDFWriterFactory {
        @Nonnull
        public RDFFormat format() {
            return RDFFormats.PRETTY_TURTLE;
        }

        @Nonnull
        public RDFWriter create(@Nonnull OutputStream theStream, @Nonnull Options theOptions) {
            return new PrettyTurtleWriter(theStream, theOptions);
        }
    }
}

