/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.common.io.block;

import com.stardog.common.io.block.BlockSpec;
import com.stardog.common.io.block.BlockWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;

public final class TextBlockWriter
extends BlockWriter {
    private int column = 0;

    public TextBlockWriter(Writer out) {
        super(out, " ");
    }

    @Override
    public void println() throws IOException {
        super.println();
        this.column = 0;
    }

    @Override
    public void write(char[] buf, int off, int len) throws IOException {
        super.write(buf, off, len);
        this.column += len;
    }

    @Override
    public void write(int c) throws IOException {
        super.write(c);
        ++this.column;
    }

    @Override
    public void write(String s, int off, int len) throws IOException {
        super.write(s, off, len);
        this.column += len;
    }

    @Override
    protected BlockWriter.Block createBlock(BlockSpec spec) {
        return new TextBlock(this, spec);
    }

    public static void main(String[] args) throws Exception {
        TextBlockWriter aWriter = new TextBlockWriter(new OutputStreamWriter((OutputStream)System.out, Charset.defaultCharset()));
        BlockSpec aSpec = BlockSpec.INDENTED.copy().indentSize(4).newLineAfterBegin(true).newLineAfterEnd(true).immutable();
        aWriter.write("some stuff on a line");
        aWriter.beginBlock(aSpec);
        aWriter.write("some stuff in the new block");
        aWriter.beginBlock(aSpec);
        aWriter.write("some stuff in the newer block");
        aWriter.beginBlock(aSpec);
        aWriter.write("some stuff in the newest block");
        aWriter.endBlock();
        aWriter.write("back in the newer block");
        aWriter.endBlock();
        aWriter.write("back in the original new block");
        aWriter.endBlock();
        aWriter.write("some final stuff on a line");
        aWriter.flush();
    }

    private class TextBlock
    extends BlockWriter.Block {
        private int indent;

        public TextBlock(TextBlockWriter textBlockWriter, BlockSpec spec) {
            super(spec);
        }

        @Override
        protected void afterBegin() {
            this.indent = this.spec.getIndentSize();
        }
    }
}

