/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.common.io.block;

import com.google.common.base.Preconditions;
import com.google.common.collect.Queues;
import com.stardog.common.io.block.BlockSpec;
import java.io.IOException;
import java.io.Writer;
import java.util.Deque;

public abstract class BlockWriter
extends Writer {
    private static final BlockSpec INVISIBLE = BlockSpec.INDENTED.copy().indentSize(0).immutable();
    private final Deque<Block> blocks = Queues.newArrayDeque();
    private final String space;
    private final Writer out;
    private int tabSize = 3;
    private boolean newLine = true;
    private static final String lineSeparator = System.lineSeparator();

    public BlockWriter(Writer out, String space) {
        super((Object)out);
        this.out = out;
        Preconditions.checkNotNull((Object)space);
        this.space = space;
    }

    protected int depth() {
        return this.blocks.size();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    protected void startNewLine() throws IOException {
        Block currentBlock = this.currentBlock();
        if (currentBlock != null) {
            this.printSpace(currentBlock.spec.getIndentSize() * this.depth());
        }
    }

    public void endBlocks() throws IOException {
        while (!this.blocks.isEmpty()) {
            this.endBlock();
        }
    }

    protected abstract Block createBlock(BlockSpec var1);

    protected Block currentBlock() {
        return this.blocks.peek();
    }

    public void beginBlock(BlockSpec spec) throws IOException {
        Block block = this.createBlock(spec);
        block.beforeBegin();
        this.blocks.push(block);
        block.afterBegin();
    }

    public BlockWriter beginBlock() throws IOException {
        this.beginBlock(INVISIBLE);
        return this;
    }

    public BlockWriter endBlock() throws IllegalStateException, IOException {
        Preconditions.checkState((!this.blocks.isEmpty() ? 1 : 0) != 0, (Object)"No block to end!");
        Block block = this.blocks.peek();
        block.beforeEnd();
        this.blocks.pop();
        block.afterEnd();
        return this;
    }

    public void println() throws IOException {
        super.write(lineSeparator);
        this.newLine = true;
    }

    @Override
    public void write(int c) throws IOException {
        this.checkNewLine();
        this.out.write(c);
    }

    @Override
    public void write(char[] buf, int off, int len) throws IOException {
        this.checkNewLine();
        this.out.write(buf, off, len);
    }

    @Override
    public void write(String s, int off, int len) throws IOException {
        this.checkNewLine();
        this.out.write(s, off, len);
    }

    private void checkNewLine() throws IOException {
        if (this.newLine) {
            this.newLine = false;
            this.startNewLine();
        }
    }

    public BlockWriter printSpace() throws IOException {
        this.printSpace(1);
        return this;
    }

    public BlockWriter printSpace(int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            this.out.write(this.space);
        }
        return this;
    }

    public BlockWriter printTab() throws IOException {
        this.printSpace(this.tabSize);
        return this;
    }

    public int getTabSize() {
        return this.tabSize;
    }

    public void setTabSize(int tabSize) {
        this.tabSize = tabSize;
    }

    protected abstract class Block {
        protected final BlockSpec spec;

        protected Block(BlockSpec spec) {
            this.spec = spec;
        }

        protected void beforeBegin() throws IOException {
            if (this.spec.getTitle() != null) {
                BlockWriter.this.write(this.spec.getTitle());
                BlockWriter.this.printSpace();
            }
            if (this.spec.isNewLineBeforeBegin()) {
                BlockWriter.this.println();
            }
            if (this.spec.getBeginMarker() != null) {
                BlockWriter.this.write(this.spec.getBeginMarker());
            }
            if (this.spec.isNewLineAfterBegin()) {
                BlockWriter.this.println();
            }
        }

        protected void afterBegin() {
        }

        protected void beforeEnd() throws IOException {
            if (this.spec.isNewLineBeforeEnd()) {
                BlockWriter.this.println();
            }
        }

        protected void afterEnd() throws IOException {
            if (this.spec.getEndMarker() != null) {
                BlockWriter.this.write(this.spec.getEndMarker());
            }
            if (this.spec.isNewLineAfterEnd()) {
                BlockWriter.this.println();
            }
        }
    }
}

