/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.common.io.block;

import com.complexible.common.base.Copyable;
import com.google.common.base.Preconditions;
import com.stardog.common.io.block.BlockMarker;

public final class BlockSpec
implements Copyable<BlockSpec> {
    public static final BlockSpec INDENTED = new BlockSpec().immutable();
    private boolean mutable = true;
    private String title = null;
    private String beginMarker = null;
    private String endMarker = null;
    private int indentSize = -1;
    private boolean newLineBeforeBegin = false;
    private boolean newLineAfterBegin = false;
    private boolean newLineBeforeEnd = false;
    private boolean newLineAfterEnd = false;

    private void assertMutable() {
        Preconditions.checkState((boolean)this.mutable, (Object)"This object is immutable");
    }

    public BlockSpec indentSize(int indentSize) {
        this.assertMutable();
        this.indentSize = indentSize;
        return this;
    }

    public BlockSpec marker(BlockMarker marker) {
        this.assertMutable();
        this.beginMarker = marker == null ? null : marker.getBegin();
        this.endMarker = marker == null ? null : marker.getEnd();
        return this;
    }

    public BlockSpec marker(String beginMarker, String endMarker) {
        this.assertMutable();
        this.beginMarker = beginMarker;
        this.endMarker = endMarker;
        return this;
    }

    public BlockSpec newLineAfterBegin(boolean enabled) {
        this.assertMutable();
        this.newLineAfterBegin = enabled;
        return this;
    }

    public BlockSpec newLineAfterEnd(boolean enabled) {
        this.assertMutable();
        this.newLineAfterEnd = enabled;
        return this;
    }

    public BlockSpec newLineBeforeBegin(boolean enabled) {
        this.assertMutable();
        this.newLineBeforeBegin = enabled;
        return this;
    }

    public BlockSpec newLineBeforeEnd(boolean enabled) {
        this.assertMutable();
        this.newLineBeforeEnd = enabled;
        return this;
    }

    public BlockSpec title(String title) {
        this.assertMutable();
        this.title = title;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public String getBeginMarker() {
        return this.beginMarker;
    }

    public String getEndMarker() {
        return this.endMarker;
    }

    public int getIndentSize() {
        return this.indentSize;
    }

    public boolean isNewLineBeforeBegin() {
        return this.newLineBeforeBegin;
    }

    public boolean isNewLineAfterBegin() {
        return this.newLineAfterBegin;
    }

    public boolean isNewLineBeforeEnd() {
        return this.newLineBeforeEnd;
    }

    public boolean isNewLineAfterEnd() {
        return this.newLineAfterEnd;
    }

    public BlockSpec copy() {
        return new BlockSpec().title(this.title).marker(this.beginMarker, this.endMarker).indentSize(this.indentSize).newLineBeforeBegin(this.newLineBeforeBegin).newLineAfterBegin(this.newLineAfterBegin).newLineBeforeEnd(this.newLineBeforeEnd).newLineAfterEnd(this.newLineAfterEnd);
    }

    public BlockSpec immutable() {
        BlockSpec spec = this.copy();
        spec.mutable = false;
        return spec;
    }
}

