/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.logging.protobuf;

import com.complexible.common.base.CloseableIterator;
import com.complexible.common.base.Disposables;
import com.complexible.stardog.KernelEvent;
import com.complexible.stardog.logging.LogReader;
import com.complexible.stardog.logging.protobuf.ProtobufLogReader;
import com.complexible.stardog.logging.protobuf.ProtobufLogging;
import com.google.common.collect.AbstractIterator;
import com.google.protobuf.Message;
import com.google.protobuf.TextFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.util.Optional;

public final class ProtobufTextLogReader
implements LogReader {
    @Override
    public CloseableIterator<KernelEvent<?>> read(InputStream theStream) throws IOException {
        InputStreamReader aReadable = new InputStreamReader(theStream);
        Optional<String> aRecordString = ProtobufTextLogReader.readRecordString(aReadable);
        if (aRecordString.isPresent()) {
            ProtobufLogging.Header.Builder aBuilder = ProtobufLogging.Header.newBuilder();
            try {
                TextFormat.merge((CharSequence)aRecordString.get(), (Message.Builder)aBuilder);
            }
            catch (TextFormat.ParseException e) {
                throw new IOException("Log header is missing or malformed");
            }
        }
        return new EventIterator(aReadable);
    }

    private static Optional<String> readRecordString(InputStreamReader theReader) throws IOException {
        int aChar = theReader.read();
        while (aChar != -1 && aChar != 2) {
            aChar = theReader.read();
        }
        if (aChar == -1) {
            return Optional.empty();
        }
        aChar = theReader.read();
        StringBuilder aStrBuilder = new StringBuilder();
        aStrBuilder.append((char)aChar);
        aChar = theReader.read();
        while (aChar != -1 && aChar != 3) {
            aStrBuilder.append((char)aChar);
            aChar = theReader.read();
        }
        if (aChar == -1) {
            throw new IOException("Incomplete protobuf record");
        }
        return Optional.of(aStrBuilder.toString());
    }

    private static class EventIterator
    extends AbstractIterator<KernelEvent<?>>
    implements CloseableIterator<KernelEvent<?>> {
        private final InputStreamReader mReadable;

        public EventIterator(InputStreamReader theReadable) {
            this.mReadable = theReadable;
            Disposables.markCreated((Object)((Object)this));
        }

        protected KernelEvent<?> computeNext() {
            try {
                Optional<String> aRecordString = ProtobufTextLogReader.readRecordString(this.mReadable);
                if (aRecordString.isEmpty()) {
                    return (KernelEvent)this.endOfData();
                }
                ProtobufLogging.KernelEvent.Builder aBuilder = ProtobufLogging.KernelEvent.newBuilder();
                TextFormat.merge((CharSequence)aRecordString.get(), (Message.Builder)aBuilder);
                return ProtobufLogReader.transform(aBuilder.build());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public void close() {
            Disposables.markReleased((Object)((Object)this));
            try {
                this.mReadable.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

