/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.logging.protobuf;

import com.complexible.common.base.CloseableIterator;
import com.complexible.common.base.Disposables;
import com.complexible.common.io.ByteReader;
import com.complexible.common.io.mem.MemoryByteReader;
import com.complexible.common.protobuf.io.InputStreamSizeDelimitedProtobufReader;
import com.complexible.stardog.KernelEvent;
import com.complexible.stardog.KernelEventType;
import com.complexible.stardog.logging.LogReader;
import com.complexible.stardog.logging.protobuf.ProtobufLogging;
import com.complexible.stardog.metadata.ByteIO;
import com.google.common.collect.AbstractIterator;
import com.google.protobuf.ByteString;
import com.google.protobuf.MessageLite;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.EnumSet;

public final class ProtobufLogReader
implements LogReader {
    @Override
    public CloseableIterator<KernelEvent<?>> read(InputStream theStream) throws IOException {
        InputStreamSizeDelimitedProtobufReader aReader = new InputStreamSizeDelimitedProtobufReader(theStream, (MessageLite)ProtobufLogging.Header.getDefaultInstance());
        try {
            ProtobufLogging.Header aHeader = (ProtobufLogging.Header)aReader.read();
            if (aHeader == null) {
                throw new IOException("Log header is missing or malformed");
            }
        }
        catch (IOException e) {
            throw new IOException("Log header is missing or malformed");
        }
        return new ReaderIteration(theStream);
    }

    static KernelEvent<?> transform(ProtobufLogging.KernelEvent theKernelEvent) throws IOException {
        Object aValue = !theKernelEvent.hasValue() || theKernelEvent.getValue() == ByteString.EMPTY || theKernelEvent.getValue().isEmpty() ? null : ByteIO.getGeneric().read((ByteReader)new MemoryByteReader(theKernelEvent.getValue().toByteArray()));
        EnumSet<KernelEvent.Flags> aFlags = EnumSet.noneOf(KernelEvent.Flags.class);
        if (theKernelEvent.getFlags() != 0) {
            for (int i = 0; i < KernelEvent.Flags.values().length; ++i) {
                if ((theKernelEvent.getFlags() & 1 << i) == 0) continue;
                aFlags.add(KernelEvent.Flags.values()[i]);
            }
        }
        return KernelEvent.builder((KernelEventType)KernelEventType.valueOf((int)theKernelEvent.getType())).ip(theKernelEvent.getIp()).user(theKernelEvent.getUser()).db(theKernelEvent.hasDb() ? theKernelEvent.getDb() : null).timestamp(theKernelEvent.getTimestamp()).value(aValue).flags(aFlags).create();
    }

    private static final class ReaderIteration
    extends AbstractIterator<KernelEvent<?>>
    implements CloseableIterator<KernelEvent<?>> {
        private final InputStream mStream;
        private final InputStreamSizeDelimitedProtobufReader<ProtobufLogging.KernelEvent> mReader;

        private ReaderIteration(InputStream theStream) {
            this.mStream = theStream;
            this.mReader = new InputStreamSizeDelimitedProtobufReader(this.mStream, (MessageLite)ProtobufLogging.KernelEvent.getDefaultInstance());
            Disposables.markCreated((Object)((Object)this));
        }

        protected KernelEvent<?> computeNext() {
            try {
                ProtobufLogging.KernelEvent aRead = (ProtobufLogging.KernelEvent)this.mReader.read();
                if (aRead == null) {
                    return (KernelEvent)this.endOfData();
                }
                return ProtobufLogReader.transform(aRead);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public void close() {
            Disposables.markReleased((Object)((Object)this));
            try {
                this.mStream.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

