/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.logging;

import com.complexible.common.base.CloseableIterator;
import com.complexible.stardog.KernelEvent;
import com.complexible.stardog.KernelEventLogging;
import com.complexible.stardog.KernelEventType;
import com.complexible.stardog.logging.LogReader;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Splitter;
import com.google.common.collect.AbstractIterator;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Calendar;
import java.util.EnumSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.core.util.Closer;

public final class JsonLogReader
implements LogReader {
    @Override
    public CloseableIterator<KernelEvent<?>> read(InputStream theStream) throws IOException {
        JsonMapper mapper = new JsonMapper();
        return new EventIIterator((MappingIterator<ObjectNode>)mapper.readerFor(ObjectNode.class).readValues(theStream));
    }

    static KernelEvent<?> transform(ObjectNode node) throws IOException {
        String type = node.path(KernelEventLogging.Field.EVENT.name()).textValue();
        String db = node.path(KernelEventLogging.Field.DATABASE.name()).textValue();
        String ip = node.path(KernelEventLogging.Field.IP.name()).textValue();
        Calendar time = (Calendar)KernelEventLogging.parseFieldValue((KernelEventLogging.Field)KernelEventLogging.Field.TIME, (String)node.path(KernelEventLogging.Field.TIME.name()).textValue());
        String user = node.path(KernelEventLogging.Field.USER.name()).textValue();
        String value = node.path(KernelEventLogging.Field.VALUE.name()).textValue();
        EnumSet flags = Splitter.on((String)", ").splitToStream((CharSequence)node.path(KernelEventLogging.Field.FLAGS.name()).textValue().trim()).filter(StringUtils::isNotBlank).map(KernelEvent.Flags::valueOf).collect(Collectors.toCollection(() -> EnumSet.noneOf(KernelEvent.Flags.class)));
        return KernelEvent.builder((KernelEventType)KernelEventType.valueOf((String)type)).ip(ip).user(user).db(db).timestamp(time.getTimeInMillis()).value((Object)value).flags(flags).create();
    }

    private static final class EventIIterator
    extends AbstractIterator<KernelEvent<?>>
    implements CloseableIterator<KernelEvent<?>> {
        private final MappingIterator<ObjectNode> nodes;

        private EventIIterator(MappingIterator<ObjectNode> nodes) {
            this.nodes = nodes;
        }

        protected KernelEvent<?> computeNext() {
            try {
                return this.nodes.hasNext() ? JsonLogReader.transform((ObjectNode)this.nodes.next()) : (KernelEvent<?>)this.endOfData();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public void close() {
            Closer.closeSilently(this.nodes);
        }
    }
}

