/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.virtual.cli;

import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.complexible.stardog.cli.impl.CliUtil;
import com.complexible.stardog.virtual.api.admin.VirtualGraphAdminConnection;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.stardog.stark.Namespaces;
import com.stardog.stark.Values;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import com.stardog.stark.io.RDFParsers;
import com.stardog.stark.io.RDFWriters;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.io.File;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Set;

@Command(name="match", description="Matches one or more tables from a data source with RDF classes .", examples={"* Creating matching between data source tables(s) and target RDF class(es)", "    $ stardog-admin virtual match ..."})
public class VirtualMatch
extends SecureStardogAdminCommand<Void> {
    @Arguments(description="input file", title={"input file"}, required=true)
    public final String mInputFile;
    @Option(name={"-f", "--format"}, description="Data format for the input file. The supported formats are NTRIPLES, RDF/XML, TURTLE, PRETTY_TURTLE, TRIG, N3, NQUADS, JSONLD. If no format is specified, the file name will be used to guess the required format.", title="rdf format")
    public String mFormat;
    @Option(name={"--output-format"}, description="Output RDF Format for the output mappings. The supported formats are NTRIPLES, RDF/XML, TURTLE, PRETTY_TURTLE, TRIG, N3, NQUADS, JSONLD.", title="Output Format")
    public String mOutputFormat = RDFFormats.PRETTY_TURTLE.name();

    @Inject
    public VirtualMatch(PasswordReader theReader) {
        super(theReader);
        this.mInputFile = null;
    }

    public void performSecure(AdminConnection theConn) throws Exception {
        File aInputFile = new File(this.mInputFile);
        RDFFormat aInputFormat = CliUtil.getFormat((String)this.mFormat, (File)aInputFile);
        RDFFormat aOutputFormat = CliUtil.getFormat((String)this.mOutputFormat);
        Set aInput = RDFParsers.read((Path)aInputFile.toPath(), (RDFFormat)aInputFormat);
        Set aOutput = ((VirtualGraphAdminConnection)theConn.as(VirtualGraphAdminConnection.class)).getMatchingSuggestions(aInput);
        Iterable aNamespaces = Iterables.concat((Iterable)Namespaces.DEFAULT, Collections.singleton(Values.namespace((String)"match", (String)"tag:stardog:api:match:")));
        RDFWriters.write((OutputStream)System.out, (RDFFormat)aOutputFormat, (Iterable)aOutput, (Iterable)aNamespaces);
    }
}

