/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.virtual.cli;

import com.complexible.common.base.PropertiesBuilder;
import com.complexible.common.util.EnhancedProperties;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.impl.BaseStardogCommand;
import com.complexible.stardog.virtual.api.JdbcOptions;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;

@Command(name="source_metadata", description="Query source database metadata used by virtual graphs. Useful for troubleshooting virtual graph behavior. JDBC driver must be present in client folder of Stardog installation.", examples={"* Query JDBC metadata for available schemas and catalogs", "    $ stardog-admin virtual source_metadata source.properties", "", "* Query JDBC metadata for tables in the given schema", "    $ stardog-admin virtual source_metadata source.properties source_schema", "", "* Query JDBC metadata for tables in the given catalog and schema", "    $ stardog-admin virtual source_metadata --catalog source_catalog source.properties source_schema", "", "* Query JDBC metadata for fields and constraints in the given schema-qualified table", "    $ stardog-admin virtual source_metadata source.properties source_schema source_table", "", "* Query JDBC metadata for fields and constraints in the given catalog-and-schema-qualified table", "    $ stardog-admin virtual source_metadata -c source_catalog source.properties source_schema source_table"})
public class VirtualGraphSourceMetadata
extends BaseStardogCommand<Void> {
    @Arguments(required=true, description="The configuration file for the virtual graph, a schema name and optionally a table name.", title={"options", "[schema name]", "[table name]"})
    public final List<String> mArgs = Lists.newArrayList();
    @Option(name={"-c", "--catalog"}, description="Catalog name for systems with 3-level table namespaces", title="catalog name")
    public String mCatalogName = null;
    private Properties mStardogProps;

    @Inject
    public VirtualGraphSourceMetadata(PasswordReader theReader) {
        super(theReader);
    }

    private Connection openConnection(String filename) throws Exception {
        this.mStardogProps = PropertiesBuilder.propertiesFromFile((Path)Paths.get(filename, new String[0]));
        Properties jdbcProps = JdbcOptions.getDriverProperties((Map)this.mStardogProps);
        if (!EnhancedProperties.containsKeyIgnoreCase((Properties)jdbcProps, (String)"user")) {
            jdbcProps.setProperty("user", this.mStardogProps.getProperty("jdbc.username", ""));
        }
        if (!EnhancedProperties.containsKeyIgnoreCase((Properties)jdbcProps, (String)"password")) {
            jdbcProps.setProperty("password", this.mStardogProps.getProperty("jdbc.password", ""));
        }
        if (this.mStardogProps.containsKey("jdbc.driver")) {
            String driverClass = this.mStardogProps.getProperty("jdbc.driver");
            System.out.println("Loading driver: " + driverClass);
            try {
                Class.forName(driverClass);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Unable to load class: " + driverClass + "\n\nMake sure jar file for JDBC driver is present in the client folder of the Stardog install");
            }
        }
        return DriverManager.getConnection(this.mStardogProps.getProperty("jdbc.url"), jdbcProps);
    }

    static void header(String name) {
        System.out.println("==================== " + name + " ====================");
    }

    public static void printResultSet(ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int results = 0;
        while (rs.next()) {
            System.out.println("== Row " + ++results);
            for (int col = 0; col < rsmd.getColumnCount(); ++col) {
                System.out.println(rsmd.getColumnLabel(col + 1) + ": " + rs.getString(col + 1));
            }
        }
        if (results == 0) {
            System.out.println("<no results>");
        }
        rs.close();
    }

    private void driverInfo(DatabaseMetaData dbmd) {
        VirtualGraphSourceMetadata.header("Driver Information");
        try {
            System.out.println("DatabaseMetaData.getDatabaseProductName(): " + dbmd.getDatabaseProductName());
            System.out.println("DatabaseMetaData.getDatabaseProductVersion(): " + dbmd.getDatabaseProductVersion());
            System.out.println("DatabaseMetaData.getDatabaseMajorVersion(): " + dbmd.getDatabaseMajorVersion());
            System.out.println("DatabaseMetaData.getDatabaseMinorVersion(): " + dbmd.getDatabaseMinorVersion());
            System.out.println("DatabaseMetaData.getDriverName(): " + dbmd.getDriverName());
            System.out.println("DatabaseMetaData.getDatabaseProductName(): " + dbmd.getDatabaseProductName());
            String driverPath = this.getDriverPath(dbmd);
            if (driverPath != null) {
                System.out.println("Driver path: " + driverPath);
            }
        }
        catch (SQLException e) {
            System.out.println("Error reading driver info: " + String.valueOf(e));
        }
    }

    private String getDriverPath(DatabaseMetaData dbmd) {
        String driverClass = (String)this.mStardogProps.get("jdbc.driver");
        Class<?> clazz = dbmd.getClass();
        if (driverClass != null) {
            try {
                clazz = Class.forName(driverClass);
            }
            catch (ClassNotFoundException e) {
                System.out.println("Error loading driver class " + driverClass + ": " + String.valueOf(e));
            }
        }
        try {
            return clazz.getProtectionDomain().getCodeSource().getLocation().getFile();
        }
        catch (Throwable t) {
            System.out.println("Error locating path for class " + clazz.getCanonicalName());
            return null;
        }
    }

    static void catalogInfo(Connection conn, DatabaseMetaData dbmd) throws SQLException {
        VirtualGraphSourceMetadata.header("Catalog Information");
        System.out.println("Connection.getCatalog(): " + conn.getCatalog());
        System.out.println("DatabaseMetaData.getCatalogs():");
        VirtualGraphSourceMetadata.printResultSet(dbmd.getCatalogs());
    }

    void schemaInfo(Connection conn, DatabaseMetaData dbmd) throws SQLException {
        VirtualGraphSourceMetadata.header("Schema Information");
        try {
            System.out.println("Connection.getSchema(): " + conn.getSchema());
        }
        catch (AbstractMethodError e) {
            System.out.println("Connection.getSchema() is not implemented");
        }
        if (this.mCatalogName == null) {
            System.out.println("DatabaseMetaData.getSchemas():");
            VirtualGraphSourceMetadata.printResultSet(dbmd.getSchemas());
        } else {
            System.out.println("DatabaseMetaData.getSchemas(" + this.mCatalogName + ", null):");
            VirtualGraphSourceMetadata.printResultSet(dbmd.getSchemas(this.mCatalogName, null));
        }
    }

    void inspectSchema(DatabaseMetaData dbmd, String schemaName) throws SQLException {
        VirtualGraphSourceMetadata.header("DatabaseMetaData.getTables(" + this.formatCatalogSchema(schemaName) + ", null, null)");
        VirtualGraphSourceMetadata.printResultSet(dbmd.getTables(this.mCatalogName, schemaName, null, null));
    }

    void inspectTable(DatabaseMetaData dbmd, String schemaName, String tableName) throws SQLException {
        String catalogSchema = this.formatCatalogSchema(schemaName);
        VirtualGraphSourceMetadata.header("DatabaseMetaData.getColumns(" + catalogSchema + ", " + tableName + ", null)");
        VirtualGraphSourceMetadata.printResultSet(dbmd.getColumns(this.mCatalogName, schemaName, tableName, null));
        VirtualGraphSourceMetadata.header("DatabaseMetaData.getIndexInfo(" + catalogSchema + ", " + tableName + ", false, true)");
        VirtualGraphSourceMetadata.printResultSet(dbmd.getIndexInfo(this.mCatalogName, schemaName, tableName, false, true));
        VirtualGraphSourceMetadata.header("DatabaseMetaData.getPrimaryKeys(" + catalogSchema + ", " + tableName + ")");
        VirtualGraphSourceMetadata.printResultSet(dbmd.getPrimaryKeys(this.mCatalogName, schemaName, tableName));
        VirtualGraphSourceMetadata.header("DatabaseMetaData.getImportedKeys(" + catalogSchema + ", " + tableName + ")");
        VirtualGraphSourceMetadata.printResultSet(dbmd.getImportedKeys(this.mCatalogName, schemaName, tableName));
    }

    String formatCatalogSchema(String schemaName) {
        return (this.mCatalogName == null ? "null" : this.mCatalogName) + ", " + schemaName;
    }

    public Void call() throws Exception {
        if (this.mArgs.isEmpty()) {
            throw new IllegalArgumentException("Connection properties must be provided");
        }
        try (Connection conn = this.openConnection(this.mArgs.get(0));){
            DatabaseMetaData dbmd = conn.getMetaData();
            if (this.mArgs.size() == 1) {
                if (this.mCatalogName == null) {
                    this.driverInfo(dbmd);
                    VirtualGraphSourceMetadata.catalogInfo(conn, dbmd);
                }
                this.schemaInfo(conn, dbmd);
            } else if (this.mArgs.size() == 2) {
                this.inspectSchema(dbmd, this.mArgs.get(1));
            } else if (this.mArgs.size() == 3) {
                this.inspectTable(dbmd, this.mArgs.get(1), this.mArgs.get(2));
            }
        }
        return null;
    }
}

