/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.virtual.cli;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.complexible.stardog.virtual.api.admin.VirtualGraphAdminConnection;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Command;

@Command(name="remove", description="Removes a registered virtual graph.", examples={"* Remove a registered virtual graph named myGraph", "    $ stardog-admin virtual remove myGraph"})
public final class VirtualGraphRemove
extends SecureStardogAdminCommand<Void> {
    @Arguments(required=true, description="Name of the virtual graph to remove", title={"name"})
    public String mName;

    @Inject
    public VirtualGraphRemove(PasswordReader theReader) {
        super(theReader);
    }

    public void performSecure(AdminConnection theConn) throws StardogException {
        VirtualGraphAdminConnection aConn = (VirtualGraphAdminConnection)theConn.as(VirtualGraphAdminConnection.class);
        boolean aRemoved = aConn.removeGraph(this.mName);
        if (aRemoved) {
            System.out.format("Successfully removed virtual graph %s%n", this.mName);
        } else {
            System.out.format("Virtual graph does not exist: %s%n", this.mName);
        }
    }
}

