/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.virtual.cli;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.complexible.stardog.virtual.api.admin.VirtualGraphAdminConnection;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import java.util.Properties;

@Command(name="options", description="Prints the configuration options of a registered virtual graph.", examples={"* Prints the configuration options of a registered virtual graph", "    $ stardog-admin virtual options myGraph"})
public final class VirtualGraphPrintOptions
extends SecureStardogAdminCommand<Void> {
    @Arguments(required=true, description="Name of the virtual graph", title={"name"})
    public String mName;

    @Inject
    public VirtualGraphPrintOptions(PasswordReader theReader) {
        super(theReader);
    }

    public void performSecure(AdminConnection theConn) throws StardogException {
        try {
            VirtualGraphAdminConnection aConn = (VirtualGraphAdminConnection)theConn.as(VirtualGraphAdminConnection.class);
            Properties aOptions = aConn.getOptions(this.mName);
            aOptions.store(System.out, "Configuration options for the virtual graph " + this.mName);
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e, StardogException.class);
            throw new CliException((Throwable)e);
        }
    }
}

