/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.virtual.cli;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.complexible.stardog.virtual.api.VirtualGraphMappingSyntax;
import com.complexible.stardog.virtual.api.admin.VirtualGraphAdminConnection;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;

@Command(name="mappings", description="Prints the mappings of a registered virtual graph.", examples={"* Prints the mappings of a registered virtual graph in Stardog mappings syntax", "    $ stardog-admin virtual mappings myGraph", "", "* Prints the mappings of a registered virtual graph in the standard R2RML Turtle syntax", "    $ stardog-admin virtual mappings --format r2rml myGraph"})
public final class VirtualGraphPrintMappings
extends SecureStardogAdminCommand<Void> {
    @Option(name={"-f", "--format"}, description="Format of the mappings; one of [R2RML, SMS]", title="Mappings format")
    public String mSyntax = VirtualGraphMappingSyntax.SMS2.toString();
    @Arguments(required=true, description="Name of the virtual graph", title={"name"})
    public String mName;

    @Inject
    public VirtualGraphPrintMappings(PasswordReader theReader) {
        super(theReader);
    }

    public void performSecure(AdminConnection theConn) throws StardogException {
        try {
            VirtualGraphAdminConnection aConn = (VirtualGraphAdminConnection)theConn.as(VirtualGraphAdminConnection.class);
            System.out.println(aConn.getMappingsString(this.mName, this.mSyntax));
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e, StardogException.class);
            throw new CliException((Throwable)e);
        }
    }
}

