/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.virtual.cli;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.complexible.stardog.virtual.api.admin.VirtualGraphAdminConnection;
import com.complexible.stardog.virtual.api.admin.VirtualGraphInfo;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Command;

@Command(name="online", description="Online a virtual graph.", discussion="Online a virtual graph. When Stardog restarts, Virtual Graphs that cannot be loaded will be listed (stardog-admin virtual list) as offline. Use this command to retry loading an offline Virtual Graph.", examples={"* Online a virtual graph named myGraph", "    $ stardog-admin virtual online myGraph"})
public final class VirtualGraphOnline
extends SecureStardogAdminCommand<Void> {
    @Arguments(required=true, description="Name of the virtual graph to online", title={"name"})
    public String mName;

    @Inject
    public VirtualGraphOnline(PasswordReader theReader) {
        super(theReader);
    }

    public void performSecure(AdminConnection theConn) throws StardogException {
        VirtualGraphAdminConnection aConn = (VirtualGraphAdminConnection)theConn.as(VirtualGraphAdminConnection.class);
        aConn.onlineGraph(this.mName);
        VirtualGraphInfo info = aConn.getVirtualGraphInfo(this.mName);
        if (info.isAvailable()) {
            System.out.format("Successfully brought online virtual graph %s%n", this.mName);
        } else {
            System.out.format("Failed to bring online virtual graph %s%n", this.mName);
        }
    }
}

