/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.virtual.cli;

import com.complexible.common.dataexporter.TextTabularOutput;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.complexible.stardog.virtual.api.admin.VirtualGraphAdminConnection;
import com.complexible.stardog.virtual.api.admin.VirtualGraphInfo;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import java.io.OutputStream;
import java.util.List;
import java.util.stream.Collectors;

@Command(name="list", description="Lists registered virtual graphs.", examples={"* Lists all registered virtual graphs", "    $ stardog-admin virtual list", "", "* Lists only the virtual graphs that are shared by all databases", "    $ stardog-admin virtual list \"*\"", "", "* Lists all virtual graphs associated with database myDb", "    $ stardog-admin virtual list myDb", "", "* Lists all virtual graphs associated with all databases or with database myDb", "    $ stardog-admin virtual list \"*\" myDb"})
public final class VirtualGraphList
extends SecureStardogAdminCommand<Void> {
    @Arguments(description="List the virtual graphs that are associated with any of the databases included in this list or list all virtual graphs if no database name is provided", title={"databases"})
    public final List<String> mDbNames = Lists.newArrayList();

    @Inject
    public VirtualGraphList(PasswordReader theReader) {
        super(theReader);
    }

    public void performSecure(AdminConnection theConn) throws StardogException {
        List<VirtualGraphInfo> graphs = ((VirtualGraphAdminConnection)theConn.as(VirtualGraphAdminConnection.class)).getVirtualGraphInfos().stream().filter(aVg -> this.mDbNames.isEmpty() || this.mDbNames.contains(aVg.getDatabase())).collect(Collectors.toList());
        if (!graphs.isEmpty()) {
            TextTabularOutput aTable = new TextTabularOutput((OutputStream)System.out, new String[]{"Virtual Graph", "Data Source", "Database", "Online"});
            graphs.forEach(aVg -> aTable.addRow(new Object[]{aVg.getIri(), aVg.getDataSourceName(), aVg.getDatabase(), aVg.isAvailable()}));
            aTable.output();
            System.out.println();
        }
        System.out.format("%d virtual graphs%n", graphs.size());
    }
}

