/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.virtual.cli;

import com.complexible.common.base.Options;
import com.complexible.common.io.Files2;
import com.complexible.common.rdf.query.parser.sparql.ast.ParseException;
import com.complexible.common.timer.DurationFormat;
import com.complexible.stardog.Contexts;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.Connection;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.impl.CliUtil;
import com.complexible.stardog.cli.impl.ConnectionCommand;
import com.complexible.stardog.security.StardogSecurityException;
import com.complexible.stardog.virtual.api.StardogMappings;
import com.complexible.stardog.virtual.api.VirtualGraphMappingSyntax;
import com.complexible.stardog.virtual.api.admin.ComputeAdminConnection;
import com.complexible.stardog.virtual.api.admin.VirtualGraphAdminConnection;
import com.google.common.base.Charsets;
import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.io.MoreFiles;
import com.google.inject.Inject;
import com.stardog.stark.Resource;
import com.stardog.stark.Values;
import com.stardog.stark.io.InvalidRDF;
import com.stardog.stark.io.ParserOptions;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import com.stardog.stark.io.RDFHandlerException;
import com.stardog.stark.io.RDFParsers;
import com.stardog.stark.query.MalformedQuery;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import io.airlift.command.OptionType;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

@Command(name="import", description="Imports (aka materializes) data from a database or file (delimited or JSON) into Stardog.", examples={"* Import all of the contents of a virtual graph with direct mappings into database myDB", "    $ stardog-admin virtual import myDB source.properties", "", "* Import all of the contents of a virtual graph with the mappings written in Stardog mappings syntax", "    $ stardog-admin virtual import myDB source.properties source.sms", "", "* Import all of the contents of a virtual graph with the mappings written in standard R2RML Turtle syntax", "    $ stardog-admin virtual import --format r2rml myDB source.properties source.ttl", "", "* Import the contents of a CSV file with the given mappings", "    $ stardog-admin virtual import myDB mappings.sms input.csv", "", "* Import the contents of a CSV file with generated mappings", "    $ stardog-admin virtual import myDB source.properties input.csv", "", "* Import the contents of a JSON file with the given mappings", "    $ stardog-admin virtual import --format sms myDB mappings.sms input.json", "", "* Import the contents of a CSV file into a non-default graph", "    $ stardog-admin virtual import --named-graph urn:imports:people myDB source.properties mappings.sms input.csv"})
public final class VirtualGraphImport
extends ConnectionCommand<Void> {
    @Option(name={"-s", "--data-source"}, title="data source", description="The data source for this import. Data sources can be added with stardog-admin data-source commands.")
    public String mDataSource;
    @Option(name={"-f", "--format"}, description="Format of the mappings; one of [R2RML, SMS]. Use this command-line option instead of setting the mappings.syntax option in the options file.", title="Mappings format")
    public String mSyntax = "DEFAULT";
    @Option(name={"-g", "--named-graph"}, description="Target named graph. If no named graph is specified, the default graph will be used. This is the named graph where data will be imported into.", title="named graph")
    public String mNamedGraph = Contexts.DEFAULT.toString();
    @Option(name={"--remove-all"}, type=OptionType.COMMAND, description="Remove all flag. If this flag is set, all data in destination named graph will be removed before the import.", arity=0)
    protected boolean mRemoveAll = false;
    @Option(name={"--server"}, type=OptionType.GLOBAL, description="URL of Stardog Server. If this option isn't specified, it will be read from JVM argument 'stardog.default.cli.server'. If the JVM arg isn't set, the default value 'http://localhost:5820' is used. If server URL has no explicit port value, the default port value '5820' is used.  Example: 'stardog-admin --server http://12.34.56.78:5820 server stop' ", title="server url")
    public String mServerURL;
    @Option(name={"-c", "--compute"}, title="compute source", description="The compute source for this import. If provided, materialization of data will be processed on this compute server. The compute source should be the name of the data source when the external compute platform is Databricks. For emr-serverless as an external compute platform, this should be the file path containing the required properties for emr-serverless.")
    public String mComputeSource;
    @Option(name={"-pc", "--partition-column"}, title="partition column", description="The name of the partition column, to be specified in case of databricks JDBC connection.")
    public String mPartitionColumn;
    @Arguments(required=true, description="The name of the database to import the data followed by a configuration file, a mappings file and an input file. When importing from an RDBMS the configuration file is required, the mappings file is optional (when absent direct mapping is used), and input file argument is not used. When importing CSV, the configuration file is optional, the mappings file and the input file (should be a valid CSV file) are required.", title={"database name", "configFile", "mappingsFile", "inputFile"})
    public final List<String> mArgs = Lists.newArrayList();
    private String mDbName;
    private File mConfigFile;
    private File mMappingsFile;
    private File mInputFile;
    private final Properties mProperties = new Properties();
    public static final ImmutableSet<String> DATA_FILE_EXTS = ImmutableSet.of((Object)"csv", (Object)"tsv", (Object)"txt", (Object)"dat", (Object)"data", (Object)"json", (Object[])new String[0]);
    public static final ImmutableSet<String> PROPERTIES_EXT = ImmutableSet.of((Object)"properties");
    public static final ImmutableSet<String> MAPPING_EXTs = ImmutableSet.of((Object)"ttl", (Object)"rq", (Object)"sms", (Object)"sms2");
    public static final ImmutableSet<String> KNOWN_EXTS = ImmutableSet.builder().addAll(DATA_FILE_EXTS).addAll(PROPERTIES_EXT).addAll(MAPPING_EXTs).build();

    @Inject
    public VirtualGraphImport(PasswordReader theReader) {
        super(theReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Connection theConn) throws StardogException {
        try (AdminConnection admin = theConn.admin();){
            Stopwatch w = Stopwatch.createStarted();
            if (this.mComputeSource != null && !this.mComputeSource.isEmpty()) {
                try {
                    File computeFile;
                    if (this.mRemoveAll) {
                        theConn.begin();
                        theConn.remove().context((Resource)Values.iri((String)this.mNamedGraph));
                        theConn.commit();
                    }
                    VirtualGraphMappingSyntax syntax = VirtualGraphMappingSyntax.get((String)this.mSyntax, (File)this.mMappingsFile);
                    if (this.mMappingsFile != null && syntax != VirtualGraphMappingSyntax.SMS2) {
                        throw new CliException("Only SMS mapping file format is supported for external compute based imports");
                    }
                    ComputeAdminConnection aComputeAdminConnection = (ComputeAdminConnection)admin.as(ComputeAdminConnection.class);
                    String externalCompute = this.mComputeSource;
                    if (this.mComputeSource != null && (computeFile = new File(this.mComputeSource)).isFile()) {
                        try {
                            externalCompute = Files.lines(Paths.get(this.mComputeSource, new String[0])).collect(Collectors.joining(";"));
                        }
                        catch (RuntimeException e) {
                            throw new CliException("Error reading compute properties file '" + computeFile.getAbsolutePath() + "'. " + e.getMessage(), (Throwable)e);
                        }
                    }
                    if (this.mInputFile != null) {
                        String mappingsString = this.getMappingsString(syntax, this.mProperties);
                        String ext = com.google.common.io.Files.getFileExtension((String)this.mInputFile.getName());
                        VirtualGraphAdminConnection.InputFileType fileType = "json".equals(ext.toLowerCase()) ? VirtualGraphAdminConnection.InputFileType.JSON : VirtualGraphAdminConnection.InputFileType.DELIMITED;
                        aComputeAdminConnection.importFile(theConn.name(), mappingsString, this.mProperties, this.mNamedGraph, this.mInputFile.getAbsolutePath(), fileType, externalCompute);
                    }
                    this.mProperties.put("mappings.syntax", syntax.toString());
                    String aMappings = "";
                    if (this.mMappingsFile != null) {
                        aMappings = Files2.toString((Path)this.mMappingsFile.toPath(), (Charset)Charsets.UTF_8);
                    }
                    aComputeAdminConnection.importGraph(theConn.name(), this.mDataSource, this.mProperties, aMappings, this.mNamedGraph, this.mPartitionColumn, externalCompute, this.mRemoveAll);
                }
                catch (Exception e) {
                    throw new CliException(e.getMessage());
                }
                finally {
                    theConn.rollback();
                }
            } else if (this.mInputFile != null) {
                try {
                    if (this.mRemoveAll) {
                        theConn.begin();
                        theConn.remove().context((Resource)Values.iri((String)this.mNamedGraph));
                        theConn.commit();
                    }
                    VirtualGraphAdminConnection vgConn = (VirtualGraphAdminConnection)admin.as(VirtualGraphAdminConnection.class);
                    VirtualGraphMappingSyntax syntax = VirtualGraphMappingSyntax.get((String)this.mSyntax, (File)this.mMappingsFile);
                    if (syntax == VirtualGraphMappingSyntax.SMS1) {
                        System.err.println("WARNING: Legacy Stardog Mapping Syntax format is no longer supported and will be dropped in a future release");
                    }
                    String mappingsString = this.getMappingsString(syntax, this.mProperties);
                    String ext = com.google.common.io.Files.getFileExtension((String)this.mInputFile.getName());
                    VirtualGraphAdminConnection.InputFileType fileType = "json".equals(ext.toLowerCase()) ? VirtualGraphAdminConnection.InputFileType.JSON : VirtualGraphAdminConnection.InputFileType.DELIMITED;
                    vgConn.importFile(mappingsString, this.mProperties, theConn.name(), Values.iri((String)this.mNamedGraph), this.mInputFile, fileType);
                }
                finally {
                    theConn.rollback();
                }
            } else {
                VirtualGraphMappingSyntax aSyntax = VirtualGraphMappingSyntax.get((String)this.mSyntax, (File)this.mMappingsFile);
                this.mProperties.put("mappings.syntax", aSyntax.toString());
                if (aSyntax == VirtualGraphMappingSyntax.SMS1) {
                    System.err.println("WARNING: Legacy Stardog Mapping Syntax format is no longer supported and will be dropped in a future release");
                }
                String aMappings = "";
                if (this.mMappingsFile != null) {
                    aMappings = Files2.toString((Path)this.mMappingsFile.toPath(), (Charset)Charsets.UTF_8);
                    if (aSyntax != VirtualGraphMappingSyntax.SMS2) {
                        RDFFormat aFormat = CliUtil.getFormat(null, (File)this.mMappingsFile);
                        this.mProperties.put("mappings.format", aFormat.name());
                    }
                }
                VirtualGraphAdminConnection aAdmin = (VirtualGraphAdminConnection)admin.as(VirtualGraphAdminConnection.class);
                aAdmin.importGraph(theConn.name(), this.mDataSource, this.mProperties, aMappings, this.mNamedGraph, this.mRemoveAll);
            }
            long duration = w.elapsed(TimeUnit.MILLISECONDS);
            System.out.printf("Import completed successfully in %s.%n", DurationFormat.LONG.format(duration));
        }
        catch (RDFHandlerException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), StardogException.class);
            throw new CliException((Throwable)e);
        }
        catch (Exception e) {
            Throwables.throwIfInstanceOf((Throwable)e, StardogSecurityException.class);
            if (e instanceof InvalidRDF || e.getCause() instanceof InvalidRDF || e instanceof MalformedQuery || e.getCause() instanceof MalformedQuery || e instanceof ParseException || e.getCause() instanceof ParseException) {
                throw new CliException("Invalid RDF in mappings file' " + this.mMappingsFile.getAbsolutePath() + "'. " + e.getMessage(), (Throwable)e);
            }
            Object errorMsg = "";
            errorMsg = this.mComputeSource != null ? (this.mInputFile != null ? "Error importing file '" + this.mInputFile.getAbsolutePath() + "'. " + e.getMessage() : "Error importing into " + this.mDbName + " for compute source " + this.mComputeSource + ". " + e.getMessage()) : (this.mInputFile != null ? "Error importing file '" + this.mInputFile.getAbsolutePath() + "'. " + e.getMessage() : "Error importing into " + this.mDbName + " for source " + MoreFiles.getNameWithoutExtension((Path)this.mConfigFile.toPath()) + ". " + e.getMessage());
            throw new CliException((String)errorMsg, (Throwable)e);
        }
    }

    private String getMappingsString(VirtualGraphMappingSyntax syntax, Properties properties) throws Exception {
        if (this.mMappingsFile == null) {
            return null;
        }
        switch (syntax) {
            case R2RML: 
            case SMS1: {
                RDFFormat aFormat = CliUtil.getFormat(null, (File)this.mMappingsFile);
                properties.put("mappings.format", aFormat.name());
            }
            case SMS2: {
                properties.put("mappings.syntax", syntax.toString());
                return Files2.toString((Path)this.mMappingsFile.toPath(), (Charset)Charsets.UTF_8);
            }
        }
        properties.put("mappings.syntax", VirtualGraphMappingSyntax.SMS1.toString());
        properties.put("mappings.format", RDFFormats.TURTLE.name());
        RDFFormat aMappingsFormat = CliUtil.getFormat(null, (File)this.mMappingsFile);
        try (FileInputStream aIn = new FileInputStream(this.mMappingsFile);){
            Set aMappingsModel = RDFParsers.read((InputStream)aIn, (RDFFormat)aMappingsFormat, (Options)ParserOptions.baseIRI((String)"tag:stardog:api:"));
            String string = StardogMappings.write((Set)aMappingsModel);
            return string;
        }
    }

    protected String connectionString() {
        this.parseArgs();
        this.verifyArgs();
        if (this.mServerURL == null && this.mDbName != null && this.mDbName.contains("://")) {
            return this.mDbName;
        }
        return this.getServerURL(this.mServerURL) + "/" + this.mDbName;
    }

    private void parseArgs() {
        try {
            if (this.mDbName == null) {
                int count = this.mArgs.size();
                if (count < 2) {
                    throw new CliException("Minimum of two arguments required");
                }
                int i = 0;
                this.mDbName = this.mArgs.get(i++);
                for (String extension : KNOWN_EXTS) {
                    if (!this.mDbName.toLowerCase().endsWith("." + extension)) continue;
                    throw new CliException("First argument must be database name. Found: " + this.mDbName);
                }
                String arg = this.mArgs.get(i);
                if (arg.endsWith(".properties")) {
                    this.mConfigFile = new File(arg);
                    if (!this.mConfigFile.exists()) {
                        throw new CliException("Options file not found: " + this.mConfigFile.getAbsolutePath());
                    }
                    try {
                        Files2.loadProperties((Properties)this.mProperties, (Path)this.mConfigFile.toPath());
                    }
                    catch (RuntimeException e) {
                        throw new CliException("Error reading options file '" + this.mConfigFile.getAbsolutePath() + "'. " + e.getMessage(), (Throwable)e);
                    }
                    ++i;
                }
                if (count - i == 2) {
                    this.mMappingsFile = new File(this.mArgs.get(i++));
                    this.mInputFile = new File(this.mArgs.get(i));
                } else {
                    boolean csvOpt = this.mProperties.entrySet().stream().anyMatch(entry -> ((String)entry.getKey()).startsWith("csv"));
                    if (count - i == 1) {
                        String fileName = this.mArgs.get(i).toLowerCase();
                        boolean dataFileExt = DATA_FILE_EXTS.stream().anyMatch(ext -> fileName.endsWith("." + ext));
                        if (csvOpt || dataFileExt) {
                            this.mInputFile = new File(this.mArgs.get(i));
                        } else {
                            this.mMappingsFile = new File(this.mArgs.get(i));
                        }
                    } else if (csvOpt) {
                        throw new CliException("Not enough arguments CSV import. Must provide input file.");
                    }
                }
            }
            if (this.mComputeSource == null && this.mInputFile == null && this.mConfigFile == null) {
                throw new CliException("Not enough arguments. Must provide database name and at least one of config file and/or input file.");
            }
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e, StardogException.class);
            throw new CliException((Throwable)e);
        }
    }

    private void verifyArgs() {
        if (this.mMappingsFile != null && !this.mMappingsFile.exists()) {
            throw new CliException("Mappings file not found: " + this.mMappingsFile.getAbsolutePath());
        }
        if ((this.mComputeSource == null || this.mComputeSource.isEmpty()) && this.mInputFile != null && !this.mInputFile.exists()) {
            throw new CliException("Input file not found: " + this.mInputFile.getAbsolutePath());
        }
    }
}

