/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.virtual.cli;

import com.complexible.common.io.Files2;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.complexible.stardog.cli.impl.CliUtil;
import com.complexible.stardog.virtual.api.VirtualGraphMappingSyntax;
import com.complexible.stardog.virtual.api.admin.VirtualGraphAdminConnection;
import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.io.MoreFiles;
import com.google.inject.Inject;
import com.stardog.stark.io.RDFFormat;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Properties;

@Command(name="add", description="Registers a new virtual graph.", examples={"* Register a new virtual graph named 'myGraph' with automatically generated (aka direct) mappings", "    $ stardog-admin virtual add myGraph.properties", "", "* Register a new virtual graph with the mappings written in Stardog mappings syntax", "    $ stardog-admin virtual add myGraph.properties myGraph.sms", "", "* Register a new virtual graph using a registered data source", "    $ stardog-admin virtual add --format r2rml --data-source myDataSource myGraph.properties myGraph.ttl", "", "* Register a new virtual graph using a registered data source, omitting the options file", "    $ stardog-admin virtual add --format sms --name myGraph --data-source myDataSource myGraph.sms", "", "* Update an already registered virtual graph with the given mappings", "    $ stardog-admin virtual add --overwrite myGraph.properties myGraph.sms"})
public final class VirtualGraphAdd
extends SecureStardogAdminCommand<Void> {
    @Option(name={"-o", "--overwrite"}, title="overwrite existing", description="If the virtual graph being added already exists, overwrite the existing copy with the new version")
    public boolean mOverwrite = false;
    @Option(name={"-n", "--name"}, title="virtual graph name", description="Optional override of the virtual graph name")
    public String mNameOption;
    @Option(name={"-f", "--format"}, title="mappings format", description="Format of the mappings; one of [R2RML, SMS]. Use this command-line option instead of setting the mappings.syntax option in the options file.")
    public String mSyntax = "DEFAULT";
    @Option(name={"-d", "--database"}, title="db", description="The database the virtual graph will be associated with. By default, '*' will be used which means the virtual graph can be accessed from any database.")
    public String mDb = "*";
    @Option(name={"-s", "--data-source"}, title="data source", description="The data source for this virtual graph. Data sources can be added with stardog-admin data-source commands, and shared between virtual graphs.")
    public String mDataSource;
    @Arguments(title={"[options]", "[mappings]"}, description="The configuration file for the virtual graph and optionally a mappings file. If a --data-source option is not provided then the options argument is required. If the --name option is not provided, the name of the configuration file without the extension will be the name of the virtual graph.")
    public final List<String> mArgs = Lists.newArrayList();
    private String mMappings;
    private Properties mOptions;
    private String mFinalName;

    @Inject
    public VirtualGraphAdd(PasswordReader theReader) {
        super(theReader);
    }

    public void performSecure(AdminConnection theConn) throws StardogException {
        try {
            VirtualGraphAdminConnection aConn = (VirtualGraphAdminConnection)theConn.as(VirtualGraphAdminConnection.class);
            this.parseArguments(this.mDataSource == null);
            if (this.mOverwrite) {
                aConn.updateGraph(this.mFinalName, this.mDataSource, this.mDb, this.mOptions, this.mMappings);
            } else {
                aConn.addGraph(this.mFinalName, this.mDataSource, this.mDb, this.mOptions, this.mMappings);
            }
            System.out.format("Successfully added virtual graph %s%n", this.mFinalName);
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e, StardogException.class);
            throw new CliException((Throwable)e);
        }
    }

    private void parseArguments(boolean propertiesFileRequired) throws IOException {
        if (this.mArgs.size() > 2) {
            throw new IllegalArgumentException("At most two arguments are supported (options, mappings). Found " + this.mArgs.size() + " arguments: " + String.valueOf(this.mArgs));
        }
        this.mOptions = new Properties();
        this.mMappings = "";
        boolean firstArgIsPropsFile = this.isFirstArgPropsFile(propertiesFileRequired);
        File aMappingsFile = null;
        if (firstArgIsPropsFile) {
            this.mOptions.load(Files.newInputStream(Paths.get(this.mArgs.get(0), new String[0]), new OpenOption[0]));
            if (this.mArgs.size() == 2) {
                aMappingsFile = new File(this.mArgs.get(1));
            }
            this.mFinalName = this.mNameOption == null ? MoreFiles.getNameWithoutExtension((Path)Paths.get(this.mArgs.get(0), new String[0])) : this.mNameOption;
        } else {
            if (this.mArgs.size() == 1) {
                aMappingsFile = new File(this.mArgs.get(0));
            }
            if (this.mNameOption == null) {
                throw new IllegalArgumentException("Must provide --name option or options filename argument");
            }
            this.mFinalName = this.mNameOption;
        }
        if (aMappingsFile != null) {
            VirtualGraphMappingSyntax aSyntax = VirtualGraphMappingSyntax.get((String)this.mSyntax, (File)aMappingsFile);
            this.mOptions.put("mappings.syntax", aSyntax.toString());
            if (aSyntax == VirtualGraphMappingSyntax.SMS1) {
                System.err.println("WARNING: Legacy Stardog Mapping Syntax format is no longer supported and will be dropped in a future release");
            }
            if (aSyntax != VirtualGraphMappingSyntax.SMS2) {
                RDFFormat aFormat = CliUtil.getFormat(null, (File)aMappingsFile);
                this.mOptions.put("mappings.format", aFormat.name());
            }
            this.mMappings = Files2.toString((Path)aMappingsFile.toPath(), (Charset)Charsets.UTF_8);
        }
    }

    private boolean isFirstArgPropsFile(boolean propertiesFileRequired) {
        if (propertiesFileRequired) {
            if (this.mArgs.size() == 0) {
                throw new IllegalArgumentException("Missing required options filename.");
            }
            return true;
        }
        switch (this.mArgs.size()) {
            case 0: {
                return false;
            }
            case 1: {
                return this.mArgs.get(0).toLowerCase().endsWith(".properties");
            }
            case 2: {
                return true;
            }
        }
        throw new IllegalArgumentException("Too many arguments");
    }
}

