/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.virtual.cli;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.complexible.stardog.protocols.http.client.BaseHttpClient;
import com.complexible.stardog.virtual.api.admin.VirtualGraphAdminConnection;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Command;

@Command(name="test", description="Test a data source.", examples={"* Test a data source named myDataSource", "    $ stardog-admin data-source test myDataSource"})
public final class DataSourceTest
extends SecureStardogAdminCommand<Void> {
    @Arguments(required=true, description="Name of the data source to test", title={"name"})
    public String mName;

    @Inject
    public DataSourceTest(PasswordReader theReader) {
        super(theReader);
    }

    public void performSecure(AdminConnection theConn) throws StardogException {
        VirtualGraphAdminConnection aConn = (VirtualGraphAdminConnection)theConn.as(VirtualGraphAdminConnection.class);
        try {
            aConn.testDataSource(this.mName);
            System.out.format("Data source %s test was successful%n", this.mName);
        }
        catch (StardogException e) {
            StardogException unwrapped;
            Throwable throwable = unwrapped = e instanceof BaseHttpClient.HttpClientException && e.getCause() != null ? e.getCause() : e;
            if (((Object)((Object)unwrapped)).getClass().equals(StardogException.class)) {
                System.out.format("Data source %s test failed: %s%n", this.mName, e.getMessage());
            }
            throw e;
        }
    }
}

