/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.virtual.cli;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.complexible.stardog.virtual.api.admin.VirtualGraphAdminConnection;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Command;

@Command(name="share", description="Share a private data source.", discussion="When a virtual graph is created without specifying a data source name, a private data source is created for that and only that virtual graph. This command makes such a data source available to other virtual graphs, as well as decouples the data source life cycle from the life cycle of the original virtual graph.", examples={"* Share a data source named myDataSource", "    $ stardog-admin data-source share myDataSource"})
public final class DataSourceShare
extends SecureStardogAdminCommand<Void> {
    @Arguments(required=true, description="Name of the data source to make sharable", title={"name"})
    public String mName;

    @Inject
    public DataSourceShare(PasswordReader theReader) {
        super(theReader);
    }

    public void performSecure(AdminConnection theConn) throws StardogException {
        VirtualGraphAdminConnection aConn = (VirtualGraphAdminConnection)theConn.as(VirtualGraphAdminConnection.class);
        aConn.shareDataSource(this.mName);
        System.out.format("Successfully shared data source %s%n", this.mName);
    }
}

