/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.virtual.cli;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.complexible.stardog.virtual.api.admin.VirtualGraphAdminConnection;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;

@Command(name="remove", description="Removes a registered data source.", examples={"* Remove a registered data source named myDataSource", "    $ stardog-admin data-source remove myDataSource", "", "* Remove a registered data source named myDataSource and all the virtual graphs that use it", "    $ stardog-admin data-source remove --force myDataSource"})
public final class DataSourceRemove
extends SecureStardogAdminCommand<Void> {
    @Option(name={"-f", "--force"}, title="remove virtual graphs", description="Whether to remove any virtual graphs that use the data source")
    public boolean mForce = false;
    @Arguments(required=true, description="Name of the data source to remove", title={"name"})
    public String mName;

    @Inject
    public DataSourceRemove(PasswordReader theReader) {
        super(theReader);
    }

    public void performSecure(AdminConnection theConn) throws StardogException {
        VirtualGraphAdminConnection aConn = (VirtualGraphAdminConnection)theConn.as(VirtualGraphAdminConnection.class);
        boolean aRemoved = aConn.removeDataSource(this.mName, this.mForce);
        if (aRemoved) {
            System.out.format("Successfully removed data source %s%n", this.mName);
        } else {
            System.out.format("Data source does not exist: %s%n", this.mName);
        }
    }
}

