/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.virtual.cli;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.complexible.stardog.virtual.api.admin.VirtualGraphAdminConnection;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import java.util.List;

@Command(name="refresh-metadata", description="Refresh the metadata for one or all tables that are accessible to a data source.", discussion="Refresh the metadata for one or all tables that are accessible to a data source. As a data source is used by virtual graphs, the data source retains (caches) metadata on the tables that are accessed. This metadata includes the set of accessible tables as well as column-level metadata such as column names and types and constraints such as primary and foreign keys. If this metadata changes after a data source has been accessed, it may not be visible to the data source, even after a server restart (though it would be visible to new data sources). Use this command to cause the metadata to be refreshed and all the dependent virtual graphs to be reloaded.", examples={"* Refresh metadata for table myTable in schema mySchema for data source myDataSource", "    $ stardog-admin data-source refresh-metadata myDataSource mySchema.myTable", "", "* Refresh metadata for all tables accessed through myDataSource", "    $ stardog-admin data-source refresh-metadata myDataSource"})
public final class DataSourceRefreshMetadata
extends SecureStardogAdminCommand<Void> {
    @Arguments(title={"name", "[table]"}, required=true, description="The name of the data source and optionally the name of the table to refresh metadata for. If table is not provided, metadata for all tables accessible to the data source are refreshed. Example table formats (case-sensitive): catalog.schema.table, schema.table, table")
    public final List<String> mArgs = Lists.newArrayList();
    public String mName;
    public String mTable;

    @Inject
    public DataSourceRefreshMetadata(PasswordReader theReader) {
        super(theReader);
    }

    public void performSecure(AdminConnection theConn) throws StardogException {
        this.parseArguments();
        VirtualGraphAdminConnection aConn = (VirtualGraphAdminConnection)theConn.as(VirtualGraphAdminConnection.class);
        aConn.refreshMetadata(this.mName, this.mTable);
        if (this.mTable == null) {
            System.out.format("Successfully refreshed metadata for all tables accessible to data source %s%n", this.mName);
        } else {
            System.out.format("Successfully refreshed metadata for table %s from data source %s%n", this.mTable, this.mName);
        }
    }

    private void parseArguments() {
        if (this.mArgs.size() < 1) {
            throw new IllegalArgumentException("Data source name argument missing");
        }
        if (this.mArgs.size() > 2) {
            throw new IllegalArgumentException("At most two arguments are supported (name, table). Found " + this.mArgs.size() + " arguments: " + String.valueOf(this.mArgs));
        }
        this.mName = this.mArgs.get(0);
        this.mTable = this.mArgs.size() == 2 ? this.mArgs.get(1) : null;
    }
}

