/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.virtual.cli;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.complexible.stardog.virtual.api.admin.VirtualGraphAdminConnection;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import java.util.List;

@Command(name="refresh-counts", description="Refresh the row-count estimates for one or all tables that are accessible to a data source.", discussion="Refresh the row-count estimates for one or all tables that are accessible to a data source. When a virtual graph is loaded, it queries the data source for approximate table and index sizes. If the size of one or more tables change after the virtual graph is loaded, these estimates become stale, potentially leading to suboptimal query plans. Use this command to refresh these estimates.", examples={"* Refresh counts for table myTable in schema mySchema for data source myDataSource", "    $ stardog-admin data-source refresh-counts myDataSource mySchema.myTable", "", "* Refresh counts for all tables accessed through myDataSource", "    $ stardog-admin data-source refresh-counts myDataSource"})
public final class DataSourceRefreshCounts
extends SecureStardogAdminCommand<Void> {
    @Arguments(title={"name", "[table]"}, description="The name of the data source and optionally the name of the table to refresh counts for. If table is not provided, estimates for all tables accessible to the data source are refreshed. Example table formats (case-sensitive): catalog.schema.table, schema.table, table")
    public final List<String> mArgs = Lists.newArrayList();
    public String mName;
    public String mTable;

    @Inject
    public DataSourceRefreshCounts(PasswordReader theReader) {
        super(theReader);
    }

    public void performSecure(AdminConnection theConn) throws StardogException {
        this.parseArguments();
        VirtualGraphAdminConnection aConn = (VirtualGraphAdminConnection)theConn.as(VirtualGraphAdminConnection.class);
        aConn.refreshCounts(this.mName, this.mTable);
        if (this.mTable == null) {
            System.out.format("Successfully refreshed counts for all tables accessible to data source %s%n", this.mName);
        } else {
            System.out.format("Successfully refreshed counts for table %s from data source %s%n", this.mTable, this.mName);
        }
    }

    private void parseArguments() {
        if (this.mArgs.size() < 1) {
            throw new IllegalArgumentException("Data source name argument missing");
        }
        if (this.mArgs.size() > 2) {
            throw new IllegalArgumentException("At most two arguments are supported (name, table). Found " + this.mArgs.size() + " arguments: " + String.valueOf(this.mArgs));
        }
        this.mName = this.mArgs.get(0);
        this.mTable = this.mArgs.size() == 2 ? this.mArgs.get(1) : null;
    }
}

