/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.virtual.cli;

import com.brsanthu.dataexporter.output.csv.CsvExportOptions;
import com.brsanthu.dataexporter.output.csv.CsvExporter;
import com.complexible.common.dataexporter.TextTabularOutput;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.complexible.stardog.virtual.api.DataSourceQueryResult;
import com.complexible.stardog.virtual.api.admin.VirtualGraphAdminConnection;
import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

@Command(name="query", description="Query data sources.", discussion="Query data sources. This service is provided as a convenience to examine the contents of a data source while creating a virtual graph. This service is intended for lightweight exploratory queries and it is recommended to include a limit in the query to avoid large result sets. The service may impose a limit on the number of results returned to minimize resource usage.", examples={"* Query a data source", "    $ stardog-admin data-source query myDataSource 'select * from sales'", "", "* Query a data source supplying the query from a file", "    $ stardog-admin data-source query myDataSource query.sql"})
public class DataSourceQuery
extends SecureStardogAdminCommand<Void> {
    @Option(description="Display format as TABLE, CSV, or TSV, Default: TABLE", name={"-f", "--format"}, title="format")
    public String mDisplay = "TABLE";
    @Option(description="Path for a file to write the query results.", name={"--output"}, title="output")
    public String mOutputPath = "";
    @Option(description="Timeout for the query in ms. An optional time unit can be specified by the suffix 'h' (for hours), 'm' (for minutes), or 's' (for seconds). Timeout value of 0 results in no timeout.", name={"--timeout"}, title="N[h|m|s]")
    public String mTimeout = "0";
    @Option(description="Use double quote for identifier quoting. Defaults to using native identifier quoting character.", name={"--ANSI"}, title="ANSI")
    public boolean mAnsi = false;
    @Arguments(required=true, description="Name of the data source to query. The final argument is the query, which can be a string or the name of a file that contains query strings.", title={"name", "query"})
    public List<String> mArgs;

    @Inject
    public DataSourceQuery(PasswordReader theReader) {
        super(theReader);
    }

    public void performSecure(AdminConnection theConn) throws Exception {
        ArrayList<String> aQueries = new ArrayList<String>();
        String aQueryArg = "";
        String aDatasourceArg = "";
        VirtualGraphAdminConnection aConn = (VirtualGraphAdminConnection)theConn.as(VirtualGraphAdminConnection.class);
        if (this.mArgs != null && !this.mArgs.isEmpty()) {
            aDatasourceArg = this.mArgs.get(0);
            aQueryArg = this.mArgs.get(1);
        }
        boolean aIsFile = new File(aQueryArg).exists();
        File aFile = new File(aQueryArg);
        if (aIsFile && aFile.exists()) {
            InputStreamReader aStream = new InputStreamReader((InputStream)new FileInputStream(aFile), Charsets.UTF_8);
            String aInput = CharStreams.toString((Readable)aStream);
            aQueries.addAll(Arrays.asList(aInput.split(";\n")));
        } else {
            aQueries.addAll(Arrays.asList(this.mArgs.get(1).split(";\n")));
        }
        Properties aOptions = new Properties();
        if (this.mAnsi) {
            aOptions.put("parser.sql.quoting", "ANSI");
        }
        for (String aQuery : aQueries) {
            DataSourceQueryResult aResults = aConn.queryDataSource(aDatasourceArg, aQuery, this.mTimeout, aOptions);
            if (aResults == null) continue;
            OutputStream aOutputStream = this.mOutputPath.isEmpty() ? System.out : new FileOutputStream(this.mOutputPath);
            switch (this.mDisplay) {
                case "CSV": {
                    this.outputDelimited(aResults, ",", aOutputStream);
                    break;
                }
                case "TSV": {
                    this.outputDelimited(aResults, "\t", aOutputStream);
                    break;
                }
                case "TABLE": {
                    this.outputTable(aResults, aOutputStream);
                    break;
                }
                default: {
                    System.out.format("Incorrect display format specified: %s. Options are TABLE, CSV, TSV.", this.mDisplay);
                }
            }
            System.out.println();
        }
    }

    private void outputDelimited(DataSourceQueryResult theResults, String theDelimiter, OutputStream theOutputStream) {
        CsvExportOptions aOptions = new CsvExportOptions();
        aOptions.setDelimiter(theDelimiter);
        aOptions.setStrictQuoting(true);
        CsvExporter aCsvExporter = new CsvExporter(aOptions, theOutputStream);
        aCsvExporter.addColumn(this.getColumnNameArray(theResults));
        int aRowCount = theResults.getRowCount();
        for (int i = 0; i < aRowCount; ++i) {
            aCsvExporter.addRow(this.getRowValueArray(theResults, i));
        }
        aCsvExporter.finishExporting();
    }

    private void outputTable(DataSourceQueryResult theResults, OutputStream theOutputStream) {
        TextTabularOutput aOutput = new TextTabularOutput(theOutputStream, this.getColumnNameArray(theResults));
        int aRowCount = theResults.getRowCount();
        for (int i = 0; i < aRowCount; ++i) {
            aOutput.addRow(this.getRowValueArray(theResults, i));
        }
        aOutput.output();
    }

    private String[] getColumnNameArray(DataSourceQueryResult theResults) {
        if (theResults == null) {
            return new String[0];
        }
        int aColumnCount = theResults.getColumnCount();
        String[] aCols = new String[aColumnCount];
        for (int i = 0; i < aColumnCount; ++i) {
            String colName = theResults.getColumnName(i);
            aCols[i] = colName.isEmpty() ? " " : colName;
        }
        return aCols;
    }

    private Object[] getRowValueArray(DataSourceQueryResult theResults, int theRowOrder) {
        if (theResults == null) {
            return new Object[0];
        }
        int aColumnCount = theResults.getColumnCount();
        Object[] aVals = new String[aColumnCount];
        for (int i = 0; i < aColumnCount; ++i) {
            aVals[i] = theResults.getValue(theRowOrder, i);
        }
        return aVals;
    }
}

