/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.virtual.cli;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.complexible.stardog.virtual.api.admin.DataSourceInfo;
import com.complexible.stardog.virtual.api.admin.VirtualGraphAdminConnection;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Command;

@Command(name="online", description="Online a data source.", discussion="Online a data source. When Stardog restarts, data sources that cannot be loaded will be listed (stardog-admin data-source list) as offline. Use this command to retry loading an offline data source. If successful, all virtual graphs that use the data source will be brought online as well.", examples={"* Online a data source named myDataSource", "    $ stardog-admin data-source online myDataSource"})
public final class DataSourceOnline
extends SecureStardogAdminCommand<Void> {
    @Arguments(required=true, description="Name of the data source to online", title={"name"})
    public String mName;

    @Inject
    public DataSourceOnline(PasswordReader theReader) {
        super(theReader);
    }

    public void performSecure(AdminConnection theConn) throws StardogException {
        VirtualGraphAdminConnection aConn = (VirtualGraphAdminConnection)theConn.as(VirtualGraphAdminConnection.class);
        aConn.onlineDataSource(this.mName);
        DataSourceInfo info = aConn.getDataSourceInfo(this.mName);
        if (info.isAvailable()) {
            System.out.format("Successfully brought online data source %s%n", this.mName);
        } else {
            System.out.format("Failed to bring online data source %s%n", this.mName);
        }
    }
}

