/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.virtual.cli;

import com.complexible.common.dataexporter.TextTabularOutput;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.complexible.stardog.virtual.api.admin.VirtualGraphAdminConnection;
import com.google.inject.Inject;
import io.airlift.command.Command;
import java.io.OutputStream;
import java.util.Collection;

@Command(name="list", description="Lists registered data sources.", examples={"* Lists all shared data sources", "    $ stardog-admin data-source list"})
public final class DataSourceList
extends SecureStardogAdminCommand<Void> {
    @Inject
    public DataSourceList(PasswordReader theReader) {
        super(theReader);
    }

    public void performSecure(AdminConnection theConn) throws StardogException {
        Collection sources = ((VirtualGraphAdminConnection)theConn.as(VirtualGraphAdminConnection.class)).getDataSourceInfos();
        if (!sources.isEmpty()) {
            TextTabularOutput aTable = new TextTabularOutput((OutputStream)System.out, new String[]{"Data Source", "Shared", "Online", "Type"});
            sources.forEach(ds -> aTable.addRow(new Object[]{ds.getEntityName(), ds.isSharable(), ds.isAvailable(), ds.getType()}));
            aTable.output();
            System.out.println();
        }
        System.out.format("%d data sources%n", sources.size());
    }
}

