/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.virtual.cli;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.complexible.stardog.virtual.api.admin.VirtualGraphAdminConnection;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.io.MoreFiles;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Properties;

@Command(name="add", description="Registers a new data source.", examples={"* Register a new data source named 'myDataSource', taking the name from the name of the properties file", "    $ stardog-admin data-source add myDataSource.properties", "", "* Register a new data source named 'myDataSource', providing the name as an option", "    $ stardog-admin data-source add --name myDataSource myProperties.properties", "", "* Update an existing data source that has no dependent virtual graphs", "    $ stardog-admin data-source add --overwrite myDataSource.properties", "", "* Update an existing data source, refreshing all the dependent virtual graphs", "    $ stardog-admin data-source add --overwrite --force myDataSource.properties"})
public final class DataSourceAdd
extends SecureStardogAdminCommand<Void> {
    @Option(name={"-o", "--overwrite"}, title="overwrite existing", description="If the data source being added already exists, overwrite the existing copy with the new version")
    public boolean mOverwrite = false;
    @Option(name={"-n", "--name"}, title="data source name", description="Optional override of the data source name")
    public String mName;
    @Option(name={"-f", "--force"}, title="reload dependent virtual graphs", description="Whether to proceed if this data source has dependent virtual graphs")
    public boolean mForce = false;
    @Arguments(required=true, description="The configuration file for the data source. If no --name option is provided, the name of the configuration file without the extension will be the name of the data source.", title={"options"})
    public final List<String> mArgs = Lists.newArrayList();

    @Inject
    public DataSourceAdd(PasswordReader theReader) {
        super(theReader);
    }

    public void performSecure(AdminConnection theConn) throws StardogException {
        try {
            String aName;
            VirtualGraphAdminConnection aConn = (VirtualGraphAdminConnection)theConn.as(VirtualGraphAdminConnection.class);
            Path aPropsFile = Paths.get(this.mArgs.get(0), new String[0]);
            Properties aProps = new Properties();
            aProps.load(Files.newInputStream(aPropsFile, new OpenOption[0]));
            String string = aName = this.mName == null ? MoreFiles.getNameWithoutExtension((Path)aPropsFile) : this.mName;
            if (this.mOverwrite) {
                aConn.updateDataSource(aName, aProps, this.mForce);
            } else {
                aConn.addDataSource(aName, aProps);
            }
            System.out.format("Successfully added data source %s%n", aName);
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e, StardogException.class);
            throw new CliException((Throwable)e);
        }
    }
}

