/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.query.impl;

import com.stardog.stark.Value;
import com.stardog.stark.query.Binding;
import com.stardog.stark.query.BindingSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class BindingSetImpl
implements BindingSet {
    private final Map<String, Binding> mBindings;
    private final Set<String> mVariables;

    public BindingSetImpl(Map<String, Binding> theBindings, Set<String> theVars) {
        this.mBindings = theBindings;
        this.mVariables = theVars;
    }

    @Override
    @Nonnull
    public Set<String> variables() {
        return this.mVariables;
    }

    @Override
    public int size() {
        return this.mBindings.size();
    }

    @Override
    @Nonnull
    public Optional<Value> value(@Nonnull String theVar) {
        return Optional.ofNullable(this.mBindings.get(theVar)).map(Binding::value);
    }

    @Override
    public Value get(@Nonnull String theVar) {
        Binding aBinding = this.mBindings.get(theVar);
        return aBinding != null ? aBinding.get() : null;
    }

    @Override
    public boolean binds(@Nonnull String theVar) {
        return this.mBindings.containsKey(theVar);
    }

    @Override
    @Nonnull
    public Optional<Binding> binding(@Nonnull String theVar) {
        return Optional.ofNullable(this.mBindings.get(theVar));
    }

    @Override
    @Nonnull
    public Iterator<Binding> iterator() {
        return this.mBindings.values().iterator();
    }

    public String toString() {
        return this.mBindings.values().stream().map(Object::toString).collect(Collectors.joining(", ", "[", "]"));
    }

    public boolean equals(Object theObj) {
        if (this == theObj) {
            return true;
        }
        if (theObj == null || !(theObj instanceof BindingSet)) {
            return false;
        }
        BindingSet aBindings = (BindingSet)theObj;
        if (this.size() != aBindings.size()) {
            return false;
        }
        for (Binding aBinding : aBindings) {
            if (aBinding.value().equals((Object)this.get(aBinding.name()))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 0;
        for (Binding binding : this) {
            hashCode ^= binding.name().hashCode() ^ binding.value().hashCode();
        }
        return hashCode;
    }
}

