/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.query.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.stardog.stark.Datatype;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.query.Dataset;
import com.stardog.stark.query.Datasets;
import com.stardog.stark.query.Query;
import com.stardog.stark.query.QueryLanguage;
import java.net.URI;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public abstract class AbstractQuery
implements Query {
    private final String mQuery;
    private final QueryLanguage mQueryLanguage;
    private final String mBaseIRI;
    protected final Map<String, Value> mParameters = Maps.newHashMap();
    protected boolean mReasoning = false;
    protected long mTimeout = -1L;
    protected Dataset mDataset = Datasets.NO_DATASET;

    public AbstractQuery(@Nonnull String theQuery, @Nonnull QueryLanguage theQueryLanguage) {
        this(theQuery, "tag:stardog:api:", theQueryLanguage);
    }

    public AbstractQuery(@Nonnull String theQuery, @Nonnull String theBaseIRI, @Nonnull QueryLanguage theQueryLanguage) {
        this.mQuery = theQuery;
        this.mBaseIRI = theBaseIRI;
        this.mQueryLanguage = theQueryLanguage;
    }

    @Override
    @Nonnull
    public String baseIRI() {
        return this.mBaseIRI;
    }

    @Override
    @Nonnull
    public String string() {
        return this.mQuery;
    }

    @Override
    @Nonnull
    public QueryLanguage language() {
        return this.mQueryLanguage;
    }

    @Override
    @Nonnull
    public Dataset dataset() {
        return this.mDataset;
    }

    @Override
    @Nonnull
    public Query dataset(@Nonnull Dataset theDataset) {
        this.mDataset = theDataset;
        return this;
    }

    @Override
    @Nonnull
    public Map<String, Value> parameters() {
        return ImmutableMap.copyOf(this.mParameters);
    }

    @Override
    public boolean reasoning() {
        return this.mReasoning;
    }

    @Override
    @Nonnull
    public Query reasoning(boolean theEnabled) {
        this.mReasoning = theEnabled;
        return this;
    }

    @Override
    @Nonnull
    public Query removeParameter(@Nonnull String theName) {
        this.mParameters.remove(theName);
        return this;
    }

    @Override
    public long timeout() {
        return this.mTimeout;
    }

    @Override
    @Nonnull
    public Query timeout(long theTimeout, @Nonnull TimeUnit theUnit) {
        this.mTimeout = theUnit.toMillis(theTimeout);
        return this;
    }

    @Override
    @Nonnull
    public Query parameter(@Nonnull String theName, @Nonnull Object theObj) {
        if (theObj instanceof Value) {
            return this.parameter(theName, (Value)theObj);
        }
        if (theObj instanceof Boolean) {
            return this.parameter(theName, (Boolean)theObj);
        }
        if (theObj instanceof Long) {
            return this.parameter(theName, (Long)theObj);
        }
        if (theObj instanceof Integer) {
            return this.parameter(theName, (Value)Values.literal((Number)((Integer)theObj)));
        }
        if (theObj instanceof Float) {
            return this.parameter(theName, ((Float)theObj).floatValue());
        }
        if (theObj instanceof Double) {
            return this.parameter(theName, (Double)theObj);
        }
        if (theObj instanceof Short) {
            return this.parameter(theName, (Short)theObj);
        }
        if (theObj instanceof Date) {
            return this.parameter(theName, (Date)theObj);
        }
        if (theObj instanceof Byte) {
            return this.parameter(theName, (Byte)theObj);
        }
        if (theObj instanceof GregorianCalendar) {
            return this.parameter(theName, (GregorianCalendar)theObj);
        }
        if (theObj instanceof URI) {
            return this.parameter(theName, (URI)theObj);
        }
        if (theObj instanceof String) {
            return this.parameter(theName, (String)theObj);
        }
        throw new IllegalArgumentException(String.valueOf(theObj) + " is an unsupported parameter type");
    }

    @Override
    @Nonnull
    public Query parameter(@Nonnull String theName, @Nonnull Value theValue) {
        this.mParameters.put(theName, theValue);
        return this;
    }

    @Override
    @Nonnull
    public Query parameter(@Nonnull String theName, @Nonnull URI theValue) {
        return this.parameter(theName, (Value)Values.literal((String)theValue.toASCIIString(), (Datatype)Datatype.ANYURI));
    }

    @Override
    @Nonnull
    public Query parameter(@Nonnull String theName, int theValue) {
        return this.parameter(theName, (Value)Values.literal((int)theValue));
    }

    @Override
    @Nonnull
    public Query parameter(@Nonnull String theName, long theValue) {
        return this.parameter(theName, (Value)Values.literal((long)theValue));
    }

    @Override
    @Nonnull
    public Query parameter(@Nonnull String theName, float theValue) {
        return this.parameter(theName, (Value)Values.literal((float)theValue));
    }

    @Override
    @Nonnull
    public Query parameter(@Nonnull String theName, double theValue) {
        return this.parameter(theName, (Value)Values.literal((double)theValue));
    }

    @Override
    @Nonnull
    public Query parameter(@Nonnull String theName, short theValue) {
        return this.parameter(theName, (Value)Values.literal((short)theValue));
    }

    @Override
    @Nonnull
    public Query parameter(@Nonnull String theName, boolean theValue) {
        return this.parameter(theName, (Value)Values.literal((boolean)theValue));
    }

    @Override
    @Nonnull
    public Query parameter(@Nonnull String theName, byte theValue) {
        return this.parameter(theName, (Value)Values.literal((byte)theValue));
    }

    @Override
    @Nonnull
    public Query parameter(@Nonnull String theName, @Nonnull String theValue) {
        return this.parameter(theName, (Value)Values.literal((String)theValue));
    }

    @Override
    @Nonnull
    public Query parameter(@Nonnull String theName, @Nonnull Date theValue) {
        return this.parameter(theName, (Value)Values.literal((Date)theValue));
    }

    @Override
    @Nonnull
    public Query parameter(@Nonnull String theName, @Nonnull GregorianCalendar theValue) {
        return this.parameter(theName, (Value)Values.literal((GregorianCalendar)theValue));
    }
}

