/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.query;

import com.google.common.collect.ImmutableSet;
import com.stardog.stark.IRI;
import com.stardog.stark.Resource;
import com.stardog.stark.Values;
import com.stardog.stark.query.Dataset;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nonnull;

public final class Datasets {
    public static final Dataset NO_DATASET = DatasetImpl.builder().build();
    public static final Dataset EMPTY = DatasetImpl.builder().build();
    public static final Dataset DEFAULT = DatasetImpl.builder().defaultGraphs((Resource)Values.DEFAULT_GRAPH, new Resource[0]).namedGraphs((Resource)Values.NAMED_GRAPHS, new Resource[0]).build();
    public static final Dataset ALL_LOCAL = DatasetImpl.builder().defaultGraphs((Resource)Values.LOCAL_GRAPHS, new Resource[0]).namedGraphs((Resource)Values.NAMED_GRAPHS, new Resource[0]).build();

    public static Dataset of(IRI theIRI, IRI ... theRest) {
        return DatasetImpl.builder().defaultGraphs((Resource)theIRI, (Resource[])theRest).build();
    }

    public static Dataset of(Iterable<IRI> theGraphs) {
        return DatasetImpl.builder().defaultGraphs(theGraphs).build();
    }

    public static Dataset ofNamed(IRI theIRI, IRI ... theRest) {
        return DatasetImpl.builder().namedGraphs((Resource)theIRI, (Resource[])theRest).build();
    }

    public static Dataset ofNamed(Iterable<IRI> theGraphs) {
        return DatasetImpl.builder().namedGraphs(theGraphs).build();
    }

    public static DatasetImpl.Builder builder() {
        return DatasetImpl.builder();
    }

    private Datasets() {
        throw new AssertionError();
    }

    public static final class DatasetImpl
    implements Dataset {
        private final ImmutableSet<Resource> mRemoveGraphs;
        private final ImmutableSet<Resource> mDefaultGraphs;
        private final ImmutableSet<Resource> mExcluded;
        private final ImmutableSet<Resource> mNamedGraphs;
        private final Resource mInsertGraph;

        private DatasetImpl(ImmutableSet<Resource> theDefaultGraphs, ImmutableSet<Resource> theNamedGraphs, Resource theInsertGraph, ImmutableSet<Resource> theRemoveGraphs, ImmutableSet<Resource> theExcluded) {
            this.mDefaultGraphs = theDefaultGraphs;
            this.mNamedGraphs = theNamedGraphs;
            this.mInsertGraph = theInsertGraph;
            this.mRemoveGraphs = theRemoveGraphs;
            this.mExcluded = theExcluded;
        }

        @Override
        @Nonnull
        public ImmutableSet<Resource> defaultRemoveGraphs() {
            return this.mRemoveGraphs;
        }

        @Override
        @Nonnull
        public Optional<Resource> defaultInsertGraph() {
            return Optional.ofNullable(this.mInsertGraph);
        }

        @Override
        @Nonnull
        public ImmutableSet<Resource> defaultGraphs() {
            return this.mDefaultGraphs;
        }

        @Override
        @Nonnull
        public ImmutableSet<Resource> namedGraphs() {
            return this.mNamedGraphs;
        }

        @Override
        @Nonnull
        public ImmutableSet<Resource> excludedGraphs() {
            return this.mExcluded;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private final ImmutableSet.Builder<Resource> mRemoveGraphs = ImmutableSet.builder();
            private final ImmutableSet.Builder<Resource> mDefaultGraphs = ImmutableSet.builder();
            private final ImmutableSet.Builder<Resource> mNamedGraphs = ImmutableSet.builder();
            private ImmutableSet.Builder<Resource> mExcluded = null;
            private Resource mInsertGraph = null;

            @Nonnull
            public Builder defaultRemoveGraphs(@Nonnull Resource theRemoveGraph, Resource ... theOtherGraphs) {
                this.mRemoveGraphs.add((Object)theRemoveGraph);
                this.mRemoveGraphs.addAll(Arrays.asList(theOtherGraphs));
                return this;
            }

            @Nonnull
            public Builder defaultRemoveGraphs(@Nonnull Iterable<? extends Resource> theRemoveGraphs) {
                this.mRemoveGraphs.addAll(theRemoveGraphs);
                return this;
            }

            @Nonnull
            public Builder insertGraph(@Nonnull Resource theGraph) {
                this.mInsertGraph = theGraph;
                return this;
            }

            @Nonnull
            public Builder defaultGraphs(@Nonnull Resource theGraph, Resource ... theOtherGraphs) {
                this.mDefaultGraphs.add((Object)theGraph);
                this.mDefaultGraphs.addAll(Arrays.asList(theOtherGraphs));
                return this;
            }

            @Nonnull
            public Builder defaultGraphs(@Nonnull Iterable<? extends Resource> theGraphs) {
                this.mDefaultGraphs.addAll(theGraphs);
                return this;
            }

            @Nonnull
            public Builder namedGraphs(@Nonnull Resource theGraph, Resource ... theOtherGraphs) {
                this.mNamedGraphs.add((Object)theGraph);
                this.mNamedGraphs.addAll(Arrays.asList(theOtherGraphs));
                return this;
            }

            @Nonnull
            public Builder namedGraphs(@Nonnull Iterable<? extends Resource> theGraphs) {
                this.mNamedGraphs.addAll(theGraphs);
                return this;
            }

            public Builder excludeGraphs(@Nonnull Iterable<? extends Resource> theGraphs) {
                theGraphs.forEach(this::exclude);
                return this;
            }

            public Builder exclude(@Nonnull Resource graph) {
                if (this.mExcluded == null) {
                    this.mExcluded = ImmutableSet.builder();
                }
                this.mExcluded.add((Object)graph);
                return this;
            }

            @Nonnull
            public Dataset build() {
                return new DatasetImpl((ImmutableSet<Resource>)this.mDefaultGraphs.build(), (ImmutableSet<Resource>)this.mNamedGraphs.build(), this.mInsertGraph, (ImmutableSet<Resource>)this.mRemoveGraphs.build(), (ImmutableSet<Resource>)(this.mExcluded == null ? ImmutableSet.of() : this.mExcluded.build()));
            }
        }
    }
}

