/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.query;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.stardog.stark.IRI;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.query.Binding;
import com.stardog.stark.query.BindingSet;
import com.stardog.stark.query.Bindings;
import com.stardog.stark.query.impl.BindingImpl;
import com.stardog.stark.query.impl.BindingSetImpl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class BindingSets {
    private static final BindingSet EMPTY = BindingSets.builder().build();

    @Nonnull
    public static BindingSet empty() {
        return EMPTY;
    }

    @Nonnull
    public static BindingSet union(@Nonnull BindingSet theBindings1, @Nonnull BindingSet theBindings2) {
        Sets.SetView mNames = Sets.union(theBindings1.variables(), theBindings2.variables());
        return new BindingSet(){
            final /* synthetic */ Set val$mNames;
            final /* synthetic */ BindingSet val$theBindings1;
            final /* synthetic */ BindingSet val$theBindings2;
            {
                this.val$mNames = set;
                this.val$theBindings1 = bindingSet;
                this.val$theBindings2 = bindingSet2;
            }

            @Override
            @Nonnull
            public Iterator<Binding> iterator() {
                return this.val$mNames.stream().map(this::binding).map(Optional::get).iterator();
            }

            @Override
            @Nonnull
            public Set<String> variables() {
                return this.val$mNames;
            }

            @Override
            @Nonnull
            public Optional<Binding> binding(@Nonnull String bindingName) {
                Optional<Binding> aResult = this.val$theBindings1.binding(bindingName);
                return !aResult.isPresent() ? this.val$theBindings2.binding(bindingName) : aResult;
            }

            @Override
            public boolean binds(@Nonnull String bindingName) {
                return this.val$theBindings1.binds(bindingName) || this.val$theBindings2.binds(bindingName);
            }

            @Override
            @Nonnull
            public Optional<Value> value(@Nonnull String bindingName) {
                Optional<Value> aResult = this.val$theBindings1.value(bindingName);
                return !aResult.isPresent() ? this.val$theBindings2.value(bindingName) : aResult;
            }

            @Override
            @Nullable
            public Value get(@Nonnull String theVar) {
                return this.value(theVar).orElse(null);
            }

            @Override
            public int size() {
                return this.val$mNames.size();
            }
        };
    }

    public static Function<BindingSet, Statement> toStatement() {
        return bs -> Values.statement((Resource)bs.resource("s").get(), (IRI)bs.iri("p").get(), (Value)bs.value("o").get(), (Resource)bs.resource("g").orElse(null));
    }

    @Nonnull
    public static BindingSet of(@Nonnull Binding theBinding, Binding ... theOtherBindings) {
        return BindingSets.builder().add(theBinding).addAll(theOtherBindings).build();
    }

    @Nonnull
    public static BindingSet of(@Nonnull String theVar, @Nonnull Value theValue) {
        return BindingSets.of(Bindings.of(theVar, theValue), new Binding[0]);
    }

    @Nonnull
    public static Function<BindingSet, Value> select(@Nonnull String theVar) {
        return b -> b.value(theVar).orElse(null);
    }

    public static boolean compatible(@Nonnull BindingSet bs1, @Nonnull BindingSet bs2) {
        for (String aName : Sets.intersection(bs1.variables(), bs2.variables())) {
            Value aOtherValue;
            Value aValue = bs1.value(aName).orElse(null);
            if (Objects.equals(aValue, aOtherValue = (Value)bs2.value(aName).orElse(null))) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    private BindingSets() {
        throw new AssertionError();
    }

    public static final class Builder {
        private Map<String, Binding> mBindings = new HashMap<String, Binding>();
        private Set<String> mVars = new HashSet<String>();

        @Nonnull
        public Builder vars(String ... theVars) {
            return this.vars(Sets.newHashSet((Object[])theVars));
        }

        @Nonnull
        public Builder vars(@Nonnull Set<String> theVars) {
            this.mVars = theVars;
            return this;
        }

        @Nonnull
        public Builder add(@Nonnull String theVar, Value theValue) {
            Preconditions.checkNotNull((Object)theVar, (Object)"Variable cannot be null");
            if (theValue == null) {
                return this;
            }
            return this.add(new BindingImpl(theVar, theValue));
        }

        @Nonnull
        public Builder addAll(Binding ... theBindings) {
            Stream.of(theBindings).forEach(b -> this.mBindings.put(b.name(), (Binding)b));
            return this;
        }

        @Nonnull
        public Builder add(Binding theBinding) {
            return this.addAll(theBinding);
        }

        @Nonnull
        public Optional<Value> value(@Nonnull String theVar) {
            return Optional.ofNullable(this.mBindings.get(theVar)).map(Binding::value);
        }

        @Nonnull
        public BindingSet build() {
            if (this.mVars == null || this.mVars.isEmpty()) {
                this.mVars = this.mBindings.keySet();
            }
            return new BindingSetImpl(this.mBindings, this.mVars);
        }
    }
}

