/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.protobuf.io;

import com.complexible.common.protobuf.io.ProtobufReader;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public final class InputStreamRawProtobufReader<T extends MessageLite>
implements ProtobufReader<T> {
    private final InputStream mStream;
    private final ExtensionRegistry mExtensionRegistry;
    private final T mPrototype;

    public InputStreamRawProtobufReader(InputStream theStream, T thePrototype) {
        this(theStream, thePrototype, null);
    }

    public InputStreamRawProtobufReader(InputStream theStream, T thePrototype, ExtensionRegistry theExtensionRegistry) {
        this.mStream = theStream;
        this.mPrototype = thePrototype;
        this.mExtensionRegistry = theExtensionRegistry;
    }

    @Override
    public T read() throws InvalidProtocolBufferException, IOException {
        try {
            MessageLite.Builder aBuilder = this.mPrototype.newBuilderForType();
            if (this.mExtensionRegistry == null) {
                return (T)(aBuilder.mergeDelimitedFrom(this.mStream) ? aBuilder.build() : null);
            }
            return (T)(aBuilder.mergeDelimitedFrom(this.mStream, (ExtensionRegistryLite)this.mExtensionRegistry) ? aBuilder.build() : null);
        }
        catch (EOFException e) {
            return null;
        }
    }
}

