/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.protobuf.core;

import com.complexible.common.protobuf.core.Core;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.protobuf.ByteString;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;

public final class Cores {
    private Cores() {
        throw new AssertionError();
    }

    public static Core.UID uid() {
        return Cores.uid(UUID.randomUUID());
    }

    public static Core.UID uid(UUID theId) {
        return Core.UID.newBuilder().setMostSigBits(theId.getMostSignificantBits()).setLeastSigBits(theId.getLeastSignificantBits()).build();
    }

    public static Core.StringMap setProperty(Core.StringMap theMap, String theKey, String theValue) {
        Core.StringMapEntry aNewEntry = Core.StringMapEntry.newBuilder().setKey(theKey).setValue(theValue).build();
        int i = 0;
        for (Core.StringMapEntry aEntry : theMap.getValuesList()) {
            if (aEntry.getKey().equals(theKey)) {
                return theMap.toBuilder().setValues(i, aNewEntry).build();
            }
            ++i;
        }
        return theMap.toBuilder().addValues(aNewEntry).build();
    }

    public static Core.StringMap removeProperty(Core.StringMap theMap, String theKey) {
        int i = 0;
        for (Core.StringMapEntry aEntry : theMap.getValuesList()) {
            if (aEntry.getKey().equals(theKey)) {
                return theMap.toBuilder().removeValues(i).build();
            }
            ++i;
        }
        return theMap;
    }

    public static String getProperty(Core.StringMap theMap, String theKey, String theDefault) {
        for (Core.StringMapEntry aEntry : theMap.getValuesList()) {
            if (!aEntry.getKey().equals(theKey)) continue;
            return aEntry.getValue();
        }
        return theDefault;
    }

    public static boolean getProperty(Core.StringMap theMap, String theKey, boolean theDefault) {
        for (Core.StringMapEntry aEntry : theMap.getValuesList()) {
            if (!aEntry.getKey().equals(theKey)) continue;
            return Boolean.getBoolean(aEntry.getValue());
        }
        return theDefault;
    }

    public static ByteString toByteString(String theString) {
        return ByteString.copyFromUtf8((String)theString);
    }

    public static ByteString toByteString(char[] theCharArray) {
        ByteBuffer aEncode = Charsets.UTF_8.encode(CharBuffer.wrap(theCharArray));
        byte[] aBytes = new byte[aEncode.limit()];
        aEncode.get(aBytes);
        return ByteString.copyFrom((byte[])aBytes);
    }

    public static Core.StringMap toStringMap(Properties theProps) {
        if (theProps == null) {
            return Core.StringMap.getDefaultInstance();
        }
        Core.StringMap.Builder aBuilder = Core.StringMap.newBuilder();
        for (Map.Entry<Object, Object> aEntry : theProps.entrySet()) {
            aBuilder.addValues(Core.StringMapEntry.newBuilder().setKey(aEntry.getKey().toString()).setValue(aEntry.getValue().toString()).build());
        }
        return aBuilder.build();
    }

    public static Core.StringMap toStringMap(Map<String, String> theProps) {
        Core.StringMap.Builder aBuilder = Core.StringMap.newBuilder();
        for (Map.Entry<String, String> aEntry : theProps.entrySet()) {
            aBuilder.addValues(Core.StringMapEntry.newBuilder().setKey(aEntry.getKey()).setValue(aEntry.getValue()).build());
        }
        return aBuilder.build();
    }

    public static Map<String, String> toStringMap(Core.StringMap theStringMap) {
        HashMap aMap = Maps.newHashMap();
        for (Core.StringMapEntry aEntry : theStringMap.getValuesList()) {
            aMap.put(aEntry.getKey(), aEntry.getValue());
        }
        return aMap;
    }

    public static Core.IntStringMap toIntStringMap(Map<Integer, String> theMap) {
        ArrayList aEntries = Lists.newArrayList();
        for (Map.Entry<Integer, String> aEntry : theMap.entrySet()) {
            aEntries.add(Core.IntStringMapEntry.newBuilder().setKey(aEntry.getKey()).setValue(aEntry.getValue()).build());
        }
        return Core.IntStringMap.newBuilder().addAllValues(aEntries).build();
    }

    public static UUID uuid(Core.UID theId) {
        if (theId == null) {
            return null;
        }
        return new UUID(theId.getMostSigBits(), theId.getLeastSigBits());
    }

    public static char[] toCharArray(ByteString theBytes) {
        if (theBytes == null || theBytes.size() == 0) {
            return new char[0];
        }
        CharBuffer aEncode = Charsets.UTF_8.decode(theBytes.asReadOnlyByteBuffer());
        char[] aChars = new char[aEncode.limit()];
        aEncode.get(aChars);
        return aChars;
    }

    public static Properties toProperties(Core.StringMap theMap) {
        Properties aProperties = new Properties();
        if (theMap == null) {
            return aProperties;
        }
        for (Core.StringMapEntry aEntry : theMap.getValuesList()) {
            aProperties.put(aEntry.getKey(), aEntry.getValue());
        }
        return aProperties;
    }

    public static Map<Integer, String> toIntStringMap(Core.IntStringMap theMap) {
        return Cores.toIntStringMap(theMap.getValuesList());
    }

    public static Map<Integer, String> toIntStringMap(Iterable<Core.IntStringMapEntry> theEntries) {
        HashMap aMap = Maps.newHashMap();
        for (Core.IntStringMapEntry aEntry : theEntries) {
            aMap.put(aEntry.getKey(), aEntry.getValue());
        }
        return aMap;
    }

    public static Core.ListOfStrings toStringList(Collection<String> theStrings) {
        Core.ListOfStrings.Builder aBuilder = Core.ListOfStrings.newBuilder();
        for (String aStr : theStrings) {
            aBuilder.addStrings(aStr);
        }
        return aBuilder.build();
    }
}

