/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.query.sparql;

import com.stardog.stark.BNode;
import com.stardog.stark.IRI;
import com.stardog.stark.Literal;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import com.stardog.stark.query.QueryLanguage;
import javax.annotation.Nonnull;
import org.apache.commons.text.StringEscapeUtils;

public enum SPARQL implements QueryLanguage
{
    Language;


    @Nonnull
    public static String toQueryString(@Nonnull Value theValue) {
        StringBuilder aBuffer = new StringBuilder();
        if (theValue instanceof IRI) {
            IRI aURI = (IRI)theValue;
            aBuffer.append("<").append(aURI.toString()).append(">");
        } else if (theValue instanceof BNode) {
            aBuffer.append("<_:").append(((BNode)theValue).id()).append(">");
        } else if (theValue instanceof Statement) {
            Statement statement = (Statement)theValue;
            aBuffer.append("<< ").append(SPARQL.toQueryString((Value)statement.subject())).append(' ').append(SPARQL.toQueryString((Value)statement.predicate())).append(' ').append(SPARQL.toQueryString(statement.object())).append(' ').append(SPARQL.toQueryString((Value)statement.context())).append(" >>");
        } else if (theValue instanceof Literal) {
            Literal aLit = (Literal)theValue;
            aBuffer.append("\"\"\"").append(SPARQL.escape(aLit.label())).append("\"\"\"").append(aLit.lang().map(l -> "@" + l).orElse(""));
            if (!Literal.isLanguageLiteral((Literal)aLit)) {
                aBuffer.append("^^<").append(aLit.datatypeIRI().toString()).append(">");
            }
        }
        return aBuffer.toString();
    }

    public static String escape(String theString) {
        return StringEscapeUtils.escapeJava((String)theString);
    }

    public String toString() {
        return "SPARQL";
    }
}

