/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.query.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.stardog.stark.query.BindingSet;
import com.stardog.stark.query.SelectQueryResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;

public final class SelectQueryResultImpl
implements SelectQueryResult {
    private final List<BindingSet> mBindings;
    private final List<String> mVars;
    private Iterator<BindingSet> mIterator;
    private boolean mClosed = false;

    public static SelectQueryResult empty() {
        return new SelectQueryResultImpl((List<String>)ImmutableList.of(), (List<BindingSet>)ImmutableList.of());
    }

    public static SelectQueryResult empty(List<String> theVars) {
        return new SelectQueryResultImpl(theVars, (List<BindingSet>)ImmutableList.of());
    }

    public SelectQueryResultImpl(@Nonnull SelectQueryResult theResult) {
        if (theResult instanceof SelectQueryResultImpl) {
            this.mBindings = ((SelectQueryResultImpl)theResult).mBindings;
            this.mVars = ((SelectQueryResultImpl)theResult).mVars;
        } else {
            try {
                this.mVars = theResult.variables();
                this.mBindings = new ArrayList<BindingSet>();
                theResult.stream().forEach(this.mBindings::add);
            }
            finally {
                theResult.close();
            }
        }
        this.mIterator = this.mBindings.iterator();
    }

    public SelectQueryResultImpl(@Nonnull List<String> theVars, @Nonnull List<BindingSet> theBindings) {
        this.mVars = theVars;
        this.mBindings = theBindings;
        this.mIterator = this.mBindings.iterator();
    }

    public void reset() {
        this.mIterator = this.mBindings.iterator();
        this.mClosed = false;
    }

    public int size() {
        return this.mBindings.size();
    }

    @Nonnull
    public BindingSet get(int theIndex) {
        return this.mBindings.get(theIndex);
    }

    @Override
    @Nonnull
    public List<String> variables() {
        return this.mVars;
    }

    @Override
    public void close() throws RuntimeException {
        this.mClosed = true;
        this.mIterator = ImmutableSet.of().iterator();
    }

    @Override
    public boolean hasNext() {
        Preconditions.checkState((!this.mClosed ? 1 : 0) != 0, (Object)"Cannot use closed results");
        return this.mIterator.hasNext();
    }

    @Override
    public BindingSet next() {
        Preconditions.checkState((!this.mClosed ? 1 : 0) != 0, (Object)"Cannot use closed results");
        return this.mIterator.next();
    }
}

