/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.query.impl;

import com.carrotsearch.hppc.ObjectObjectHashMap;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import com.google.common.collect.ImmutableSet;
import com.stardog.stark.Value;
import com.stardog.stark.query.Binding;
import com.stardog.stark.query.BindingSet;
import com.stardog.stark.query.impl.BindingImpl;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class MapBindingSet
implements BindingSet {
    private final ObjectObjectHashMap<String, Value> mBindings;

    public MapBindingSet() {
        this.mBindings = new ObjectObjectHashMap();
    }

    public MapBindingSet(int expectedSize) {
        this.mBindings = new ObjectObjectHashMap(expectedSize);
    }

    public MapBindingSet(Map<String, Value> other) {
        this.mBindings = new ObjectObjectHashMap();
        other.forEach((arg_0, arg_1) -> this.mBindings.put(arg_0, arg_1));
    }

    @Nonnull
    public MapBindingSet add(@Nonnull String theVar, @Nonnull Value theValue) {
        this.mBindings.put((Object)theVar, (Object)theValue);
        return this;
    }

    public String toString() {
        return "[" + StreamSupport.stream(this.mBindings.spliterator(), false).map(e -> String.format("?%s=%s", e.key, e.value)).collect(Collectors.joining(", ")) + "]";
    }

    public boolean equals(Object theObj) {
        if (this == theObj) {
            return true;
        }
        if (!(theObj instanceof BindingSet)) {
            return false;
        }
        BindingSet aBindings = (BindingSet)theObj;
        if (this.size() != aBindings.size()) {
            return false;
        }
        for (Binding aBinding : aBindings) {
            if (aBinding.value().equals((Object)this.get(aBinding.name()))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 0;
        for (ObjectObjectCursor cc : this.mBindings) {
            hashCode ^= ((String)cc.key).hashCode() ^ ((Value)cc.value).hashCode();
        }
        return hashCode;
    }

    @Override
    @Nonnull
    public Set<String> variables() {
        ImmutableSet.Builder set = ImmutableSet.builder();
        this.mBindings.keys().forEach(arg_0 -> ((ImmutableSet.Builder)set).add(arg_0));
        return set.build();
    }

    @Override
    public int size() {
        return this.mBindings.size();
    }

    @Override
    @Nonnull
    public Optional<Value> value(@Nonnull String theVar) {
        return Optional.ofNullable((Value)this.mBindings.get((Object)theVar));
    }

    @Override
    @Nullable
    public Value get(@Nonnull String theVar) {
        return (Value)this.mBindings.get((Object)theVar);
    }

    @Override
    public boolean binds(@Nonnull String theVar) {
        return this.mBindings.containsKey((Object)theVar);
    }

    @Override
    @Nonnull
    public Optional<Binding> binding(@Nonnull String theVar) {
        return Optional.ofNullable((Value)this.mBindings.get((Object)theVar)).map(aValue -> new BindingImpl(theVar, (Value)aValue));
    }

    @Override
    @Nonnull
    public Iterator<Binding> iterator() {
        return new Iterator<Binding>(){
            private int slot = 0;

            @Override
            public boolean hasNext() {
                Object[] keys = MapBindingSet.this.mBindings.keys;
                while (this.slot < keys.length) {
                    if (keys[this.slot] != null) {
                        return true;
                    }
                    ++this.slot;
                }
                return false;
            }

            @Override
            public Binding next() {
                int i = this.slot++;
                return new BindingImpl((String)MapBindingSet.this.mBindings.keys[i], (Value)MapBindingSet.this.mBindings.values[i]);
            }
        };
    }
}

