/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.query;

import com.google.common.collect.Maps;
import com.stardog.stark.BNode;
import com.stardog.stark.Datatype;
import com.stardog.stark.Literal;
import com.stardog.stark.Value;
import com.stardog.stark.XMLCalendar;
import com.stardog.stark.XMLDatatypes;
import com.stardog.stark.query.Binding;
import com.stardog.stark.query.BindingSet;
import com.stardog.stark.query.QueryExecutionFailure;
import com.stardog.stark.query.QueryResult;
import com.stardog.stark.query.SelectQueryResult;
import com.stardog.stark.query.SelectQueryResultHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QueryResults {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryResults.class);

    public static <T> List<T> toList(QueryResult<T> theResult) {
        try (QueryResult<T> aResult = theResult;){
            List list = aResult.stream().collect(Collectors.toList());
            return list;
        }
    }

    public static void report(@Nonnull SelectQueryResult theResult, @Nonnull SelectQueryResultHandler theHandler) {
        theHandler.variables(theResult.variables());
        try (SelectQueryResult aResult = theResult;){
            theHandler.start();
            aResult.forEachRemaining(theHandler::handle);
        }
        theHandler.end();
    }

    @Nonnull
    public static <T> Optional<T> singleResult(@Nonnull QueryResult<T> theResult) {
        try (QueryResult<T> aResult = theResult;){
            if (!theResult.hasNext()) {
                Optional optional = Optional.empty();
                return optional;
            }
            Optional<T> optional = Optional.of(aResult.next());
            return optional;
        }
    }

    public static long size(@Nonnull QueryResult<?> theResult) {
        try (QueryResult<?> aResult = theResult;){
            long l = aResult.stream().count();
            return l;
        }
    }

    public static void consume(@Nonnull QueryResult<?> theResult) {
        try (QueryResult<?> aResult = theResult;){
            while (aResult.hasNext()) {
                aResult.next();
            }
        }
    }

    public static void closeQuietly(@Nonnull QueryResult<?> theResult) {
        try {
            theResult.close();
        }
        catch (Exception e) {
            LOGGER.error("There was an unexpected error while closing the result", (Throwable)e);
        }
    }

    public static boolean equals(@Nonnull SelectQueryResult tqr1, @Nonnull SelectQueryResult tqr2) throws QueryExecutionFailure {
        List list1 = tqr1.stream().collect(Collectors.toList());
        List list2 = tqr2.stream().collect(Collectors.toList());
        return list1.size() == list2.size() && QueryResults.matchBindingSets(list1, list2);
    }

    public static boolean equalsWithOrder(@Nonnull SelectQueryResult tqr1, @Nonnull SelectQueryResult tqr2) {
        List list1 = tqr1.stream().collect(Collectors.toList());
        List list2 = tqr2.stream().collect(Collectors.toList());
        return list1.size() == list2.size() && QueryResults.matchBindingSetsWithFixedOrder(list1, list2);
    }

    public static boolean isSubset(@Nonnull SelectQueryResult tqr1, @Nonnull SelectQueryResult tqr2) throws QueryExecutionFailure {
        List list1 = tqr1.stream().collect(Collectors.toList());
        List list2 = tqr2.stream().collect(Collectors.toList());
        return list1.size() <= list2.size() && QueryResults.matchBindingSets(list1, list2);
    }

    private static boolean matchBindingSets(@Nonnull List<? extends BindingSet> queryResult1, @Nonnull Iterable<? extends BindingSet> queryResult2) {
        return QueryResults.matchBindingSets(queryResult1, queryResult2, new HashMap<BNode, BNode>(), 0);
    }

    private static boolean matchBindingSetsWithFixedOrder(@Nonnull List<? extends BindingSet> queryResult1, @Nonnull List<? extends BindingSet> queryResult2) {
        HashMap bNodeMapping = Maps.newHashMap();
        for (int i = 0; i < queryResult1.size(); ++i) {
            BindingSet bs2;
            BindingSet bs1 = queryResult1.get(i);
            if (!QueryResults.bindingSetsMatch(bs1, bs2 = queryResult2.get(i), bNodeMapping)) {
                return false;
            }
            for (Binding binding : bs1) {
                if (!(binding.value() instanceof BNode)) continue;
                bNodeMapping.put((BNode)binding.value(), bs2.value(binding.name()).orElse(null));
            }
        }
        return true;
    }

    private static boolean matchBindingSets(@Nonnull List<? extends BindingSet> queryResult1, @Nonnull Iterable<? extends BindingSet> queryResult2, @Nonnull Map<BNode, BNode> bNodeMapping, int idx) {
        boolean result = false;
        if (idx < queryResult1.size()) {
            BindingSet bs1 = queryResult1.get(idx);
            List<BindingSet> matchingBindingSets = QueryResults.findMatchingBindingSets(bs1, queryResult2, bNodeMapping);
            for (BindingSet bs2 : matchingBindingSets) {
                HashMap<BNode, BNode> newBNodeMapping = new HashMap<BNode, BNode>(bNodeMapping);
                for (Binding binding : bs1) {
                    if (!(binding.value() instanceof BNode)) continue;
                    newBNodeMapping.put((BNode)binding.value(), bs2.value(binding.name()).orElse(null));
                }
                result = QueryResults.matchBindingSets(queryResult1, queryResult2, newBNodeMapping, idx + 1);
                if (!result) continue;
                break;
            }
        } else {
            result = true;
        }
        return result;
    }

    private static List<BindingSet> findMatchingBindingSets(BindingSet st, Iterable<? extends BindingSet> model, Map<BNode, BNode> bNodeMapping) {
        ArrayList<BindingSet> result = new ArrayList<BindingSet>();
        for (BindingSet bindingSet : model) {
            if (!QueryResults.bindingSetsMatch(st, bindingSet, bNodeMapping)) continue;
            result.add(bindingSet);
        }
        return result;
    }

    private static boolean bindingSetsMatch(BindingSet bs1, BindingSet bs2, Map<BNode, BNode> bNodeMapping) {
        if (bs1.size() != bs2.size()) {
            return false;
        }
        for (Binding binding1 : bs1) {
            Value value1 = binding1.value();
            Value value2 = bs2.value(binding1.name()).orElse(null);
            if (value1 instanceof BNode && value2 instanceof BNode) {
                BNode mappedBNode = bNodeMapping.get(value1);
                if (!(mappedBNode != null ? !value2.equals((Object)mappedBNode) : bNodeMapping.containsValue(value2))) continue;
                return false;
            }
            if (value1 instanceof Literal && value2 instanceof Literal) {
                Literal leftLit = (Literal)value1;
                Literal rightLit = (Literal)value2;
                if (Datatype.datatypesEqual((Literal)leftLit, (Literal)rightLit) && XMLDatatypes.isValidValue((Literal)leftLit) && XMLDatatypes.isValidValue((Literal)rightLit)) {
                    XMLCalendar right;
                    XMLCalendar left;
                    boolean compareResult = false;
                    compareResult = leftLit.datatype() == Datatype.DOUBLE ? Double.compare(Literal.doubleValue((Literal)leftLit), Literal.doubleValue((Literal)rightLit)) == 0 : (leftLit.datatype() == Datatype.FLOAT ? Float.compare(Literal.floatValue((Literal)leftLit), Literal.floatValue((Literal)rightLit)) == 0 : (leftLit.datatype() == Datatype.DECIMAL ? Literal.decimalValue((Literal)leftLit).compareTo(Literal.decimalValue((Literal)rightLit)) == 0 : (XMLDatatypes.isIntegerDatatype((Datatype)leftLit.datatype()) ? Literal.integerValue((Literal)leftLit).compareTo(Literal.integerValue((Literal)rightLit)) == 0 : (leftLit.datatype() == Datatype.BOOLEAN ? Literal.booleanValue((Literal)leftLit) == Literal.booleanValue((Literal)rightLit) : (XMLDatatypes.isCalendarDatatype((Datatype)leftLit.datatype()) ? (left = Literal.xmlCalendarValue((Literal)leftLit)).compare(right = Literal.xmlCalendarValue((Literal)rightLit)) == 0 : value1.equals((Object)value2))))));
                    if (compareResult) continue;
                    return false;
                }
                if (value1.equals((Object)value2)) continue;
                return false;
            }
            if (value1.equals((Object)value2)) continue;
            return false;
        }
        return true;
    }

    private QueryResults() {
        throw new AssertionError();
    }
}

