/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.query;

import java.util.Iterator;
import java.util.Spliterators;
import java.util.function.Consumer;

final class ClosingSpliterator<T>
extends Spliterators.AbstractSpliterator<T> {
    private final Iterator<T> mIter;
    private final Runnable mOnClose;

    public ClosingSpliterator(Iterator<T> theIter, Runnable theOnClose) {
        super(Long.MAX_VALUE, 1280);
        this.mIter = theIter;
        this.mOnClose = theOnClose;
    }

    @Override
    public void forEachRemaining(Consumer<? super T> action) {
        try {
            while (this.mIter.hasNext()) {
                action.accept(this.mIter.next());
            }
        }
        catch (Exception ex) {
            try {
                this.mOnClose.run();
            }
            catch (Exception theE) {
                ex.addSuppressed(theE);
            }
            throw ex;
        }
        this.mOnClose.run();
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        if (this.mIter.hasNext()) {
            action.accept(this.mIter.next());
            return true;
        }
        this.mOnClose.run();
        return false;
    }
}

