/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.io.nquads;

import com.complexible.common.base.Options;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import com.stardog.stark.io.RDFWriter;
import com.stardog.stark.io.RDFWriterFactory;
import com.stardog.stark.io.WriterOptions;
import com.stardog.stark.io.WritingFailed;
import com.stardog.stark.io.ntriples.NTWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.annotation.Nonnull;

public final class NQuadsWriter
implements RDFWriter {
    private final Writer mWriter;
    private final Options mOptions;

    NQuadsWriter(OutputStream theWriter, Options theOptions) {
        this.mWriter = new OutputStreamWriter(theWriter, this.format().charset());
        this.mOptions = theOptions;
    }

    public void comment(@Nonnull String theComment) {
        try {
            this.mWriter.write("# ");
            this.mWriter.write(theComment);
            this.mWriter.write(System.lineSeparator());
        }
        catch (IOException e) {
            throw new WritingFailed("Failed while writing a comment", (Throwable)e);
        }
    }

    public void start() {
    }

    public void namespace(@Nonnull String thePrefix, @Nonnull String theIRI) {
    }

    public void handle(@Nonnull Statement theStmt) {
        try {
            this.serialize((Value)theStmt.subject(), this.mWriter);
            this.mWriter.write(32);
            this.serialize((Value)theStmt.predicate(), this.mWriter);
            this.mWriter.write(32);
            this.serialize(theStmt.object(), this.mWriter);
            if (!Values.isDefaultGraph((Resource)theStmt.context())) {
                this.mWriter.write(32);
                this.serialize((Value)theStmt.context(), this.mWriter);
            }
            this.mWriter.write(" .");
            this.mWriter.write(System.lineSeparator());
        }
        catch (IOException e) {
            throw new WritingFailed("Failed writing statement", (Throwable)e);
        }
    }

    private void serialize(@Nonnull Value theObj, Writer theWriter) throws IOException {
        NTWriter.serialize((Value)theObj, (boolean)this.mOptions.is(WriterOptions.XSD_STRING_TO_PLAIN_LITERAL), (Writer)theWriter);
    }

    public void end() {
        try {
            this.mWriter.flush();
        }
        catch (IOException e) {
            throw new WritingFailed("Unable to flush output after writing is complete", (Throwable)e);
        }
    }

    @Nonnull
    public RDFFormat format() {
        return RDFFormats.NQUADS;
    }

    public static final class NQuadsWriterFactory
    implements RDFWriterFactory {
        @Nonnull
        public RDFFormat format() {
            return RDFFormats.NQUADS;
        }

        @Nonnull
        public RDFWriter create(@Nonnull OutputStream theStream, @Nonnull Options theOptions) {
            return new NQuadsWriter(theStream, theOptions);
        }
    }
}

