/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.spatial;

import com.complexible.common.base.Option;
import com.complexible.stardog.metadata.ConfigProperty;
import com.complexible.stardog.metadata.InfoProperty;
import com.complexible.stardog.metadata.MetaProperty;
import com.complexible.stardog.metadata.MetaPropertyProvider;
import com.complexible.stardog.metadata.OptionsCategory;
import com.complexible.stardog.spatial.Features;
import com.complexible.stardog.spatial.GeospatialIndexState;
import java.util.UUID;

public final class GeospatialOptions
implements MetaPropertyProvider {
    public static final String OPTION_SPATIAL_ENABLED = "spatial.enabled";
    public static final String OPTION_SPATIAL_FEATURES = "spatial.features";
    private static final String OPTION_SPATIAL_INDEX_DIRTY = "spatial.index.dirty";
    private static final String OPTION_SPATIAL_INDEX_STATE = "spatial.index.state";
    private static final String PROP_WRITE_BUFFER_SIZE_IN_MB = "spatial.write.buffer.size";
    private static final String OPTION_SPATIAL_USE_JTS = "spatial.use.jts";
    private static final String OPTION_SPATIAL_PRECISION = "spatial.precision";
    private static final String OPTION_SPATIAL_ERROR_PCT = "spatial.error.percentage";
    private static final String OPTION_RESULT_PAGE_SIZE = "spatial.result.page_size";
    private static final String OPTION_REMOVE_IN_TX = "spatial.remove.in.tx";
    public static final String PROPERTY_OPTIMIZE = "optimize.spatial";
    public static final String PROPERTY_DISTANCE_PRECISION = "spatial.distance.precision";
    public static final int MAX_LEVELS = 11;
    public static final double DEFAULT_ERROR_PCT = 0.025;
    @Deprecated
    public static final ConfigProperty<Boolean> USE_JTS = (ConfigProperty)MetaProperty.config((String)"spatial.use.jts", (Object)false).database().readable().creatable().writable().category(OptionsCategory.SPATIAL).label("Use JTS").description("Use JTS (Java Topology Suite) to support more complex spatial structures such as polygons.").build();
    public static final Option<Integer> WRITE_BUFFER_SIZE = Option.create((String)"spatial.write.buffer.size", (Object)256);
    public static final ConfigProperty<Boolean> SPATIAL_ENABLED = (ConfigProperty)MetaProperty.config((String)"spatial.enabled", (Object)false).database().readable().creatable().writable().category(OptionsCategory.SPATIAL).label("Enable Geospatial Search").description("Enables the geospatial search index for the database.").build();
    @Deprecated
    public static final ConfigProperty<Integer> SPATIAL_PRECISION = (ConfigProperty)MetaProperty.config((String)"spatial.precision", (Object)11).database().readable().creatable().category(OptionsCategory.SPATIAL).label("Geospatial Precision").description("Specifies the precision used for the indexing of geospatial data. The smaller the value, the less precision, but the better the performance of geospatial queries. The default value is 11 which yields sub-meter precision; a value of 8 will give a precision +/- 50m.").build();
    public static final ConfigProperty<Features> FEATURES = (ConfigProperty)MetaProperty.config((String)"spatial.features", (Object)((Object)Features.UNKNOWN)).database().readable().writableWhileOnline().creatable().category(OptionsCategory.SPATIAL).label("Geospatial Features").description("Internally used by the system to keep track of what geospatial features are used in the data.").build();
    @Deprecated
    public static final ConfigProperty<Integer> SPATIAL_DISTANCE_PRECISION = (ConfigProperty)MetaProperty.config((String)"spatial.distance.precision", (Object)8).database().readable().writable().writableWhileOnline().creatable().category(OptionsCategory.SPATIAL).label("Geospatial Distance Precision").description("Specifies the precision used for the distance calculations. The value is the number of significant digits distances used to represent distances. Smaller numbers sacrifice precision for performance. The default is 8. A value of -1 can be provided to compute distances to the maximum precision.").build();
    @Deprecated
    public static final ConfigProperty<Double> SPATIAL_ERROR_PCT = (ConfigProperty)MetaProperty.config((String)"spatial.error.percentage", (Object)0.025).database().readable().creatable().category(OptionsCategory.SPATIAL).label("Geospatial Error Percentage").description("A measure of acceptable error of the shape as a fraction. The value roughly corresponds to the fraction of a shape\u2019s approximate radius. This setting does not affect points which are always indexed at the configured maximum precision as specified by spatial.precision but will affect other shapes. The default value is 0.025 (%2.5) and the valid values are between 0 and 0.5 (50%). Increasing this value will improve query performance as less levels are used but results will be less accurate.").build();
    public static final ConfigProperty<Integer> SPATIAL_RESULT_PAGE_SIZE = (ConfigProperty)MetaProperty.config((String)"spatial.result.page_size", (Object)100000).database().creatable().readable().writable().category(OptionsCategory.SPATIAL).label("Geospatial Result Page Size").description("Specify the page size used for iteration over results from the spatial index. A page is held in memory, so this count should NOT be large.").build();
    @Deprecated
    public static final ConfigProperty<Integer> SPATIAL_RESULT_LIMIT = (ConfigProperty)MetaProperty.config((String)"spatial.result.limit", (Object)10000).database().creatable().readable().writableWhileOnline().category(OptionsCategory.SPATIAL).label("Geospatial Result Limit").description("Specify the default limit on the number of results returned from a geospatial query (-1 returns all results). This only limits the number of results returned from the geospatial index, not from its containing query.").build();
    public static final ConfigProperty<Boolean> OPTIMIZE = (ConfigProperty)MetaProperty.config((String)"optimize.spatial", (Object)false).database().creatable().readable().writableWhileOnline().build();
    public static final ConfigProperty<Boolean> REMOVE_IN_TX = (ConfigProperty)MetaProperty.config((String)"spatial.remove.in.tx", (Object)true).database().creatable().readable().writable().category(OptionsCategory.SPATIAL).label("Remove Immediately").description("If true, remove spatial features from the spatial index immediately within the transaction. Otherwise, spatial features are left in the index until a manual optimization command clear them. Setting this option to false improves update performances significantly but the results from the spatial index should be joined with the RDF index to exclude phantom spatial features from query results.").build();
    @Deprecated
    public static final ConfigProperty<Boolean> SPATIAL_INDEX_DIRTY = (ConfigProperty)MetaProperty.config((String)"spatial.index.dirty", (Object)true).database().readable().writableWhileOnline().build();
    public static final ConfigProperty<GeospatialIndexState> SPATIAL_INDEX_STATE = (ConfigProperty)MetaProperty.config((String)"spatial.index.state", (Object)((Object)GeospatialIndexState.Dirty)).database().readable().writableWhileOnline().build();
    public static final InfoProperty<UUID> LAST_COMMIT_TX = (InfoProperty)MetaProperty.info((String)"spatial.last.tx", UUID.class).index().readable().build();
    public static final MetaProperty<Integer> VERSION = MetaProperty.info((String)"spatial.index.version", (Object)1).readable().build();

    private GeospatialOptions() {
        throw new AssertionError();
    }
}

